/*
 * Decompiled with CFR 0.152.
 */
package ar.com.gs.controladores;

import com.sun.security.auth.callback.DialogCallbackHandler;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DialogTokenPassword
extends DialogCallbackHandler {
    private Component parentComponent;
    private static final int JPasswordFieldLen = 8;
    private static final int JTextFieldLen = 8;
    private JPasswordField password;

    public DialogTokenPassword(char[] claveAcceso) {
        this.password = new JPasswordField(String.valueOf(claveAcceso));
    }

    public DialogTokenPassword(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        ArrayList<Object> messages = new ArrayList<Object>(3);
        ArrayList<Action> okActions = new ArrayList<Action>(2);
        ConfirmationInfo confirmation = new ConfirmationInfo();
        int i = 0;
        while (i < callbacks.length) {
            JLabel prompt;
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback tc = (TextOutputCallback)callbacks[i];
                switch (tc.getMessageType()) {
                    case 0: {
                        confirmation.messageType = 1;
                        break;
                    }
                    case 1: {
                        confirmation.messageType = 2;
                        break;
                    }
                    case 2: {
                        confirmation.messageType = 0;
                        break;
                    }
                    default: {
                        throw new UnsupportedCallbackException(callbacks[i], "Unrecognized message type");
                    }
                }
                messages.add(tc.getMessage());
            } else if (callbacks[i] instanceof NameCallback) {
                final NameCallback nc = (NameCallback)callbacks[i];
                prompt = new JLabel(nc.getPrompt());
                final JTextField name = new JTextField(8);
                String defaultName = nc.getDefaultName();
                if (defaultName != null) {
                    name.setText(defaultName);
                }
                Box namePanel = Box.createHorizontalBox();
                namePanel.add(prompt);
                namePanel.add(name);
                messages.add(namePanel);
                okActions.add(new Action(){

                    @Override
                    public void perform() {
                        nc.setName(name.getText());
                    }
                });
            } else if (callbacks[i] instanceof PasswordCallback) {
                final PasswordCallback pc = (PasswordCallback)callbacks[i];
                prompt = new JLabel(pc.getPrompt());
                this.password.setColumns(8);
                if (!pc.isEchoOn()) {
                    this.password.setEchoChar('*');
                }
                Box passwordPanel = Box.createHorizontalBox();
                passwordPanel.add(prompt);
                passwordPanel.add(this.password);
                messages.add(passwordPanel);
                okActions.add(new Action(){

                    @Override
                    public void perform() {
                        pc.setPassword(DialogTokenPassword.this.password.getPassword());
                    }
                });
            } else if (callbacks[i] instanceof ConfirmationCallback) {
                ConfirmationCallback cc = (ConfirmationCallback)callbacks[i];
                confirmation.setCallback(cc);
                if (cc.getPrompt() != null) {
                    messages.add(cc.getPrompt());
                }
            } else {
                throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
            }
            ++i;
        }
        int result = 0;
        if (result == 0 || result == 0) {
            Iterator iterator = okActions.iterator();
            while (iterator.hasNext()) {
                ((Action)iterator.next()).perform();
            }
        }
        confirmation.handleResult(result);
    }

    private static interface Action {
        public void perform();
    }

    private static class ConfirmationInfo {
        private int[] translations;
        int optionType = 2;
        Object[] options = null;
        Object initialValue = null;
        int messageType = 3;
        private ConfirmationCallback callback;

        private ConfirmationInfo() {
        }

        void setCallback(ConfirmationCallback callback) throws UnsupportedCallbackException {
            this.callback = callback;
            int confirmationOptionType = callback.getOptionType();
            switch (confirmationOptionType) {
                case 0: {
                    this.optionType = 0;
                    int[] nArray = new int[6];
                    nArray[2] = 1;
                    nArray[3] = 1;
                    nArray[4] = -1;
                    nArray[5] = 1;
                    this.translations = nArray;
                    break;
                }
                case 1: {
                    this.optionType = 1;
                    int[] nArray = new int[8];
                    nArray[2] = 1;
                    nArray[3] = 1;
                    nArray[4] = 2;
                    nArray[5] = 2;
                    nArray[6] = -1;
                    nArray[7] = 2;
                    this.translations = nArray;
                    break;
                }
                case 2: {
                    this.optionType = 2;
                    int[] nArray = new int[6];
                    nArray[1] = 3;
                    nArray[2] = 2;
                    nArray[3] = 2;
                    nArray[4] = -1;
                    nArray[5] = 2;
                    this.translations = nArray;
                    break;
                }
                case -1: {
                    this.options = callback.getOptions();
                    this.translations = new int[]{-1, callback.getDefaultOption()};
                    break;
                }
                default: {
                    throw new UnsupportedCallbackException(callback, "Unrecognized option type: " + confirmationOptionType);
                }
            }
            int confirmationMessageType = callback.getMessageType();
            switch (confirmationMessageType) {
                case 1: {
                    this.messageType = 2;
                    break;
                }
                case 2: {
                    this.messageType = 0;
                    break;
                }
                case 0: {
                    this.messageType = 1;
                    break;
                }
                default: {
                    throw new UnsupportedCallbackException(callback, "Unrecognized message type: " + confirmationMessageType);
                }
            }
        }

        void handleResult(int result) {
            if (this.callback == null) {
                return;
            }
            int i = 0;
            while (i < this.translations.length) {
                if (this.translations[i] == result) {
                    result = this.translations[i + 1];
                    break;
                }
                i += 2;
            }
            this.callback.setSelectedIndex(result);
        }
    }
}

