/*
 * Decompiled with CFR 0.152.
 */
package ar.com.gs.controladores;

import ar.com.gs.controladores.CertController;
import ar.com.gs.controladores.TokenConectadoCallback;
import ar.com.gs.entidades.Token;
import java.util.List;
import javax.swing.SwingWorker;

public class WorkerToken
extends SwingWorker<Boolean, Boolean> {
    static volatile WorkerToken workerToken;
    protected static final long SLEEP_TIME = 250L;
    private boolean noEsEtapaFirma = true;
    private boolean esExcluyenteTokenHard;
    private TokenConectadoCallback callback;
    private CertController certController;

    private WorkerToken() {
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        this.certController = CertController.getInstance();
        this.noEsEtapaFirma = true;
        boolean nuevoToken = false;
        this.certController.loadInstalledTokens();
        if (this.esExcluyenteTokenHard && this.certController.getTokens().isEmpty()) {
            this.callback.informarProblemaIrrecuperable("No se detectaron drivers de Token instalados", "Error");
        }
        while (this.noEsEtapaFirma) {
            for (Token t : this.certController.getTokens()) {
                nuevoToken = false;
                try {
                    if (!t.isConnected()) {
                        nuevoToken = this.certController.initiatePkcs11Provider(t);
                    }
                    if (!nuevoToken) continue;
                    this.publish(new Boolean[0]);
                    if (this.certController.getTokens().size() != this.certController.tokensConectados()) continue;
                    return this.noEsEtapaFirma;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Thread.sleep(250L);
        }
        return this.noEsEtapaFirma;
    }

    public boolean esEtapaFirma() {
        return !this.noEsEtapaFirma;
    }

    @Override
    protected void process(List<Boolean> chunks) {
        this.callback.tokenConectado();
    }

    public void setEsEtapaFirma(boolean b) {
        this.noEsEtapaFirma = !b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WorkerToken getInstance() {
        if (workerToken != null) return workerToken;
        Class<WorkerToken> clazz = WorkerToken.class;
        synchronized (WorkerToken.class) {
            if (workerToken != null) return workerToken;
            workerToken = new WorkerToken();
            // ** MonitorExit[var0] (shouldn't be in output)
            return workerToken;
        }
    }

    public void setTokenHardExcluyente() {
        this.esExcluyenteTokenHard = true;
    }

    public void setCallback(TokenConectadoCallback callback) {
        this.callback = callback;
    }

    public void finalizarBusquedaTokens() {
        this.noEsEtapaFirma = false;
    }
}

