/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class JSONUtils {
    private static final Gson gson = new Gson();

    private JSONUtils() {
    }

    public static boolean isJSONValid(String jsonInString) {
        try {
            gson.fromJson(jsonInString, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    public static JsonObject parsearJson(File jsonFile) {
        String fileString = null;
        try {
            fileString = new String(Files.readAllBytes(Paths.get(jsonFile.getAbsolutePath(), new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JsonObject convertedObject = (JsonObject)gson.fromJson(fileString, JsonObject.class);
        return convertedObject;
    }

    public static JsonObject parsearJson(String json) {
        JsonObject convertedObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        return convertedObject;
    }

    public static ArrayList<String> asArrayList(JsonArray fileList) {
        Type listType = new TypeToken<List<String>>(){}.getType();
        return (ArrayList)gson.fromJson((JsonElement)fileList, listType);
    }

    public static HashMap<String, String> asHashMap(JsonObject jsonObject) {
        Type type = new TypeToken<HashMap<String, String>>(){}.getType();
        return (HashMap)gson.fromJson((JsonElement)jsonObject, type);
    }

    public static String toFullString(JsonObject jsonObject) {
        return gson.toJson((JsonElement)jsonObject);
    }
}

