/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarStandalone.vistas;

import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.entidades.EstadoDoc;
import ar.com.lyris.signarStandalone.vistas.ButtonEditor;
import ar.com.lyris.signarStandalone.vistas.ButtonRenderer;
import ar.com.lyris.signarStandalone.vistas.ComponentMover;
import ar.com.lyris.signarStandalone.vistas.DropShadowPanel;
import ar.com.lyris.signarStandalone.vistas.OpcionesFirma;
import ar.com.lyris.signarStandalone.vistas.ProgressWorker;
import ar.com.lyris.signarStandalone.vistas.ValidationMenu;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class Consola
extends JFrame {
    private static volatile Consola consola;
    private static final long serialVersionUID = -7498124298294190916L;
    private JPanel contentPane;
    private JPasswordField passwordField;
    private JButton botonFirmar;
    public JProgressBar progressBar;
    public JLabel labelProgreso;
    private JTable tabla;
    private DefaultTableModel tablaModel;
    private Principal principal = Principal.getInstance();
    public JTextArea txtAreaRazon;
    public JLabel lblRazon;
    private String[] columnas;
    public JComboBox<String> comboTipoPeriodo;
    private JPanel panel;
    Font font;
    Font fontBold;
    private String backgroundColor = "#2669a0";
    private Container tabFirmador;
    public File carpetaDestino;
    private JButton botonChooserDest;
    public JTextField textCarpDest;
    public JCheckBox checkVisible;
    public JCheckBox checkSufijo;
    private boolean existenTokensDeHardware = false;
    private boolean interfazCargada;
    private ProgressWorker progressWorker = ProgressWorker.getInstance();
    private JLabel lblUsuario;
    private JLabel lblFirmadorDeDocumentos;
    public static String razonMessage;

    static {
        razonMessage = "Opcional";
    }

    private Consola() {
        Font font;
        if (Principal.isLinux) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exception) {}
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        focusManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Component component;
                String name;
                String properties = e.getPropertyName();
                if ("focusOwner".equals(properties) && e.getNewValue() != null && "txtAreaRazon".equals(name = (component = (Component)e.getNewValue()).getName())) {
                    if (razonMessage.equals(Consola.this.txtAreaRazon.getText())) {
                        Consola.this.txtAreaRazon.setText("");
                        Consola.this.txtAreaRazon.setForeground(Color.decode("#2C3E50"));
                    } else if ("".equals(Consola.this.txtAreaRazon.getText())) {
                        Consola.this.txtAreaRazon.setText(razonMessage);
                        Consola.this.txtAreaRazon.setForeground(Color.GRAY);
                    }
                }
            }
        });
        int x = 82;
        Font fontSubtitle = font = new Font("Helvetica", 1, 16);
        Font glyph = font;
        Font glyphSubtitle = font;
        InputStream is = Consola.class.getResourceAsStream("/font/Roboto-Regular.ttf");
        try {
            font = Font.createFont(0, is);
            font = font.deriveFont(0, 14.0f);
            fontSubtitle = font.deriveFont(1, 18.0f);
            is = Consola.class.getResourceAsStream("/font/Roboto-Regular.ttf");
            this.fontBold = Font.createFont(0, is);
            this.fontBold = this.fontBold.deriveFont(1, 14.0f);
            is = Consola.class.getResourceAsStream("/font/glyphicons-halflings-regular.ttf");
            glyph = Font.createFont(0, is);
            glyph = glyph.deriveFont(0, 24.0f);
            glyphSubtitle = glyph.deriveFont(0, 14.0f);
        }
        catch (FontFormatException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 983, 476);
        this.setMinimumSize(new Dimension(400, 0));
        this.setUndecorated(true);
        this.getRootPane().setBorder(BorderFactory.createMatteBorder(4, 4, 4, 4, Color.decode(this.backgroundColor)));
        this.contentPane = new JPanel();
        this.contentPane.setBackground(Color.decode("#f6f6f6"));
        this.contentPane.setBorder(null);
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JLabel label = new JLabel();
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(0);
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                Consola.this.principal.finalizar(1);
            }
        });
        label.setForeground(Color.WHITE);
        label.setFont(glyph);
        label.setText(new String(Character.toChars(Integer.parseInt("E014", 16))));
        label.setBounds(941, 3, 37, 45);
        this.contentPane.add(label);
        this.lblFirmadorDeDocumentos = new JLabel("Firmador de documentos");
        this.lblFirmadorDeDocumentos.setVerticalAlignment(3);
        this.lblFirmadorDeDocumentos.setVerticalTextPosition(3);
        this.lblFirmadorDeDocumentos.setFont(font.deriveFont(1, 18.0f));
        this.lblFirmadorDeDocumentos.setForeground(Color.decode("#ffffff"));
        this.lblFirmadorDeDocumentos.setBounds(106, 18, 637, 24);
        this.contentPane.add(this.lblFirmadorDeDocumentos);
        JSeparator separator = new JSeparator();
        JPanel panelMinimizar = new JPanel();
        panelMinimizar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Consola.this.setExtendedState(1);
            }
        });
        if (Principal.EJECUTA_ESQUEMA) {
            this.lblUsuario = new JLabel("Usuario: ");
            this.lblUsuario.setHorizontalAlignment(4);
            this.lblUsuario.setVerticalAlignment(3);
            this.lblUsuario.setForeground(Color.WHITE);
            this.lblUsuario.setFont(this.fontBold.deriveFont(1, 12.0f));
            this.lblUsuario.setBounds(600, 20, 240, 31);
            this.contentPane.add(this.lblUsuario);
        }
        JLabel label_1 = new JLabel("V2.41");
        label_1.setBounds(941, 20, 110, 45);
        label_1.setForeground(Color.WHITE);
        this.contentPane.add(label_1);
        panelMinimizar.setForeground(Color.WHITE);
        panelMinimizar.setOpaque(false);
        panelMinimizar.setBounds(904, 0, 35, 53);
        this.contentPane.add(panelMinimizar);
        separator.setBorder(new MatteBorder(0, 0, 4, 0, new Color(255, 255, 255)));
        separator.setBackground(Color.decode("#2C3E50"));
        separator.setForeground(Color.decode("#2C3E50"));
        separator.setBounds(909, 3, 26, 9);
        this.contentPane.add(separator);
        this.tabFirmador = new JPanel();
        this.tabFirmador.setBounds(15, 186, 416, 276);
        this.tabFirmador.setBackground(Color.decode("#ECF0F1"));
        this.tabFirmador.setLayout(null);
        if (!Principal.EJECUTA_ESQUEMA) {
            JLabel lblCarpDest = new JLabel("Carpeta de destino");
            lblCarpDest.setFont(this.fontBold);
            lblCarpDest.setForeground(Color.decode("#2C3E50"));
            lblCarpDest.setBounds(15, 53, 216, 29);
            this.tabFirmador.add(lblCarpDest);
            JLabel lblFirmaVisible = new JLabel("Firma invisible");
            lblFirmaVisible.setFont(this.fontBold);
            lblFirmaVisible.setForeground(Color.decode("#2C3E50"));
            this.tabFirmador.add(lblFirmaVisible);
            this.botonChooserDest = new JButton("+");
            this.botonChooserDest.setBorder(new MatteBorder(2, 0, 2, 2, new Color(220, 228, 236)));
            this.botonChooserDest.setBackground(Color.decode("#2C3E50"));
            this.botonChooserDest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Consola.this.principal.elegirCarpetaDestino();
                }
            });
            this.botonChooserDest.setFont(this.fontBold);
            this.botonChooserDest.setEnabled(true);
            this.botonChooserDest.setBounds(366, 51, 35, 29);
            this.tabFirmador.add(this.botonChooserDest);
            this.textCarpDest = new JTextField("");
            this.textCarpDest.setHorizontalAlignment(2);
            this.textCarpDest.setEditable(true);
            this.textCarpDest.setFont(font);
            this.textCarpDest.setName("");
            this.textCarpDest.setForeground(Color.GRAY);
            this.textCarpDest.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 0, new Color(220, 228, 236)), new EmptyBorder(0, 5, 0, 0)));
            this.textCarpDest.setBounds(200, 51, 165, 29);
            this.textCarpDest.setBackground(Color.WHITE);
            this.textCarpDest.setVisible(true);
            this.tabFirmador.add(this.textCarpDest);
        }
        if (!Principal.EJECUTA_ESQUEMA) {
            JButton btnAgregarArchivos = new JButton("Agregar Documentos");
            btnAgregarArchivos.setFocusTraversalPolicyProvider(true);
            btnAgregarArchivos.setBorder(null);
            btnAgregarArchivos.setBackground(Color.decode(this.backgroundColor));
            btnAgregarArchivos.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Consola.this.principal.AgregarDocumentos();
                }
            });
            btnAgregarArchivos.setFont(this.fontBold);
            btnAgregarArchivos.setEnabled(true);
            btnAgregarArchivos.setBounds(15, 235, 185, 29);
            this.tabFirmador.add(btnAgregarArchivos);
        }
        if (!Principal.EJECUTA_ESQUEMA) {
            JButton btnValidarFirmaXML = new JButton("Validar firma XML");
            btnValidarFirmaXML.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new ValidationMenu(Consola.this.principal).setVisible(true);
                        }
                    });
                }
            });
            btnValidarFirmaXML.setFocusTraversalPolicyProvider(true);
            btnValidarFirmaXML.setBorder(null);
            btnValidarFirmaXML.setBackground(Color.decode(this.backgroundColor));
            btnValidarFirmaXML.setFont(this.fontBold);
            btnValidarFirmaXML.setEnabled(true);
            btnValidarFirmaXML.setBounds(15, 200, 185, 29);
            this.tabFirmador.add(btnValidarFirmaXML);
        }
        if (!Principal.EJECUTA_ESQUEMA) {
            JButton btnConfigurarFirma = new JButton("Configurar firma");
            btnConfigurarFirma.setFocusTraversalPolicyProvider(true);
            btnConfigurarFirma.setBorder(null);
            btnConfigurarFirma.setBackground(Color.decode(this.backgroundColor));
            btnConfigurarFirma.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new OpcionesFirma(Consola.this.principal).setVisible(true);
                        }
                    });
                }
            });
            btnConfigurarFirma.setFont(this.fontBold);
            btnConfigurarFirma.setEnabled(true);
            btnConfigurarFirma.setBounds(216, 200, 185, 29);
            this.tabFirmador.add(btnConfigurarFirma);
        }
        JLabel lblClave = new JLabel("Clave acceso dispositivo");
        lblClave.setFont(this.fontBold);
        lblClave.setForeground(Color.decode("#2C3E50"));
        lblClave.setBounds(15, 15, 216, 29);
        this.tabFirmador.add(lblClave);
        this.passwordField = new JPasswordField(""){
            private static final long serialVersionUID = 872952887924187051L;

            @Override
            public void addNotify() {
                super.addNotify();
                this.requestFocusInWindow();
            }
        };
        this.passwordField.setEditable(true);
        this.passwordField.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)), new EmptyBorder(0, 5, 0, 0)));
        this.passwordField.setBounds(201, 15, 200, 29);
        this.passwordField.setForeground(Color.BLACK);
        this.passwordField.setEchoChar('\u25cf');
        this.tabFirmador.add(this.passwordField);
        JLabel lblSufijoEj1 = new JLabel("<html>ejemplo<font color='red'>-f</font>.pdf</html>");
        lblSufijoEj1.setFont(font);
        this.tabFirmador.add(lblSufijoEj1);
        this.botonFirmar = new JButton("Firmar");
        this.botonFirmar.setFocusTraversalPolicyProvider(true);
        this.botonFirmar.setBorder(null);
        this.botonFirmar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (((Consola)Consola.this).principal.banderaFin) {
                    Consola.this.principal.finalizar(1);
                } else if (Consola.this.comprobarSiSePuedeFirmar()) {
                    Consola.this.botonFirmar.setEnabled(false);
                    new Thread(){

                        @Override
                        public void run() {
                            Consola.this.principal.firmar();
                        }
                    }.start();
                }
            }
        });
        this.botonFirmar.setFont(this.fontBold);
        this.botonFirmar.setEnabled(false);
        if (Principal.EJECUTA_ESQUEMA) {
            this.botonFirmar.setBounds(114, 235, 185, 29);
        } else {
            this.botonFirmar.setBounds(216, 235, 185, 29);
        }
        this.tabFirmador.add(this.botonFirmar);
        JLabel imagen = new JLabel("");
        imagen.setBounds(2, 0, 100, 53);
        this.contentPane.add(imagen);
        try {
            imagen.setIcon(new ImageIcon(Consola.resize(ImageIO.read(this.getClass().getResource("/img/logo-navbar_min.png")), 90, 25)));
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("/img/icon.png")));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.setTitle("Signar Standalone");
        JLabel titleBar = new JLabel("");
        titleBar.setBackground(Color.decode(this.backgroundColor));
        titleBar.setOpaque(true);
        titleBar.setBorder(null);
        titleBar.setBounds(0, 0, 1245, 53);
        this.contentPane.add(titleBar);
        DropShadowPanel SombraTitleBar = new DropShadowPanel(7);
        SombraTitleBar.setBounds(-5, 0, 1010, 60);
        this.contentPane.add(SombraTitleBar);
        SombraTitleBar.setLayout(null);
        new ComponentMover(this, titleBar);
        this.panel = new JPanel();
        this.panel.setBounds(12, 0, 950, 551);
        this.panel.setBackground(Color.WHITE);
        this.contentPane.add(this.panel);
        this.panel.setLayout(null);
        JLabel lblConfiguracion = new JLabel("Parametros de firmado");
        lblConfiguracion.setForeground(Color.decode("#2C3E50"));
        lblConfiguracion.setFont(fontSubtitle);
        lblConfiguracion.setBounds(38, 157, 291, 32);
        this.panel.add(lblConfiguracion);
        this.panel.add(this.tabFirmador);
        JLabel lblProgreso = new JLabel("Progreso");
        lblProgreso.setForeground(Color.decode("#2669a0"));
        lblProgreso.setFont(fontSubtitle);
        lblProgreso.setBounds(38, 60, 112, 24);
        this.panel.add(lblProgreso);
        JLabel lblDocumentosYEstados = new JLabel("Documentos y estados");
        lblDocumentosYEstados.setForeground(Color.decode("#2C3E50"));
        lblDocumentosYEstados.setFont(fontSubtitle);
        lblDocumentosYEstados.setBounds(447, 60, 328, 29);
        this.panel.add(lblDocumentosYEstados);
        JPanel progressHolder = new JPanel();
        progressHolder.setBackground(Color.decode("#ECF0F1"));
        progressHolder.setBounds(15, 86, 416, 67);
        this.panel.add(progressHolder);
        progressHolder.setLayout(null);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(15, 30, 386, 29);
        this.progressBar.setBackground(Color.white);
        this.progressBar.setForeground(Color.decode(this.backgroundColor));
        this.progressBar.setFont(this.fontBold);
        progressHolder.add(this.progressBar);
        this.progressBar.setStringPainted(true);
        this.progressBar.setName("");
        this.labelProgreso = new JLabel("Token no detectado. Insertelo para continuar");
        this.labelProgreso.setBounds(15, 2, 386, 29);
        progressHolder.add(this.labelProgreso);
        this.labelProgreso.setForeground(Color.RED);
        this.labelProgreso.setFont(this.fontBold);
        JLabel glyphProgreso = new JLabel("");
        glyphProgreso.setForeground(Color.decode("#2C3E50"));
        glyphProgreso.setFont(glyphSubtitle);
        glyphProgreso.setText(new String(Character.toChars(Integer.parseInt("E031", 16))));
        glyphProgreso.setBounds(20, 62, 60, 20);
        this.panel.add(glyphProgreso);
        JLabel glyphParametro = new JLabel("");
        glyphParametro.setForeground(Color.decode("#2C3E50"));
        glyphParametro.setFont(glyphSubtitle);
        glyphParametro.setText(new String(Character.toChars(Integer.parseInt("E136", 16))));
        glyphParametro.setBounds(20, 164, 60, 20);
        this.panel.add(glyphParametro);
        DropShadowPanel panelDeSombra = new DropShadowPanel(3);
        panelDeSombra.setBounds(9, 0, 956, 551);
        this.contentPane.add(panelDeSombra);
        if (this.existenTokensDeHardware) {
            this.updateTokenStatus();
        }
        this.actualizarAreaYTabla();
        this.interfazCargada = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Consola getInstance() {
        if (consola != null) return consola;
        Class<Consola> clazz = Consola.class;
        synchronized (Consola.class) {
            if (consola != null) return consola;
            consola = new Consola();
            // ** MonitorExit[var0] (shouldn't be in output)
            return consola;
        }
    }

    protected boolean comprobarSiSePuedeFirmar() {
        if (!EsquemaController.ESQUEMA_EN_TEST && this.passwordField.getPassword().length == 0) {
            Consola.mostrarMensaje("Ingrese una clave", "");
            return false;
        }
        return true;
    }

    public void actualizarAreaYTabla() {
        if (!Principal.EJECUTA_ESQUEMA) {
            this.lblRazon = new JLabel("Raz\u00f3n de la firma");
            this.lblRazon.setFont(this.fontBold);
            this.lblRazon.setForeground(Color.decode("#2C3E50"));
            this.lblRazon.setBounds(15, 85, 190, 29);
            this.tabFirmador.add(this.lblRazon);
            this.txtAreaRazon = new JTextArea(razonMessage);
            this.txtAreaRazon.setLineWrap(true);
            this.txtAreaRazon.setFont(this.font);
            this.txtAreaRazon.setName("txtAreaRazon");
            this.txtAreaRazon.setForeground(Color.GRAY);
            this.txtAreaRazon.setBorder(new EmptyBorder(0, 5, 0, 0));
            JScrollPane sp = new JScrollPane(this.txtAreaRazon);
            sp.setBounds(13, 110, 388, 41);
            sp.setBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)));
            this.tabFirmador.add(sp);
        }
        this.inicializarTabla();
    }

    public void inicializarTabla() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setOpaque(false);
        scrollPane.setBorder(new MatteBorder(2, 2, 2, 2, new Color(220, 228, 236)));
        scrollPane.getViewport().setBackground(Color.WHITE);
        scrollPane.setBounds(446, 86, 489, 375);
        scrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.panel.add(scrollPane);
        scrollPane.setAutoscrolls(true);
        this.tabla = new JTable(){
            private static final long serialVersionUID = -6178446841435519184L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component returnComp = super.prepareRenderer(renderer, row, column);
                Color alternateColor = new Color(250, 250, 250);
                Color whiteColor = Color.WHITE;
                if (!returnComp.getBackground().equals(this.getSelectionBackground())) {
                    Color bg = row % 2 == 0 ? whiteColor : alternateColor;
                    returnComp.setBackground(bg);
                    bg = null;
                }
                return returnComp;
            }

            public Class getColumnClass(int column) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return super.isCellEditable(row, column);
            }

            @Override
            public String getToolTipText(MouseEvent e) {
                String tip = null;
                return tip;
            }
        };
        this.columnas = Principal.EJECUTA_ESQUEMA ? "Nro;Documento;Estado".split(";") : "Nro;Documento;Estado;Quitar".split(";");
        this.tabla.setModel(this.setTablaModel(new DefaultTableModel(null, this.columnas)));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(4);
        this.tabla.getColumnModel().getColumn(0).setCellRenderer(renderer);
        this.tabla.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.tabla.getColumnModel().getColumn(0).setMaxWidth(300);
        this.tabla.getColumnModel().getColumn(0).setMinWidth(40);
        this.tabla.getColumnModel().getColumn(1).setMinWidth(80);
        this.tabla.getColumnModel().getColumn(1).setPreferredWidth(130);
        this.tabla.getColumnModel().getColumn(2).setMaxWidth(200);
        this.tabla.getColumnModel().getColumn(2).setPreferredWidth(120);
        this.tabla.getColumnModel().getColumn(2).setMinWidth(100);
        if (!Principal.EJECUTA_ESQUEMA) {
            this.tabla.getColumnModel().getColumn(3).setCellRenderer(new ButtonRenderer());
            this.tabla.getColumnModel().getColumn(3).setCellEditor(new ButtonEditor(new JCheckBox(), this.principal));
            this.tabla.getColumnModel().getColumn(3).setMaxWidth(50);
        }
        this.tabla.doLayout();
        this.tabla.setBorder(BorderFactory.createEmptyBorder());
        this.tabla.setShowGrid(false);
        this.tabla.setBackground(Color.WHITE);
        this.tabla.setRowSelectionAllowed(false);
        this.tabla.setForeground(Color.decode("#2C3E50"));
        this.tabla.setFont(this.font);
        this.tabla.setIntercellSpacing(new Dimension(0, 0));
        this.tabla.getTableHeader().setBackground(Color.decode("#ECF0F1"));
        this.tabla.getTableHeader().setForeground(Color.decode("#2C3E50"));
        this.tabla.getTableHeader().setFont(this.fontBold.deriveFont(1, 13.0f));
        this.tabla.getTableHeader().setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.decode("#ECF0F1")));
        this.tabla.setRowHeight(20);
        scrollPane.setViewportView(this.tabla);
    }

    public void refrescarTabla() {
        if (this.tabla != null) {
            int docsProcesados = this.principal.getDocsProcesados();
            int cantDocs = this.principal.getCantDocumentos();
            this.setLabelBarra(String.valueOf(this.principal.estadoApp.getNombre()) + " documentos (" + docsProcesados + "/" + cantDocs + "):");
            this.progressWorker.refrescarSinDelay();
            ((DefaultTableModel)this.tabla.getModel()).setRowCount(cantDocs);
            this.refrescarIdTabla("ALL");
        }
    }

    public void refrescarIdTabla(String id) {
        boolean updateAll = id.equals("ALL");
        if (this.tabla == null) {
            return;
        }
        int i = 0;
        while (i < this.principal.getCantDocumentos()) {
            Documento doc = this.principal.getDocumentos().get(i);
            if (updateAll || doc.getId() == id) {
                this.tabla.setValueAt(doc.getId(), i, 0);
                this.tabla.setValueAt(doc.getFileName(), i, 1);
                this.tabla.setValueAt((Object)doc.getEstado(), i, 2);
            }
            ++i;
        }
    }

    public void habilitarFirmado() {
        boolean todosDocsCargados;
        boolean bl = todosDocsCargados = this.principal.getCantDocEnEstados(EstadoDoc.CARGADO) == this.principal.getCantDocumentos();
        if (Principal.EJECUTA_ESQUEMA && todosDocsCargados || this.existenTokensDeHardware && this.principal.getCantDocumentos() > 0 && this.carpetaDestino != null) {
            this.progressWorker.cancel(true);
            this.progressWorker.isDone();
            this.progressBar.setValue(100);
            this.botonFirmar.setBackground(Color.decode(this.backgroundColor));
            this.botonFirmar.setEnabled(true);
        }
    }

    public void deshabilitarFirmado() {
        this.botonFirmar.setBackground(Color.LIGHT_GRAY);
        this.botonFirmar.setEnabled(false);
    }

    public DefaultTableModel getTablaModel() {
        return this.tablaModel;
    }

    public DefaultTableModel setTablaModel(DefaultTableModel tablaModel) {
        this.tablaModel = tablaModel;
        return tablaModel;
    }

    public static BufferedImage resize(Object img, int percent) {
        BufferedImage buff = (BufferedImage)img;
        return Consola.resize(buff, 45, 79);
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public String getRazonText() {
        return this.txtAreaRazon.getText();
    }

    public void finalizacion(String tipoDeFinalizacion) {
        this.progressWorker.cancel(true);
        this.progressWorker.isDone();
        this.labelProgreso.setText("El programa finalizo " + tipoDeFinalizacion);
        this.progresoCompleto();
    }

    public void setLabelBarra(String string) {
        if (this.labelProgreso != null) {
            this.labelProgreso.setText(string);
        }
    }

    public void setProgress(int i, int nroDocs) {
        if (i == 0 && nroDocs == 0) {
            this.progressBar.setValue(0);
        }
    }

    private static void mostrarMensaje(String mensaje, String tipo) {
        System.out.println(mensaje);
        JOptionPane.showMessageDialog(null, mensaje);
    }

    public void informarFallo(String string) {
        JOptionPane.showMessageDialog(this, string, "Insane error", 0);
    }

    public void progresoCompleto() {
        this.progressBar.setValue(100);
    }

    public void noDriver() {
        this.informarFallo("No se encontraron los drivers. Instale y vuelva a iniciar");
        this.principal.finalizar(0);
    }

    public void setCarpetaDestino(File f) {
        this.carpetaDestino = f;
        if (!f.exists()) {
            f.mkdir();
        }
        this.textCarpDest.setText(f.getAbsolutePath());
        this.habilitarFirmado();
    }

    public void removerFila(int isPushed) {
        String id = (String)this.tabla.getValueAt(isPushed, 0);
        for (Documento c : this.principal.getDocumentos()) {
            if (c.getId() != id) continue;
            this.principal.getDocumentos().remove(c);
        }
        this.tablaModel.removeRow(isPushed);
    }

    public void updateTokenStatus() {
        this.labelProgreso.setText("Token detectado");
        this.labelProgreso.setForeground(Color.decode("#006400"));
        this.habilitarFirmado();
    }

    public void nuevoTokenConectado() {
        this.existenTokensDeHardware = true;
        if (this.interfazCargada) {
            this.updateTokenStatus();
        }
    }

    public void updateUser(String string) {
        this.lblUsuario.setText("Usuario: " + string);
    }

    public void updateTitle(String string) {
        this.lblFirmadorDeDocumentos.setText(string);
    }
}

