/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarStandalone.utils.JSONUtils;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.WorkerSubida;
import com.google.gson.JsonObject;
import java.util.HashMap;

public class DestinationsController {
    public static final int DESTINO_SUBIDA = 0;
    public static volatile DestinationsController destinationsController;
    private WorkerSubida workerSubida;
    private EsquemaController esquemaController = EsquemaController.getInstance();
    public final int metodoEjecucion = 0;

    private DestinationsController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DestinationsController getInstance() {
        if (destinationsController != null) return destinationsController;
        Class<DestinationsController> clazz = DestinationsController.class;
        synchronized (DestinationsController.class) {
            if (destinationsController != null) return destinationsController;
            destinationsController = new DestinationsController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return destinationsController;
        }
    }

    public void procesarDestinos(JsonObject jsonData) {
        String fileField;
        JsonObject remote;
        if (jsonData.getAsJsonObject("remote") != null) {
            this.workerSubida = WorkerSubida.getInstance();
            remote = jsonData.getAsJsonObject("remote");
            this.workerSubida.setURL(remote.get("URI").getAsString());
            this.workerSubida.setMethod(remote.get("method").getAsString());
            fileField = remote.get("fileField").getAsString();
            if (fileField.contains("$")) {
                fileField = this.esquemaController.parseParameters(fileField);
            }
            this.workerSubida.setFileField(fileField);
            this.parseFormFields(remote.get("formFields").getAsJsonObject());
            HashMap<String, String> destinationHeaders = JSONUtils.asHashMap(remote.getAsJsonObject("headers"));
            if (destinationHeaders != null) {
                this.computarHeaders(destinationHeaders);
            }
        }
        if (jsonData.getAsJsonObject("signatureFootprint") != null) {
            remote = jsonData.getAsJsonObject("signatureFootprint");
            this.workerSubida = WorkerSubida.getInstance();
            fileField = remote.get("URI").getAsString();
            if (fileField.contains("$")) {
                fileField = this.esquemaController.parseParameters(fileField);
            }
            this.workerSubida.habilitarRastroDeFirma(fileField);
        }
    }

    private void parseFormFields(JsonObject jsonElement) {
        HashMap<String, String> fields = JSONUtils.asHashMap(jsonElement);
        HashMap auxFields = (HashMap)fields.clone();
        fields.forEach((key, value) -> {
            String valAux = value;
            if (value.contains("{$FILE_ID}")) {
                valAux = value.replace("{$FILE_ID}", "{FILE_ID}");
                if (valAux.contains("$")) {
                    valAux = this.esquemaController.parseParameters(valAux);
                }
                this.workerSubida.setFormFieldWithFileID((String)key, valAux.replace("{FILE_ID}", "{$FILE_ID}"));
                auxFields.remove(key);
            } else if (valAux.contains("$")) {
                valAux = this.esquemaController.parseParameters(valAux);
                auxFields.put(key, valAux);
            }
        });
        this.workerSubida.setFormFields(auxFields);
    }

    void computarHeaders(HashMap<String, String> destinationheaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(this.esquemaController.getDefaultHeaders());
        destinationheaders.forEach((key, value) -> {
            if (value.contains("$")) {
                String newValue = this.esquemaController.parseParameters((String)value);
                destinationheaders.put((String)key, newValue);
                headers.put((String)key, newValue);
            } else {
                headers.put((String)key, (String)value);
            }
        });
        this.workerSubida.setHeaders(headers);
    }

    public void iniciarSubida() {
        this.workerSubida.execute();
    }
}

