/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.gs.controladores.CertController;
import ar.com.lyris.signarStandalone.entidades.ConfigFirmaPDF;
import ar.com.lyris.signarStandalone.entidades.EstadoApp;
import ar.com.lyris.signarStandalone.utils.JSONUtils;
import ar.com.lyris.signarStandalone.vistas.Consola;
import ar.com.lyris.signarestandalone.controladores.DestinationsController;
import ar.com.lyris.signarestandalone.controladores.OriginsController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;

public class EsquemaController {
    public static volatile EsquemaController esquemaController;
    private static final Pattern PatronVarPeso;
    private CertController certController;
    private OriginsController originsController;
    private DestinationsController destinationsController;
    private File esquema;
    private String esquemaURL;
    private HashMap<String, String> sharedHeaders;
    private JsonObject parametros;
    private ConfigFirmaPDF configFirmaPDF;
    private boolean unirestIniciado = false;
    public static boolean ESQUEMA_EN_TEST;
    private HashMap<String, String> defaultHeaders;

    static {
        PatronVarPeso = Pattern.compile("\\$\\w+");
        ESQUEMA_EN_TEST = false;
    }

    private EsquemaController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EsquemaController getInstance() {
        if (esquemaController != null) return esquemaController;
        Class<EsquemaController> clazz = EsquemaController.class;
        synchronized (EsquemaController.class) {
            if (esquemaController != null) return esquemaController;
            esquemaController = new EsquemaController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return esquemaController;
        }
    }

    public void inicializar() throws Exception {
        JsonObject esquemaJson;
        if (!this.existeEsquema()) {
            this.descargarEsquema();
        }
        if (this.firmaEsquemaEsValida(esquemaJson = JSONUtils.parsearJson(this.esquema))) {
            JsonObject data = esquemaJson.getAsJsonObject("data");
            if (data.get("signatureType").getAsString().equals("PDF")) {
                this.procesarFirmaPDF(data.getAsJsonObject("pdfSignatureConfig"));
            }
            if (data.get("certConfig") != null) {
                this.certController = CertController.getInstance();
                this.procesarCertConfig(data.getAsJsonObject("certConfig").get("certificateLocation").getAsJsonArray());
            }
            if (data.get("fileOrigins") != null) {
                this.configUnirest();
                this.parseHeaders(data.getAsJsonObject("sharedHeaders"));
                this.originsController = OriginsController.getInstance();
                this.originsController.procesarOrigenes(data.getAsJsonObject("fileOrigins"));
                this.ejecutarOrigen();
            }
            if (data.get("fileDestination") != null) {
                this.configUnirest();
                this.parseHeaders(data.getAsJsonObject("sharedHeaders"));
                this.destinationsController = DestinationsController.getInstance();
                this.destinationsController.procesarDestinos(data.getAsJsonObject("fileDestination"));
            }
            if (data.get("interfaz") != null) {
                Consola c = Consola.getInstance();
                if (data.getAsJsonObject("interfaz").get("username") != null) {
                    String username = data.getAsJsonObject("interfaz").get("username").getAsString();
                    if (username.contains("$")) {
                        username = this.parseParameters(username);
                    }
                    c.updateUser(username);
                }
                if (data.getAsJsonObject("interfaz").get("title") != null) {
                    String title = data.getAsJsonObject("interfaz").get("title").getAsString();
                    if (title.contains("$")) {
                        title = this.parseParameters(title);
                    }
                    c.updateTitle(title);
                }
            }
        } else {
            Principal.getInstance().informarProblemaIrrecuperable("No se pudo verificar la autenticidad del esquema", "Error irrecuperable");
        }
    }

    private void configUnirest() {
        if (!this.unirestIniciado) {
            Unirest.config().followRedirects(false).enableCookieManagement(false);
        }
        this.unirestIniciado = true;
        this.defaultHeaders = new HashMap();
        this.defaultHeaders.put("Accept", "application/json");
        this.defaultHeaders.put("User-Agent", "SignarStandalone");
    }

    private void parseHeaders(JsonObject data) {
        if (data == null) {
            return;
        }
        if (this.sharedHeaders == null) {
            this.sharedHeaders = JSONUtils.asHashMap(data);
            this.sharedHeaders.forEach((key, value) -> {
                String newValue = value;
                if (value.contains("$")) {
                    newValue = esquemaController.parseParameters((String)value);
                }
                Unirest.config().setDefaultHeader(key, newValue);
            });
        }
    }

    private void procesarCertConfig(JsonArray array) {
        boolean tokenOnly;
        boolean bl = tokenOnly = array.size() == 1 && array.get(0).getAsString().equals("HWTOKEN");
        if (tokenOnly) {
            this.certController.esExcluyenteTokenHard();
        }
    }

    private void procesarFirmaPDF(JsonObject jsonObject) {
        this.configFirmaPDF = ConfigFirmaPDF.getInstance();
        if (jsonObject.get("reason") != null) {
            String razon = this.procesarRazon(jsonObject.get("reason").getAsString());
            this.configFirmaPDF.setRazon(razon);
        }
        if (jsonObject.get("VisibilityConfig") != null) {
            JsonObject visibilityConfig = jsonObject.get("VisibilityConfig").getAsJsonObject();
            String paginaDeFirma = visibilityConfig.get("signaturePage").getAsString();
            this.configFirmaPDF.setModoFirmado(paginaDeFirma);
            if (visibilityConfig.get("coordinates") != null) {
                this.configFirmaPDF.setCoordenadas(visibilityConfig.get("coordinates").getAsJsonArray());
            }
        }
    }

    private String procesarRazon(String razon) {
        if (razon.contains("{$Date}")) {
            LocalDateTime localDateTime = LocalDateTime.now();
            String date = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).format(localDateTime);
            System.out.println(date);
            razon = razon.replace("{$Date}", date);
        }
        if (razon.contains("$")) {
            razon = this.parseParameters(razon);
        }
        return razon;
    }

    private boolean firmaEsquemaEsValida(JsonObject esquemaJson) {
        Boolean templateEnTest = esquemaJson.getAsJsonPrimitive("templateVersion").getAsString().equals("test");
        if (templateEnTest.booleanValue()) {
            JsonObject data = esquemaJson.getAsJsonObject("data").getAsJsonObject("template");
            ESQUEMA_EN_TEST = templateEnTest;
            return true;
        }
        JsonObject data = esquemaJson.getAsJsonObject("data");
        JsonPrimitive signature = esquemaJson.getAsJsonPrimitive("signature");
        try {
            PublicKey pubKey = this.cargarPubKey();
            String hashFirmado = signature.getAsString();
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, pubKey);
            byte[] descifrado = cipher.doFinal(Base64.decode(hashFirmado));
            String hashDescifrado = Base64.encode(descifrado);
            System.out.println("Hash descifrado: " + hashDescifrado);
            String textoFirmado = JSONUtils.toFullString(data);
            System.out.println(textoFirmado);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String encodedhash = Base64.encode(digest.digest(textoFirmado.getBytes(StandardCharsets.UTF_8)));
            System.out.println("Hash del data: " + encodedhash);
            return hashDescifrado.equals(encodedhash);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private PublicKey cargarPubKey() throws IOException, URISyntaxException, NoSuchAlgorithmException, InvalidKeySpecException {
        InputStream is = EsquemaController.class.getResourceAsStream("/firma/pkey.pub");
        String pubKeyString = new BufferedReader(new InputStreamReader(is)).lines().collect(Collectors.joining("\n"));
        byte[] publicBytes = DatatypeConverter.parseBase64Binary((String)pubKeyString);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(new X509EncodedKeySpec(publicBytes));
    }

    private void descargarEsquema() throws Exception {
        this.configUnirest();
        GetRequest request = Unirest.get((String)this.esquemaURL);
        System.out.println("preparing 'GET' request to URL : " + request.getUrl());
        HttpResponse response = request.asBytes();
        System.out.println(response.getStatus());
        if (response.getStatus() == 200) {
            String dirName = String.valueOf(System.getProperty("user.home")) + File.separator + ".lyris";
            File theDir = new File(dirName);
            if (!theDir.exists()) {
                System.out.println("creating directory: " + dirName);
                try {
                    theDir.mkdir();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            File f = new File(this.getLocalAbsolutePath());
            ReadableByteChannel rbc = Channels.newChannel(new ByteArrayInputStream((byte[])response.getBody()));
            try {
                String inputLine;
                FileOutputStream fos = new FileOutputStream(f);
                fos.getChannel().transferFrom(rbc, 0L, 0x1000000L);
                fos.close();
                BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream((byte[])response.getBody())));
                StringBuffer responseFile = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    responseFile.append(inputLine);
                }
                in.close();
                this.esquema = f;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new Exception("No se encontr\u00f3 el recurso web, no se puede continuar.");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Exception("Hubo un problema descargando los datos del recurso.");
            }
        }
    }

    private boolean existeEsquema() {
        File f = new File(this.getLocalAbsolutePath());
        if (f.exists()) {
            this.esquema = f;
            return true;
        }
        return false;
    }

    private String getLocalAbsolutePath() {
        String dir = System.getProperty("user.home");
        String fileName = this.esquemaURL.substring(this.esquemaURL.lastIndexOf(47) + 1, this.esquemaURL.length());
        return String.valueOf(dir) + "/.lyris/" + fileName;
    }

    public void setUrlEsquema(String url) throws URISyntaxException, MalformedURLException {
        URL u = new URL(url);
        u.toURI();
        this.esquemaURL = url;
    }

    public void setParameters(String params) throws Exception {
        if (!JSONUtils.isJSONValid(params)) {
            throw new Exception("Los parametros no coinciden con JSON bien formado");
        }
        this.parametros = JSONUtils.parsearJson(params);
    }

    public String parseParameters(String element) {
        Matcher m = PatronVarPeso.matcher(element);
        String variable = "";
        if (m.find()) {
            variable = m.group(0);
        }
        variable = variable.replace("$", "");
        return element.replace("$" + variable, this.parametros.get(variable).getAsString());
    }

    public JsonArray parseArrayParameters(String element) {
        Matcher m = PatronVarPeso.matcher(element);
        String variable = "";
        if (m.find()) {
            variable = m.group(0);
        }
        variable = variable.replace("$", "");
        return this.parametros.get(variable).getAsJsonArray();
    }

    public HashMap<String, String> getSharedHeaders() {
        return this.sharedHeaders;
    }

    public void ejecutarOrigen() {
        if (this.originsController.metodoEjecucion == 0) {
            this.originsController.iniciarDescarga();
        }
    }

    public ConfigFirmaPDF getConfigFirma() {
        return this.configFirmaPDF;
    }

    public void finFirmado() {
        if (this.destinationsController.metodoEjecucion == 0) {
            Principal.getInstance().setEstadoApp(EstadoApp.SUBIENDO);
            this.destinationsController.iniciarSubida();
        }
    }

    public HashMap<String, String> getDefaultHeaders() {
        return this.defaultHeaders;
    }
}

