/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.signarestandalone.controladores;

import ar.com.lyris.signarStandalone.entidades.Documento;
import ar.com.lyris.signarStandalone.utils.JSONUtils;
import ar.com.lyris.signarestandalone.controladores.EsquemaController;
import ar.com.lyris.signarestandalone.controladores.Principal;
import ar.com.lyris.signarestandalone.controladores.WorkerDescarga;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;

public class OriginsController {
    public static final int DESCARGA_DE_ORIGEN = 0;
    public static volatile OriginsController originsController;
    final int metodoEjecucion = 0;
    private WorkerDescarga workerDescarga;
    private EsquemaController esquemaController = EsquemaController.getInstance();
    private JsonArray fileList;

    private OriginsController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OriginsController getInstance() {
        if (originsController != null) return originsController;
        Class<OriginsController> clazz = OriginsController.class;
        synchronized (OriginsController.class) {
            if (originsController != null) return originsController;
            originsController = new OriginsController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return originsController;
        }
    }

    public void procesarOrigenes(JsonObject origins) {
        if (origins.getAsJsonObject("remote") != null) {
            this.workerDescarga = WorkerDescarga.getInstance();
            JsonObject remote = origins.getAsJsonObject("remote");
            this.workerDescarga.setURL(remote.get("URI").getAsString());
            this.workerDescarga.setMethod(remote.get("method").getAsString());
            if (remote.get("fileList").getAsString().contains("$")) {
                this.fileList = this.esquemaController.parseArrayParameters(remote.get("fileList").getAsString());
            }
            this.workerDescarga.setFileList(JSONUtils.asArrayList(this.fileList));
            HashMap<String, String> originsHeaders = JSONUtils.asHashMap(remote.getAsJsonObject("headers"));
            if (originsHeaders != null) {
                this.computarHeaders(originsHeaders);
            }
        }
    }

    public Documento nuevoDocumento(String id) {
        Principal p = Principal.getInstance();
        Documento doc = new Documento(id);
        p.getDocumentos().add(doc);
        return doc;
    }

    public void computarHeaders(HashMap<String, String> originsHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(this.esquemaController.getDefaultHeaders());
        originsHeaders.forEach((key, value) -> {
            if (value.contains("$")) {
                String newValue = this.esquemaController.parseParameters((String)value);
                originsHeaders.put((String)key, newValue);
                headers.put((String)key, newValue);
            } else {
                headers.put((String)key, (String)value);
            }
        });
        this.workerDescarga.setHeaders(headers);
    }

    public void iniciarDescarga() {
        this.workerDescarga.execute();
    }
}

