/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.impl;

import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.data.CustomData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.event.InstallerListeners;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.util.List;

public class CustomDataLoader {
    private final PlatformModelMatcher matcher;
    private final Resources resources;
    private final ObjectFactory factory;
    private final UninstallData uninstallData;
    private final InstallerListeners listeners;

    public CustomDataLoader(PlatformModelMatcher matcher, Resources resources, ObjectFactory factory, UninstallData uninstallData, InstallerListeners listeners) {
        this.matcher = matcher;
        this.resources = resources;
        this.factory = factory;
        this.uninstallData = uninstallData;
        this.listeners = listeners;
    }

    public void loadCustomData() {
        List customData = (List)this.resources.getObject("customData");
        for (CustomData data : customData) {
            if (!this.matcher.matchesCurrentPlatform(data.osConstraints)) continue;
            switch (data.type) {
                case 0: {
                    this.addInstallerListener(data.listenerName);
                    break;
                }
                case 1: {
                    this.uninstallData.addUninstallerListener(data);
                    break;
                }
                case 3: {
                    this.uninstallData.addJar(data);
                    break;
                }
                case 2: {
                    this.uninstallData.addNativeLibrary(data.contents.get(0));
                }
            }
        }
        this.listeners.initialise();
    }

    private void addInstallerListener(String className) {
        InstallerListener listener = this.factory.create(className, InstallerListener.class, new Object[0]);
        this.listeners.add(listener);
    }
}

