/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.openssl;

import com.itextpdf.bouncycastle.asn1.pcks.PrivateKeyInfoBC;
import com.itextpdf.bouncycastle.cert.X509CertificateHolderBC;
import com.itextpdf.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfoBC;
import com.itextpdf.commons.bouncycastle.openssl.IPEMParser;
import java.io.IOException;
import java.util.Objects;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class PEMParserBC
implements IPEMParser {
    private final PEMParser parser;

    public PEMParserBC(PEMParser parser) {
        this.parser = parser;
    }

    public PEMParser getParser() {
        return this.parser;
    }

    @Override
    public Object readObject() throws IOException {
        Object readObject = this.parser.readObject();
        if (readObject instanceof X509CertificateHolder) {
            return new X509CertificateHolderBC((X509CertificateHolder)readObject);
        }
        if (readObject instanceof PKCS8EncryptedPrivateKeyInfo) {
            return new PKCS8EncryptedPrivateKeyInfoBC((PKCS8EncryptedPrivateKeyInfo)readObject);
        }
        if (readObject instanceof PrivateKeyInfo) {
            return new PrivateKeyInfoBC((PrivateKeyInfo)readObject);
        }
        return readObject;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PEMParserBC that = (PEMParserBC)o;
        return Objects.equals(this.parser, that.parser);
    }

    public int hashCode() {
        return Objects.hash(this.parser);
    }

    public String toString() {
        return this.parser.toString();
    }
}

