/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.operator;

import com.itextpdf.bouncycastle.asn1.x509.AlgorithmIdentifierBC;
import com.itextpdf.bouncycastle.operator.DigestCalculatorBC;
import com.itextpdf.bouncycastle.operator.OperatorCreationExceptionBC;
import com.itextpdf.commons.bouncycastle.asn1.x509.IAlgorithmIdentifier;
import com.itextpdf.commons.bouncycastle.operator.IDigestCalculator;
import com.itextpdf.commons.bouncycastle.operator.IDigestCalculatorProvider;
import java.util.Objects;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;

public class DigestCalculatorProviderBC
implements IDigestCalculatorProvider {
    private final DigestCalculatorProvider calculatorProvider;

    public DigestCalculatorProviderBC(DigestCalculatorProvider calculatorProvider) {
        this.calculatorProvider = calculatorProvider;
    }

    public DigestCalculatorProvider getCalculatorProvider() {
        return this.calculatorProvider;
    }

    @Override
    public IDigestCalculator get(IAlgorithmIdentifier algorithmIdentifier) throws OperatorCreationExceptionBC {
        try {
            return new DigestCalculatorBC(this.calculatorProvider.get(((AlgorithmIdentifierBC)algorithmIdentifier).getAlgorithmIdentifier()));
        }
        catch (OperatorCreationException e) {
            throw new OperatorCreationExceptionBC(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigestCalculatorProviderBC that = (DigestCalculatorProviderBC)o;
        return Objects.equals(this.calculatorProvider, that.calculatorProvider);
    }

    public int hashCode() {
        return Objects.hash(this.calculatorProvider);
    }

    public String toString() {
        return this.calculatorProvider.toString();
    }
}

