/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.pkcs;

import com.itextpdf.bouncycastle.asn1.pcks.PrivateKeyInfoBC;
import com.itextpdf.bouncycastle.operator.InputDecryptorProviderBC;
import com.itextpdf.bouncycastle.pkcs.PKCSExceptionBC;
import com.itextpdf.commons.bouncycastle.asn1.pkcs.IPrivateKeyInfo;
import com.itextpdf.commons.bouncycastle.operator.IInputDecryptorProvider;
import com.itextpdf.commons.bouncycastle.pkcs.IPKCS8EncryptedPrivateKeyInfo;
import java.util.Objects;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

public class PKCS8EncryptedPrivateKeyInfoBC
implements IPKCS8EncryptedPrivateKeyInfo {
    private final PKCS8EncryptedPrivateKeyInfo privateKeyInfo;

    public PKCS8EncryptedPrivateKeyInfoBC(PKCS8EncryptedPrivateKeyInfo privateKeyInfo) {
        this.privateKeyInfo = privateKeyInfo;
    }

    public PKCS8EncryptedPrivateKeyInfo getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }

    @Override
    public IPrivateKeyInfo decryptPrivateKeyInfo(IInputDecryptorProvider decryptorProvider) throws PKCSExceptionBC {
        try {
            return new PrivateKeyInfoBC(this.privateKeyInfo.decryptPrivateKeyInfo(((InputDecryptorProviderBC)decryptorProvider).getDecryptorProvider()));
        }
        catch (PKCSException e) {
            throw new PKCSExceptionBC(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PKCS8EncryptedPrivateKeyInfoBC that = (PKCS8EncryptedPrivateKeyInfoBC)o;
        return Objects.equals(this.privateKeyInfo, that.privateKeyInfo);
    }

    public int hashCode() {
        return Objects.hash(this.privateKeyInfo);
    }

    public String toString() {
        return this.privateKeyInfo.toString();
    }
}

