/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.AbstractPdfFormField;
import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public final class PdfFormAnnotationUtil {
    private PdfFormAnnotationUtil() {
    }

    public static boolean isPureWidgetOrMergedField(PdfDictionary fieldDict) {
        if (fieldDict.isFlushed()) {
            return false;
        }
        PdfName subtype = fieldDict.getAsName(PdfName.Subtype);
        return PdfName.Widget.equals(subtype);
    }

    public static boolean isPureWidget(PdfDictionary fieldDict) {
        return PdfFormAnnotationUtil.isPureWidgetOrMergedField(fieldDict) && !PdfFormField.isFormField(fieldDict);
    }

    public static void addWidgetAnnotationToPage(PdfPage page, PdfAnnotation annotation) {
        PdfFormAnnotationUtil.addWidgetAnnotationToPage(page, annotation, -1);
    }

    public static void addWidgetAnnotationToPage(PdfPage page, PdfAnnotation annotation, int index) {
        if (page.containsAnnotation(annotation)) {
            return;
        }
        TagTreePointer tagPointer = null;
        PdfDocument document = page.getDocument();
        boolean tagged = document.isTagged();
        if (tagged && !"Form".equals((tagPointer = document.getTagStructureContext().getAutoTaggingPointer()).getRole())) {
            tagPointer.addTag("Form");
        }
        page.addAnnotation(index, annotation, true);
        if (tagged) {
            tagPointer.moveToParent();
        }
    }

    public static void mergeWidgetWithParentField(PdfFormField field) {
        PdfDictionary kidDict;
        PdfArray kids = field.getKids();
        if (kids != null && kids.size() == 1 && PdfFormAnnotationUtil.isPureWidget(kidDict = (PdfDictionary)kids.get(0))) {
            kidDict.remove(PdfName.Parent);
            field.getPdfObject().mergeDifferent(kidDict);
            field.removeChildren();
            field.setChildField(PdfFormAnnotation.makeFormAnnotation(field.getPdfObject(), field.getDocument()));
            PdfFormAnnotationUtil.replaceAnnotationOnPage(kidDict, field.getPdfObject());
        }
    }

    public static void separateWidgetAndField(PdfFormField field) {
        PdfDictionary fieldDict = field.getPdfObject();
        if (PdfFormAnnotationUtil.isPureWidgetOrMergedField(fieldDict)) {
            PdfDictionary widgetDict = new PdfDictionary(fieldDict);
            PdfFormAnnotationUtil.replaceAnnotationOnPage(fieldDict, widgetDict);
            LinkedHashSet<PdfName> dictKeys = new LinkedHashSet<PdfName>(fieldDict.keySet());
            for (PdfName key : dictKeys) {
                if (PdfFormField.getFormFieldKeys().contains(key) || PdfName.Parent.equals(key)) {
                    widgetDict.remove(key);
                    continue;
                }
                fieldDict.remove(key);
            }
            ArrayList<AbstractPdfFormField> newKids = new ArrayList<AbstractPdfFormField>();
            newKids.add(PdfFormAnnotation.makeFormAnnotation(widgetDict, field.getDocument()));
            field.replaceKids(newKids);
        }
    }

    private static void replaceAnnotationOnPage(PdfDictionary oldAnnotDict, PdfDictionary newAnnotDict) {
        PdfAnnotation oldAnnot = PdfAnnotation.makeAnnotation(oldAnnotDict);
        PdfPage page = oldAnnot.getPage();
        if (page != null) {
            int annotIndex = -1;
            PdfArray annots = ((PdfDictionary)page.getPdfObject()).getAsArray(PdfName.Annots);
            if (annots != null) {
                annotIndex = annots.indexOf(oldAnnotDict);
            }
            page.removeAnnotation(oldAnnot, true);
            oldAnnotDict.remove(PdfName.P);
            if (annotIndex >= page.getAnnotsSize()) {
                annotIndex = -1;
            }
            if (newAnnotDict.get(PdfName.P) == null) {
                newAnnotDict.put(PdfName.P, (PdfObject)page.getPdfObject());
            }
            PdfFormAnnotationUtil.addNewWidgetToPage(page, newAnnotDict, annotIndex);
        }
    }

    private static void addNewWidgetToPage(PdfPage currentPage, PdfDictionary field, int annotIndex) {
        PdfDictionary pageDic = field.getAsDictionary(PdfName.P);
        if (pageDic.isFlushed()) {
            return;
        }
        PdfDocument doc = pageDic.getIndirectReference().getDocument();
        PdfPage widgetPage = doc.getPage(pageDic);
        PdfFormAnnotationUtil.addWidgetAnnotationToPage(widgetPage == null ? currentPage : widgetPage, PdfAnnotation.makeAnnotation(field), annotIndex);
    }
}

