/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.AbstractPdfFormField;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormAnnotationUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.merging.OnDuplicateFormFieldNameStrategy;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public final class PdfFormFieldMergeUtil {
    private PdfFormFieldMergeUtil() {
    }

    public static void mergeKidsWithSameNames(PdfFormField parentField, boolean throwExceptionOnError) {
        PdfDictionary parent = parentField.getPdfObject();
        if (parentField.isInReadingMode()) {
            return;
        }
        PdfArray kids = parent.getAsArray(PdfName.Kids);
        if (kids == null || kids.size() == 0) {
            return;
        }
        LinkedHashMap<String, AbstractPdfFormField> addedKids = new LinkedHashMap<String, AbstractPdfFormField>();
        ArrayList<AbstractPdfFormField> newKids = new ArrayList<AbstractPdfFormField>();
        for (AbstractPdfFormField kid : parentField.getChildFields()) {
            if (kid instanceof PdfFormField) {
                PdfFormFieldMergeUtil.mergeKidsWithSameNames((PdfFormField)kid, throwExceptionOnError);
                String kidName = PdfFormFieldMergeUtil.getPartialName(kid);
                if (addedKids.containsKey(kidName) && PdfFormFieldMergeUtil.mergeTwoFieldsWithTheSameNames((PdfFormField)addedKids.get(kidName), (PdfFormField)kid, throwExceptionOnError)) continue;
                addedKids.put(PdfFormFieldMergeUtil.getPartialName(kid), kid);
                newKids.add(kid);
                continue;
            }
            newKids.add(kid);
        }
        parentField.replaceKids(newKids);
        PdfFormFieldMergeUtil.processDirtyAnnotations(parentField, throwExceptionOnError);
    }

    public static boolean mergeTwoFieldsWithTheSameNames(PdfFormField firstField, PdfFormField secondField, boolean throwExceptionOnError) {
        OnDuplicateFormFieldNameStrategy onDuplicateFormFieldNameStrategy = firstField.getDocument().getDiContainer().getInstance(OnDuplicateFormFieldNameStrategy.class);
        return onDuplicateFormFieldNameStrategy.execute(firstField, secondField, throwExceptionOnError);
    }

    public static String getPartialName(AbstractPdfFormField field) {
        if (PdfFormAnnotationUtil.isPureWidget(field.getPdfObject())) {
            return null;
        }
        if (field instanceof PdfFormField) {
            return ((PdfFormField)field).getPartialFieldName().toUnicodeString();
        }
        return "";
    }

    public static void processDirtyAnnotations(PdfFormField parentField, boolean throwExceptionOnError) {
        for (PdfFormField field : parentField.getChildFormFields()) {
            PdfDictionary formDict = field.getPdfObject();
            if (field.getChildFields().size() <= 0 || field.getChildFormFields().size() != 0) continue;
            boolean shouldBeMerged = true;
            if (!(PdfName.Btn.equals(parentField.getFormType()) && parentField.getFieldFlag(PdfButtonFormField.FF_RADIO) || PdfName.Sig.equals(parentField.getFormType()))) {
                if (formDict.containsKey(PdfName.T)) continue;
                for (PdfName key : formDict.keySet()) {
                    if (PdfName.Parent.equals(key) || PdfName.Kids.equals(key) || formDict.get(key).equals(parentField.getPdfObject().get(key))) continue;
                    shouldBeMerged = false;
                    break;
                }
            }
            if (!shouldBeMerged) continue;
            parentField.removeChild(field);
            formDict.remove(PdfName.Parent);
            PdfFormFieldMergeUtil.mergeFormFields(parentField, field, throwExceptionOnError);
        }
    }

    public static void mergeFormFields(PdfFormField firstField, PdfFormField secondField, boolean throwExceptionOnError) {
        PdfFormAnnotationUtil.separateWidgetAndField(firstField);
        PdfFormAnnotationUtil.separateWidgetAndField(secondField);
        PdfDictionary firstFieldDict = firstField.getPdfObject();
        PdfDictionary secondFieldDict = secondField.getPdfObject();
        for (PdfName key : new ArrayList<PdfName>(secondFieldDict.keySet())) {
            if (PdfName.Kids.equals(key)) {
                for (AbstractPdfFormField kid : new ArrayList<AbstractPdfFormField>(secondField.getChildFields())) {
                    firstField.addKid(kid, throwExceptionOnError);
                }
                continue;
            }
            if (PdfName.Parent.equals(key) || firstFieldDict.containsKey(key)) continue;
            firstField.put(key, secondFieldDict.get(key));
        }
    }
}

