/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.TerminalFormFieldBuilder;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;

public class PushButtonFormFieldBuilder
extends TerminalFormFieldBuilder<PushButtonFormFieldBuilder> {
    private String caption = "";

    public PushButtonFormFieldBuilder(PdfDocument document, String formFieldName) {
        super(document, formFieldName);
    }

    public String getCaption() {
        return this.caption;
    }

    public PushButtonFormFieldBuilder setCaption(String caption) {
        this.caption = caption;
        return this.getThis();
    }

    public PdfButtonFormField createPushButton() {
        PdfButtonFormField field;
        PdfWidgetAnnotation annotation = null;
        if (this.getWidgetRectangle() == null) {
            field = PdfFormCreator.createButtonFormField(this.getDocument());
        } else {
            annotation = new PdfWidgetAnnotation(this.getWidgetRectangle());
            field = PdfFormCreator.createButtonFormField(annotation, this.getDocument());
            if (null != this.getConformanceLevel()) {
                annotation.setFlag(4);
            }
        }
        field.disableFieldRegeneration();
        if (this.getFont() != null) {
            field.setFont(this.getFont());
        }
        field.pdfAConformanceLevel = this.getConformanceLevel();
        field.setPushButton(true);
        field.setFieldName(this.getFormFieldName());
        field.text = this.caption;
        if (annotation != null) {
            field.getFirstFormAnnotation().backgroundColor = ColorConstants.LIGHT_GRAY;
            PdfDictionary mk = new PdfDictionary();
            mk.put(PdfName.CA, new PdfString(this.caption));
            mk.put(PdfName.BG, new PdfArray(field.getFirstFormAnnotation().backgroundColor.getColorValue()));
            annotation.setAppearanceCharacteristics(mk);
            this.setPageToField(field);
        }
        field.enableFieldRegeneration();
        return field;
    }

    @Override
    protected PushButtonFormFieldBuilder getThis() {
        return this;
    }
}

