/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.element;

import com.itextpdf.forms.fields.properties.SignedAppearanceText;
import com.itextpdf.forms.form.element.FormField;
import com.itextpdf.forms.form.renderer.SignatureAppearanceRenderer;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.IRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SignatureFieldAppearance
extends FormField<SignatureFieldAppearance> {
    private static final float DEFAULT_PADDING = 2.0f;
    private final List<IElement> contentElements = new ArrayList<IElement>();
    private SignedAppearanceText signedAppearanceText;
    private String signerName;
    private String idWithDots = null;

    public SignatureFieldAppearance(String id) {
        super(id != null && id.contains(".") ? "" : id);
        if (id.contains(".")) {
            this.idWithDots = id;
        }
        this.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
        this.setProperty(50, UnitValue.createPointValue(2.0f));
        this.setProperty(49, UnitValue.createPointValue(2.0f));
        this.setProperty(47, UnitValue.createPointValue(2.0f));
        this.setProperty(48, UnitValue.createPointValue(2.0f));
    }

    public SignatureFieldAppearance setContent(SignedAppearanceText description) {
        this.prepareContent(null, description);
        return this;
    }

    public SignatureFieldAppearance setContent(String description) {
        this.prepareContent(null, null);
        this.addTextContent(description);
        return this;
    }

    public SignatureFieldAppearance setContent(SignedAppearanceText description, ImageData image) {
        this.prepareContent(null, description);
        this.addImageContent(image);
        return this;
    }

    public SignatureFieldAppearance setContent(String description, ImageData image) {
        this.prepareContent(null, null);
        this.addImageContent(image);
        this.addTextContent(description);
        return this;
    }

    public SignatureFieldAppearance setContent(ImageData image) {
        this.prepareContent(null, null);
        this.addImageContent(image);
        return this;
    }

    public SignatureFieldAppearance setContent(String signerName, SignedAppearanceText description) {
        this.prepareContent(signerName, description);
        return this;
    }

    public SignatureFieldAppearance setContent(String signerName, String description) {
        this.prepareContent(signerName, null);
        this.addTextContent(description);
        return this;
    }

    public SignatureFieldAppearance setContent(Div data) {
        this.prepareContent(null, null);
        this.contentElements.add(data);
        return this;
    }

    public List<IElement> getContentElements() {
        if (this.signerName != null) {
            this.addTextContent(0, this.signerName);
            this.signerName = null;
        }
        if (this.signedAppearanceText != null) {
            this.addTextContent(this.signedAppearanceText.generateDescriptionText());
            this.signedAppearanceText = null;
        }
        return Collections.unmodifiableList(this.contentElements);
    }

    public SignedAppearanceText getSignedAppearanceText() {
        return this.signedAppearanceText;
    }

    public void setSignerName(String signerName) {
        if (this.signerName != null) {
            this.signerName = signerName;
        }
    }

    @Override
    public String getId() {
        return this.idWithDots == null ? super.getId() : this.idWithDots;
    }

    @Override
    protected IRenderer makeNewRenderer() {
        return new SignatureAppearanceRenderer(this);
    }

    private void prepareContent(String signer, SignedAppearanceText description) {
        this.contentElements.clear();
        this.signedAppearanceText = description;
        this.signerName = signer;
    }

    private void addTextContent(String text) {
        this.addTextContent(this.contentElements.size(), text);
    }

    private void addTextContent(int index, String text) {
        this.contentElements.add(index, ((Paragraph)new Paragraph(text).setMargin(0.0f)).setMultipliedLeading(0.9f));
    }

    private void addImageContent(ImageData imageData) {
        this.contentElements.add(new Image(imageData));
    }
}

