/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.forms.fields.TextFormFieldBuilder;
import com.itextpdf.forms.form.element.InputField;
import com.itextpdf.forms.form.renderer.AbstractOneLineTextFieldRenderer;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.BoxSizingPropertyValue;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputFieldRenderer
extends AbstractOneLineTextFieldRenderer {
    public InputFieldRenderer(InputField modelElement) {
        super(modelElement);
    }

    @Override
    public IRenderer getNextRenderer() {
        return new InputFieldRenderer((InputField)this.modelElement);
    }

    public int getSize() {
        Integer size = this.getPropertyAsInteger(0x200002);
        return size == null ? ((Integer)this.modelElement.getDefaultProperty(0x200002)).intValue() : size.intValue();
    }

    public boolean isPassword() {
        Boolean password = this.getPropertyAsBoolean(0x200004);
        return password == null ? ((Boolean)this.modelElement.getDefaultProperty(0x200004)).booleanValue() : password.booleanValue();
    }

    @Override
    IRenderer createParagraphRenderer(String defaultValue) {
        if (defaultValue.isEmpty() && null != ((InputField)this.modelElement).getPlaceholder() && !((InputField)this.modelElement).getPlaceholder().isEmpty()) {
            return ((InputField)this.modelElement).getPlaceholder().createRendererSubTree();
        }
        IRenderer flatRenderer = super.createParagraphRenderer(defaultValue);
        flatRenderer.setProperty(118, true);
        return flatRenderer;
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        List<LineRenderer> flatLines = ((ParagraphRenderer)this.flatRenderer).getLines();
        Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
        this.updatePdfFont((ParagraphRenderer)this.flatRenderer);
        if (flatLines.isEmpty() || this.font == null) {
            LoggerFactory.getLogger(this.getClass()).error(MessageFormatUtil.format("Error during layout of form field with type {0}.", "text input"));
            this.setProperty(0x200001, true);
            flatBBox.setY(flatBBox.getTop()).setHeight(0.0f);
        } else {
            this.cropContentLines(flatLines, flatBBox);
        }
        flatBBox.setWidth(this.retrieveWidth(layoutContext.getArea().getBBox().getWidth()).floatValue());
    }

    @Override
    protected IRenderer createFlatRenderer() {
        String defaultValue = this.getDefaultValue();
        boolean flatten = this.isFlatten();
        boolean password = this.isPassword();
        if (flatten && password) {
            defaultValue = this.obfuscatePassword(defaultValue);
        }
        return this.createParagraphRenderer(defaultValue);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        this.font.setSubset(false);
        boolean password = this.isPassword();
        String value = password ? "" : this.getDefaultValue();
        String name = this.getModelId();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(InputFieldRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.getOccupiedArea().getBBox().clone();
        this.applyMargins(area, false);
        Map<Integer, Object> margins = this.deleteMargins();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        float fontSizeValue = fontSize.getValue();
        this.modelElement.setProperty(91, this.getProperty(91));
        this.modelElement.setProperty(123, this.getProperty(123));
        this.modelElement.setProperty(105, (Object)BoxSizingPropertyValue.BORDER_BOX);
        PdfTextFormField inputField = ((TextFormFieldBuilder)((TextFormFieldBuilder)((TextFormFieldBuilder)new TextFormFieldBuilder(doc, name).setWidgetRectangle(area)).setFont(this.font)).setConformanceLevel(this.getConformanceLevel(doc))).createText();
        inputField.disableFieldRegeneration();
        inputField.setValue(value);
        inputField.setFontSize(fontSizeValue);
        if (password) {
            inputField.setFieldFlag(PdfFormField.FF_PASSWORD, true);
        } else {
            inputField.setDefaultValue(new PdfString(value));
        }
        int rotation = ((InputField)this.modelElement).getRotation();
        if (rotation != 0) {
            inputField.getFirstFormAnnotation().setRotation(rotation);
        }
        this.applyDefaultFieldProperties(inputField);
        inputField.getFirstFormAnnotation().setFormFieldElement((InputField)this.modelElement);
        inputField.enableFieldRegeneration();
        PdfFormCreator.getAcroForm(doc, true).addField(inputField, page);
        this.writeAcroFormFieldLangAttribute(doc);
        this.applyProperties(margins);
    }

    @Override
    public <T1> T1 getProperty(int key) {
        if (key == 77) {
            Object width = super.getProperty(77);
            if (width == null) {
                UnitValue fontSize = this.getPropertyAsUnitValue(24);
                if (!fontSize.isPointValue()) {
                    Logger logger = LoggerFactory.getLogger(InputFieldRenderer.class);
                    logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
                }
                int size = this.getSize();
                return (T1)UnitValue.createPointValue(this.updateHtmlColsSizeBasedWidth(fontSize.getValue() * ((float)size * 0.5f + 2.0f) + 2.0f));
            }
            return width;
        }
        return super.getProperty(key);
    }

    @Override
    protected boolean setMinMaxWidthBasedOnFixedWidth(MinMaxWidth minMaxWidth) {
        boolean result = false;
        if (this.hasRelativeUnitValue(77)) {
            UnitValue widthUV = (UnitValue)this.getProperty(77);
            boolean restoreWidth = this.hasOwnProperty(77);
            this.setProperty(77, null);
            Float width = this.retrieveWidth(0.0f);
            if (width != null) {
                minMaxWidth.setChildrenMaxWidth(width.floatValue());
                result = true;
            }
            if (restoreWidth) {
                this.setProperty(77, widthUV);
            } else {
                this.deleteOwnProperty(77);
            }
        } else {
            result = super.setMinMaxWidthBasedOnFixedWidth(minMaxWidth);
        }
        return result;
    }

    private String obfuscatePassword(String text) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            builder.append('*');
        }
        return builder.toString();
    }
}

