/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormCreator;
import com.itextpdf.forms.fields.PdfSignatureFormField;
import com.itextpdf.forms.fields.SignatureFormFieldBuilder;
import com.itextpdf.forms.form.element.SignatureFieldAppearance;
import com.itextpdf.forms.form.renderer.AbstractTextFieldRenderer;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.Background;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureAppearanceRenderer
extends AbstractTextFieldRenderer {
    private static final float TOP_SECTION = 0.3f;
    private static final float EPS = 1.0E-5f;
    private final RenderingMode renderingMode = this.retrieveRenderingMode();
    private boolean isFontSizeApproximated = false;

    public SignatureAppearanceRenderer(SignatureFieldAppearance modelElement) {
        super(modelElement);
    }

    @Override
    protected boolean isLayoutBasedOnFlatRenderer() {
        return false;
    }

    @Override
    protected IRenderer createFlatRenderer() {
        Div div = new Div();
        for (IElement element : ((SignatureFieldAppearance)this.modelElement).getContentElements()) {
            if (element instanceof Image) {
                div.add((Image)element);
                continue;
            }
            div.add((IBlockElement)element);
        }
        return div.createRendererSubTree();
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        this.approximateFontSizeToFitLayoutArea(layoutContext);
        return super.layout(layoutContext);
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        Rectangle bBox = this.getOccupiedArea().getBBox().clone();
        this.applyPaddings(bBox, false);
        this.applyBorderBox(bBox, false);
        if (bBox.getY() < 0.0f) {
            bBox.setHeight(bBox.getY() + bBox.getHeight());
            bBox.setY(0.0f);
        }
        Rectangle descriptionRect = null;
        Rectangle signatureRect = null;
        switch (this.renderingMode) {
            case NAME_AND_DESCRIPTION: 
            case GRAPHIC_AND_DESCRIPTION: {
                UnitValue[] paddings = this.getPaddings();
                if (bBox.getHeight() > bBox.getWidth()) {
                    float topPadding = paddings[0].getValue();
                    float bottomPadding = paddings[2].getValue();
                    signatureRect = new Rectangle(bBox.getX(), bBox.getY() + bBox.getHeight() / 2.0f + bottomPadding / 2.0f, bBox.getWidth(), bBox.getHeight() / 2.0f - bottomPadding / 2.0f);
                    descriptionRect = new Rectangle(bBox.getX(), bBox.getY(), bBox.getWidth(), bBox.getHeight() / 2.0f - topPadding / 2.0f);
                    break;
                }
                float rightPadding = paddings[1].getValue();
                float leftPadding = paddings[3].getValue();
                signatureRect = new Rectangle(bBox.getX(), bBox.getY(), bBox.getWidth() / 2.0f - rightPadding / 2.0f, bBox.getHeight());
                descriptionRect = new Rectangle(bBox.getX() + bBox.getWidth() / 2.0f + leftPadding / 2.0f, bBox.getY(), bBox.getWidth() / 2.0f - leftPadding / 2.0f, bBox.getHeight());
                break;
            }
            case GRAPHIC: {
                signatureRect = bBox;
                break;
            }
            case DESCRIPTION: {
                float additionalHeight = this.calculateAdditionalHeight();
                if (this.retrieveHeight() == null) {
                    float calculatedHeight = this.getOccupiedArea().getBBox().getHeight();
                    float topSection = (calculatedHeight + additionalHeight) * 0.3f / 0.7f;
                    this.getOccupiedArea().getBBox().moveDown(topSection + additionalHeight).setHeight(calculatedHeight + topSection + additionalHeight);
                    bBox.moveDown(bBox.getBottom() - this.getOccupiedArea().getBBox().getBottom() - additionalHeight / 2.0f);
                }
                descriptionRect = bBox.setHeight(this.getOccupiedArea().getBBox().getHeight() * 0.7f - additionalHeight);
                break;
            }
            default: {
                return;
            }
        }
        this.adjustChildrenLayout(this.renderingMode, signatureRect, descriptionRect, layoutContext.getArea().getPageNumber());
    }

    @Override
    public IRenderer getNextRenderer() {
        return new SignatureAppearanceRenderer((SignatureFieldAppearance)this.modelElement);
    }

    @Override
    public String getDefaultValue() {
        return "";
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        String name = this.getModelId();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(SignatureAppearanceRenderer.class);
            logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", 24));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.getOccupiedArea().getBBox().clone();
        this.applyMargins(area, false);
        this.deleteMargins();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        Background background = (Background)this.getProperty(6);
        Color backgroundColor = background == null ? null : background.getColor();
        float fontSizeValue = fontSize.getValue();
        if (this.font == null) {
            this.font = doc.getDefaultFont();
        }
        this.modelElement.setProperty(91, this.getProperty(91));
        this.modelElement.setProperty(123, this.getProperty(123));
        PdfSignatureFormField sigField = ((SignatureFormFieldBuilder)((SignatureFormFieldBuilder)((SignatureFormFieldBuilder)new SignatureFormFieldBuilder(doc, name).setWidgetRectangle(area)).setConformanceLevel(this.getConformanceLevel(doc))).setFont(this.font)).createSignature();
        sigField.disableFieldRegeneration();
        sigField.setFontSize(fontSizeValue);
        sigField.getFirstFormAnnotation().setBackgroundColor(backgroundColor);
        this.applyDefaultFieldProperties(sigField);
        sigField.getFirstFormAnnotation().setFormFieldElement((SignatureFieldAppearance)this.modelElement);
        sigField.enableFieldRegeneration();
        PdfAcroForm forms = PdfFormCreator.getAcroForm(doc, true);
        forms.addField(sigField, page);
        this.writeAcroFormFieldLangAttribute(doc);
    }

    private void adjustChildrenLayout(RenderingMode renderingMode, Rectangle signatureRect, Rectangle descriptionRect, int pageNum) {
        switch (renderingMode) {
            case NAME_AND_DESCRIPTION: {
                ParagraphRenderer name = (ParagraphRenderer)this.flatRenderer.getChildRenderers().get(0);
                this.relayoutParagraph(name, signatureRect, pageNum);
                ParagraphRenderer description = (ParagraphRenderer)this.flatRenderer.getChildRenderers().get(1);
                this.relayoutParagraph(description, descriptionRect, pageNum);
                break;
            }
            case GRAPHIC_AND_DESCRIPTION: {
                this.relayoutImage(signatureRect, pageNum);
                ParagraphRenderer description = (ParagraphRenderer)this.flatRenderer.getChildRenderers().get(1);
                this.relayoutParagraph(description, descriptionRect, pageNum);
                break;
            }
            case GRAPHIC: {
                this.relayoutImage(signatureRect, pageNum);
                break;
            }
            default: {
                ParagraphRenderer description = (ParagraphRenderer)this.flatRenderer.getChildRenderers().get(0);
                this.relayoutParagraph(description, descriptionRect, pageNum);
                break;
            }
        }
        VerticalAlignment verticalAlignment = (VerticalAlignment)((Object)this.getProperty(75));
        float multiplier = 0.0f;
        if (VerticalAlignment.MIDDLE == verticalAlignment) {
            multiplier = 0.5f;
        } else if (VerticalAlignment.BOTTOM == verticalAlignment) {
            multiplier = 1.0f;
        }
        float lowestChildBottom = this.getLowestChildBottom(this.flatRenderer, this.getInnerAreaBBox().getTop());
        float deltaY = lowestChildBottom - this.getInnerAreaBBox().getY();
        if (deltaY > 0.0f) {
            this.flatRenderer.move(0.0f, -deltaY * multiplier);
        }
    }

    private void relayoutImage(Rectangle signatureRect, int pageNum) {
        float imgHeight;
        ImageRenderer image = (ImageRenderer)this.flatRenderer.getChildRenderers().get(0);
        Rectangle imageBBox = image.getOccupiedArea().getBBox();
        float imgWidth = imageBBox.getWidth();
        if (imgWidth < 1.0E-5f) {
            imgWidth = signatureRect.getWidth();
        }
        if ((imgHeight = imageBBox.getHeight()) < 1.0E-5f) {
            imgHeight = signatureRect.getHeight();
        }
        float multiplierH = signatureRect.getWidth() / imgWidth;
        float multiplierW = signatureRect.getHeight() / imgHeight;
        float multiplier = Math.min(multiplierH, multiplierW);
        float x = signatureRect.getLeft() + (signatureRect.getWidth() - (imgWidth *= multiplier)) / 2.0f;
        float y = signatureRect.getBottom() + (signatureRect.getHeight() - (imgHeight *= multiplier)) / 2.0f;
        LayoutContext layoutContext = new LayoutContext(new LayoutArea(pageNum, new Rectangle(x, y, imgWidth, imgHeight)));
        image.getModelElement().setProperty(77, UnitValue.createPointValue(imgWidth));
        image.getModelElement().setProperty(27, UnitValue.createPointValue(imgHeight));
        image.layout(layoutContext);
    }

    private void relayoutParagraph(IRenderer renderer, Rectangle rect, int pageNum) {
        UnitValue fontSizeAsUV;
        UnitValue unitValue = fontSizeAsUV = this.hasOwnProperty(24) ? (UnitValue)this.getOwnProperty(24) : (UnitValue)this.modelElement.getOwnProperty(24);
        if (fontSizeAsUV == null || fontSizeAsUV.getValue() < 1.0E-5f || this.isFontSizeApproximated) {
            IRenderer helper = ((Paragraph)renderer.getModelElement()).createRendererSubTree().setParent(renderer.getParent());
            this.deleteProperty(24);
            LayoutContext layoutContext = new LayoutContext(new LayoutArea(pageNum, rect));
            float lFontSize = 0.1f;
            float rFontSize = 100.0f;
            int numberOfIterations = 15;
            float fontSize = this.calculateFittingFontSize(helper, lFontSize, rFontSize, layoutContext, numberOfIterations);
            renderer.getModelElement().setProperty(24, UnitValue.createPointValue(fontSize));
        }
        LayoutContext layoutContext = new LayoutContext(new LayoutArea(pageNum, rect));
        renderer.layout(layoutContext);
    }

    private float calculateAdditionalHeight() {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        this.applyMargins(dummy, true);
        this.applyBorderBox(dummy, true);
        this.applyPaddings(dummy, true);
        return dummy.getHeight();
    }

    private void approximateFontSizeToFitLayoutArea(LayoutContext layoutContext) {
        if (this.hasOwnProperty(24) || this.modelElement.hasOwnProperty(24)) {
            return;
        }
        if (RenderingMode.GRAPHIC == this.renderingMode || RenderingMode.GRAPHIC_AND_DESCRIPTION == this.renderingMode || RenderingMode.CUSTOM == this.renderingMode) {
            return;
        }
        float fontSize = this.approximateFontSize(layoutContext, 0.1f, 12.0f);
        if (fontSize > 0.0f) {
            this.isFontSizeApproximated = true;
            this.modelElement.setProperty(24, UnitValue.createPointValue(fontSize));
        }
    }

    private RenderingMode retrieveRenderingMode() {
        List<IElement> contentElements = ((SignatureFieldAppearance)this.modelElement).getContentElements();
        if (contentElements.size() == 2 && contentElements.get(1) instanceof Paragraph) {
            if (contentElements.get(0) instanceof Paragraph) {
                return RenderingMode.NAME_AND_DESCRIPTION;
            }
            if (contentElements.get(0) instanceof Image) {
                return RenderingMode.GRAPHIC_AND_DESCRIPTION;
            }
        }
        if (contentElements.size() == 1) {
            if (contentElements.get(0) instanceof Paragraph) {
                return RenderingMode.DESCRIPTION;
            }
            if (contentElements.get(0) instanceof Image) {
                return RenderingMode.GRAPHIC;
            }
        }
        return RenderingMode.CUSTOM;
    }

    private static enum RenderingMode {
        DESCRIPTION,
        NAME_AND_DESCRIPTION,
        GRAPHIC_AND_DESCRIPTION,
        GRAPHIC,
        CUSTOM;

    }
}

