/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer.checkboximpl;

import com.itextpdf.commons.datastructures.BiMap;
import com.itextpdf.forms.fields.properties.CheckBoxType;
import com.itextpdf.forms.form.renderer.CheckBoxRenderer;
import com.itextpdf.forms.form.renderer.checkboximpl.ICheckBoxRenderingStrategy;
import com.itextpdf.forms.util.DrawingUtil;
import com.itextpdf.forms.util.FontSizeUtil;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.renderer.DrawContext;
import java.io.IOException;

public final class PdfCheckBoxRenderingStrategy
implements ICheckBoxRenderingStrategy {
    public static final BiMap<CheckBoxType, String> ZAPFDINGBATS_CHECKBOX_MAPPING = new BiMap();

    @Override
    public void drawCheckBoxContent(DrawContext drawContext, CheckBoxRenderer checkBoxRenderer, Rectangle rectangle) {
        if (!checkBoxRenderer.isBoxChecked()) {
            return;
        }
        float borderWidth = 0.75f;
        Border border = (Border)checkBoxRenderer.getProperty(9);
        if (border != null) {
            borderWidth = border.getWidth();
            rectangle.applyMargins(borderWidth, borderWidth, borderWidth, borderWidth, true);
        }
        PdfCanvas canvas = drawContext.getCanvas();
        canvas.saveState();
        canvas.setFillColor(ColorConstants.BLACK);
        canvas.concatMatrix(1.0, 0.0, 0.0, 1.0, rectangle.getLeft(), rectangle.getBottom());
        CheckBoxType checkBoxType = checkBoxRenderer.getCheckBoxType();
        if (checkBoxType == CheckBoxType.CROSS || checkBoxType == null) {
            float customBorderWidth = border == null ? 1.0f : borderWidth;
            DrawingUtil.drawCross(canvas, rectangle.getWidth(), rectangle.getHeight(), customBorderWidth);
        } else {
            String text = ZAPFDINGBATS_CHECKBOX_MAPPING.getByKey(checkBoxType);
            PdfFont fontContainingSymbols = this.loadFontContainingSymbols();
            float fontSize = this.calculateFontSize(checkBoxRenderer, fontContainingSymbols, text, rectangle, borderWidth);
            this.drawZapfdingbatsIcon(fontContainingSymbols, text, fontSize, rectangle, canvas);
        }
        canvas.restoreState();
    }

    private PdfFont loadFontContainingSymbols() {
        try {
            return PdfFontFactory.createFont("ZapfDingbats");
        }
        catch (IOException e) {
            throw new PdfException(e);
        }
    }

    private float calculateFontSize(CheckBoxRenderer checkBoxRenderer, PdfFont fontContainingSymbols, String text, Rectangle rectangle, float borderWidth) {
        float fontSize = -1.0f;
        if (checkBoxRenderer.hasProperty(24)) {
            fontSize = checkBoxRenderer.getPropertyAsUnitValue(24).getValue();
        }
        if (fontSize <= 0.0f) {
            fontSize = FontSizeUtil.approximateFontSizeToFitSingleLine(fontContainingSymbols, new Rectangle(rectangle.getWidth(), rectangle.getHeight()), text, 0.1f, borderWidth);
        }
        if (fontSize <= 0.0f) {
            throw new PdfException("Shouldn't come here because then we should have taken default size");
        }
        return fontSize;
    }

    private void drawZapfdingbatsIcon(PdfFont fontContainingSymbols, String text, float fontSize, Rectangle rectangle, PdfCanvas canvas) {
        canvas.beginText().setFontAndSize(fontContainingSymbols, fontSize).resetFillColorRgb().setTextMatrix((rectangle.getWidth() - fontContainingSymbols.getWidth(text, fontSize)) / 2.0f, (rectangle.getHeight() - fontContainingSymbols.getAscent(text, fontSize)) / 2.0f).showText(text).endText();
    }

    static {
        ZAPFDINGBATS_CHECKBOX_MAPPING.put(CheckBoxType.CHECK, "4");
        ZAPFDINGBATS_CHECKBOX_MAPPING.put(CheckBoxType.CIRCLE, "l");
        ZAPFDINGBATS_CHECKBOX_MAPPING.put(CheckBoxType.CROSS, "8");
        ZAPFDINGBATS_CHECKBOX_MAPPING.put(CheckBoxType.DIAMOND, "u");
        ZAPFDINGBATS_CHECKBOX_MAPPING.put(CheckBoxType.SQUARE, "n");
        ZAPFDINGBATS_CHECKBOX_MAPPING.put(CheckBoxType.STAR, "H");
    }
}

