/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfa;

import com.itextpdf.forms.xfa.InverseStore;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Node;

class Xml2Som {
    protected List<String> order;
    protected Map<String, Node> name2Node;
    protected Map<String, InverseStore> inverseSearch;
    protected Stack<String> stack;
    protected int anform;

    Xml2Som() {
    }

    public static String escapeSom(String s) {
        if (s == null) {
            return "";
        }
        int idx = s.indexOf(46);
        if (idx < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int last = 0;
        while (idx >= 0) {
            sb.append(s.substring(last, idx));
            sb.append('\\');
            last = idx;
            idx = s.indexOf(46, idx + 1);
        }
        sb.append(s.substring(last));
        return sb.toString();
    }

    public static String unescapeSom(String s) {
        int idx = s.indexOf(92);
        if (idx < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int last = 0;
        while (idx >= 0) {
            sb.append(s.substring(last, idx));
            last = idx + 1;
            idx = s.indexOf(92, idx + 1);
        }
        sb.append(s.substring(last));
        return sb.toString();
    }

    protected String printStack() {
        if (this.stack.size() == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (int k = 0; k < this.stack.size(); ++k) {
            s.append('.').append((String)this.stack.get(k));
        }
        return s.substring(1);
    }

    public static String getShortName(String s) {
        int idx = s.indexOf(".#subform[");
        if (idx < 0) {
            return s;
        }
        int last = 0;
        StringBuilder sb = new StringBuilder();
        while (idx >= 0) {
            sb.append(s.substring(last, idx));
            idx = s.indexOf("]", idx + 10);
            if (idx < 0) {
                return sb.toString();
            }
            last = idx + 1;
            idx = s.indexOf(".#subform[", last);
        }
        sb.append(s.substring(last));
        return sb.toString();
    }

    public void inverseSearchAdd(String unstack) {
        Xml2Som.inverseSearchAdd(this.inverseSearch, this.stack, unstack);
    }

    public static void inverseSearchAdd(Map<String, InverseStore> inverseSearch, Stack<String> stack, String unstack) {
        String last = stack.peek();
        InverseStore store = inverseSearch.get(last);
        if (store == null) {
            store = new InverseStore();
            inverseSearch.put(last, store);
        }
        for (int k = stack.size() - 2; k >= 0; --k) {
            InverseStore store2;
            last = (String)stack.get(k);
            int idx = store.part.indexOf(last);
            if (idx < 0) {
                store.part.add(last);
                store2 = new InverseStore();
                store.follow.add(store2);
            } else {
                store2 = (InverseStore)store.follow.get(idx);
            }
            store = store2;
        }
        store.part.add("");
        store.follow.add(unstack);
    }

    public String inverseSearchGlobal(List<String> parts) {
        if (parts.size() == 0) {
            return null;
        }
        InverseStore store = this.inverseSearch.get(parts.get(parts.size() - 1));
        if (store == null) {
            return null;
        }
        for (int k = parts.size() - 2; k >= 0; --k) {
            String part = parts.get(k);
            int idx = store.part.indexOf(part);
            if (idx < 0) {
                if (store.isSimilar(part)) {
                    return null;
                }
                return store.getDefaultName();
            }
            store = (InverseStore)store.follow.get(idx);
        }
        return store.getDefaultName();
    }

    public static Stack<String> splitParts(String name) {
        String part;
        while (name.startsWith(".")) {
            name = name.substring(1);
        }
        Stack<String> parts = new Stack<String>();
        int last = 0;
        int pos = 0;
        while (true) {
            pos = last;
            while ((pos = name.indexOf(46, pos)) >= 0 && name.charAt(pos - 1) == '\\') {
                ++pos;
            }
            if (pos < 0) break;
            part = name.substring(last, pos);
            if (!part.endsWith("]")) {
                part = part + "[0]";
            }
            parts.add(part);
            last = pos + 1;
        }
        part = name.substring(last);
        if (!part.endsWith("]")) {
            part = part + "[0]";
        }
        parts.add(part);
        return parts;
    }

    public List<String> getOrder() {
        return this.order;
    }

    public void setOrder(List<String> order) {
        this.order = order;
    }

    public Map<String, Node> getName2Node() {
        return this.name2Node;
    }

    public void setName2Node(Map<String, Node> name2Node) {
        this.name2Node = name2Node;
    }

    public Map<String, InverseStore> getInverseSearch() {
        return this.inverseSearch;
    }

    public void setInverseSearch(Map<String, InverseStore> inverseSearch) {
        this.inverseSearch = inverseSearch;
    }
}

