/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.cmap;

import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.font.cmap.CMapObject;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.util.PdfNameUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CMapContentParser {
    public static final int COMMAND_TYPE = 200;
    private PdfTokenizer tokeniser;

    public CMapContentParser(PdfTokenizer tokeniser) {
        this.tokeniser = tokeniser;
    }

    public void parse(List<CMapObject> ls) throws IOException {
        CMapObject ob;
        ls.clear();
        while ((ob = this.readObject()) != null) {
            ls.add(ob);
            if (!ob.isLiteral()) continue;
            break;
        }
    }

    public CMapObject readDictionary() throws IOException {
        HashMap<String, CMapObject> dic = new HashMap<String, CMapObject>();
        while (true) {
            if (!this.nextValidToken()) {
                throw new com.itextpdf.io.exceptions.IOException("Unexpected end of file.");
            }
            if (this.tokeniser.getTokenType() == PdfTokenizer.TokenType.EndDic) break;
            if (this.tokeniser.getTokenType() == PdfTokenizer.TokenType.Other && "def".equals(this.tokeniser.getStringValue())) continue;
            if (this.tokeniser.getTokenType() != PdfTokenizer.TokenType.Name) {
                throw new com.itextpdf.io.exceptions.IOException("Dictionary key {0} is not a name.").setMessageParams(this.tokeniser.getStringValue());
            }
            String name = this.tokeniser.getStringValue();
            CMapObject obj = this.readObject();
            if (obj.isToken()) {
                if (obj.toString().equals(">>")) {
                    this.tokeniser.throwError("Unexpected '>>'.", new Object[0]);
                }
                if (obj.toString().equals("]")) {
                    this.tokeniser.throwError("Unexpected close bracket.", new Object[0]);
                }
            }
            dic.put(name, obj);
        }
        return new CMapObject(7, dic);
    }

    public CMapObject readArray() throws IOException {
        ArrayList<CMapObject> array = new ArrayList<CMapObject>();
        while (true) {
            CMapObject obj;
            if ((obj = this.readObject()).isToken()) {
                if (obj.toString().equals("]")) break;
                if (obj.toString().equals(">>")) {
                    this.tokeniser.throwError("Unexpected '>>'.", new Object[0]);
                }
            }
            array.add(obj);
        }
        return new CMapObject(6, array);
    }

    public CMapObject readObject() throws IOException {
        if (!this.nextValidToken()) {
            return null;
        }
        PdfTokenizer.TokenType type = this.tokeniser.getTokenType();
        switch (type) {
            case StartDic: {
                return this.readDictionary();
            }
            case StartArray: {
                return this.readArray();
            }
            case String: {
                CMapObject obj = this.tokeniser.isHexString() ? new CMapObject(2, PdfTokenizer.decodeStringContent(this.tokeniser.getByteContent(), true)) : new CMapObject(1, PdfTokenizer.decodeStringContent(this.tokeniser.getByteContent(), false));
                return obj;
            }
            case Name: {
                return new CMapObject(3, PdfNameUtil.decodeName(this.tokeniser.getByteContent()));
            }
            case Number: {
                CMapObject numObject = new CMapObject(4, null);
                try {
                    numObject.setValue((int)Double.parseDouble(this.tokeniser.getStringValue()));
                }
                catch (NumberFormatException e) {
                    numObject.setValue(Integer.MIN_VALUE);
                }
                return numObject;
            }
            case Other: {
                return new CMapObject(5, this.tokeniser.getStringValue());
            }
            case EndArray: {
                return new CMapObject(8, "]");
            }
            case EndDic: {
                return new CMapObject(8, ">>");
            }
        }
        return new CMapObject(0, "");
    }

    public boolean nextValidToken() throws IOException {
        while (this.tokeniser.nextToken()) {
            if (this.tokeniser.getTokenType() == PdfTokenizer.TokenType.Comment) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected static String decodeName(byte[] content) {
        return PdfNameUtil.decodeName(content);
    }

    private static String toHex4(int n) {
        String s = "0000" + Integer.toHexString(n);
        return s.substring(s.length() - 4);
    }

    public static String toHex(int n) {
        if (n < 65536) {
            return "<" + CMapContentParser.toHex4(n) + ">";
        }
        int high = (n -= 65536) / 1024 + 55296;
        int low = n % 1024 + 56320;
        return "[<" + CMapContentParser.toHex4(high) + CMapContentParser.toHex4(low) + ">]";
    }

    public static String decodeCMapObject(CMapObject cMapObject) {
        if (cMapObject.isHexString()) {
            return PdfEncodings.convertToString(((String)cMapObject.getValue()).getBytes(), "UnicodeBigUnmarked");
        }
        return (String)cMapObject.getValue();
    }
}

