/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.colors.gradients;

import com.itextpdf.kernel.colors.gradients.AbstractLinearGradientBuilder;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;

public class StrategyBasedLinearGradientBuilder
extends AbstractLinearGradientBuilder {
    private double rotateVectorAngle = 0.0;
    private GradientStrategy gradientStrategy = GradientStrategy.TO_BOTTOM;
    private boolean isCentralRotationAngleStrategy = false;

    public StrategyBasedLinearGradientBuilder setGradientDirectionAsCentralRotationAngle(double radians) {
        this.rotateVectorAngle = radians;
        this.isCentralRotationAngleStrategy = true;
        return this;
    }

    public StrategyBasedLinearGradientBuilder setGradientDirectionAsStrategy(GradientStrategy gradientStrategy) {
        this.gradientStrategy = gradientStrategy != null ? gradientStrategy : GradientStrategy.TO_BOTTOM;
        this.isCentralRotationAngleStrategy = false;
        return this;
    }

    public double getRotateVectorAngle() {
        return this.rotateVectorAngle;
    }

    public GradientStrategy getGradientStrategy() {
        return this.gradientStrategy;
    }

    public boolean isCentralRotationAngleStrategy() {
        return this.isCentralRotationAngleStrategy;
    }

    @Override
    protected Point[] getGradientVector(Rectangle targetBoundingBox, AffineTransform contextTransform) {
        if (targetBoundingBox == null) {
            return null;
        }
        return this.isCentralRotationAngleStrategy ? StrategyBasedLinearGradientBuilder.buildCentralRotationCoordinates(targetBoundingBox, this.rotateVectorAngle) : StrategyBasedLinearGradientBuilder.buildCoordinatesWithGradientStrategy(targetBoundingBox, this.gradientStrategy);
    }

    private static Point[] buildCoordinatesWithGradientStrategy(Rectangle targetBoundingBox, GradientStrategy gradientStrategy) {
        double xCenter = targetBoundingBox.getX() + targetBoundingBox.getWidth() / 2.0f;
        double yCenter = targetBoundingBox.getY() + targetBoundingBox.getHeight() / 2.0f;
        switch (gradientStrategy) {
            case TO_TOP: {
                return StrategyBasedLinearGradientBuilder.createCoordinates(xCenter, targetBoundingBox.getBottom(), xCenter, targetBoundingBox.getTop());
            }
            case TO_LEFT: {
                return StrategyBasedLinearGradientBuilder.createCoordinates(targetBoundingBox.getRight(), yCenter, targetBoundingBox.getLeft(), yCenter);
            }
            case TO_RIGHT: {
                return StrategyBasedLinearGradientBuilder.createCoordinates(targetBoundingBox.getLeft(), yCenter, targetBoundingBox.getRight(), yCenter);
            }
            case TO_TOP_LEFT: {
                return StrategyBasedLinearGradientBuilder.buildToCornerCoordinates(targetBoundingBox, new Point(targetBoundingBox.getRight(), targetBoundingBox.getTop()));
            }
            case TO_TOP_RIGHT: {
                return StrategyBasedLinearGradientBuilder.buildToCornerCoordinates(targetBoundingBox, new Point(targetBoundingBox.getRight(), targetBoundingBox.getBottom()));
            }
            case TO_BOTTOM_RIGHT: {
                return StrategyBasedLinearGradientBuilder.buildToCornerCoordinates(targetBoundingBox, new Point(targetBoundingBox.getLeft(), targetBoundingBox.getBottom()));
            }
            case TO_BOTTOM_LEFT: {
                return StrategyBasedLinearGradientBuilder.buildToCornerCoordinates(targetBoundingBox, new Point(targetBoundingBox.getLeft(), targetBoundingBox.getTop()));
            }
        }
        return StrategyBasedLinearGradientBuilder.createCoordinates(xCenter, targetBoundingBox.getTop(), xCenter, targetBoundingBox.getBottom());
    }

    private static Point[] buildCentralRotationCoordinates(Rectangle targetBoundingBox, double angle) {
        double xCenter = targetBoundingBox.getX() + targetBoundingBox.getWidth() / 2.0f;
        AffineTransform rotateInstance = AffineTransform.getRotateInstance(angle, xCenter, targetBoundingBox.getY() + targetBoundingBox.getHeight() / 2.0f);
        return StrategyBasedLinearGradientBuilder.buildCoordinates(targetBoundingBox, rotateInstance);
    }

    private static Point[] buildToCornerCoordinates(Rectangle targetBoundingBox, Point gradientCenterLineRightCorner) {
        AffineTransform transform = StrategyBasedLinearGradientBuilder.buildToCornerTransform(new Point(targetBoundingBox.getX() + targetBoundingBox.getWidth() / 2.0f, targetBoundingBox.getY() + targetBoundingBox.getHeight() / 2.0f), gradientCenterLineRightCorner);
        return StrategyBasedLinearGradientBuilder.buildCoordinates(targetBoundingBox, transform);
    }

    private static AffineTransform buildToCornerTransform(Point center, Point gradientCenterLineRightCorner) {
        double scale = 1.0 / center.distance(gradientCenterLineRightCorner);
        double sin = (gradientCenterLineRightCorner.getY() - center.getY()) * scale;
        double cos = (gradientCenterLineRightCorner.getX() - center.getX()) * scale;
        if (Math.abs(cos) < 1.0E-10) {
            cos = 0.0;
            sin = sin > 0.0 ? 1.0 : -1.0;
        } else if (Math.abs(sin) < 1.0E-10) {
            sin = 0.0;
            cos = cos > 0.0 ? 1.0 : -1.0;
        }
        double m02 = center.getX() * (1.0 - cos) + center.getY() * sin;
        double m12 = center.getY() * (1.0 - cos) - center.getX() * sin;
        return new AffineTransform(cos, sin, -sin, cos, m02, m12);
    }

    private static Point[] buildCoordinates(Rectangle targetBoundingBox, AffineTransform transformation) {
        double xCenter = targetBoundingBox.getX() + targetBoundingBox.getWidth() / 2.0f;
        Point start = transformation.transform(new Point(xCenter, targetBoundingBox.getBottom()), null);
        Point end = transformation.transform(new Point(xCenter, targetBoundingBox.getTop()), null);
        Point[] baseVector = new Point[]{start, end};
        double[] targetDomain = StrategyBasedLinearGradientBuilder.evaluateCoveringDomain(baseVector, targetBoundingBox);
        return StrategyBasedLinearGradientBuilder.createCoordinatesForNewDomain(targetDomain, baseVector);
    }

    private static Point[] createCoordinates(double x1, double y1, double x2, double y2) {
        return new Point[]{new Point(x1, y1), new Point(x2, y2)};
    }

    public static enum GradientStrategy {
        TO_BOTTOM,
        TO_BOTTOM_LEFT,
        TO_BOTTOM_RIGHT,
        TO_LEFT,
        TO_RIGHT,
        TO_TOP,
        TO_TOP_LEFT,
        TO_TOP_RIGHT;

    }
}

