/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.CjkResourceLoader;
import com.itextpdf.io.font.cmap.CMapLocationFromBytes;
import com.itextpdf.io.font.cmap.CMapLocationResource;
import com.itextpdf.io.font.cmap.CMapParser;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.cmap.CMapUniCid;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtil {
    private static final SecureRandom NUMBER_GENERATOR = new SecureRandom();
    private static final HashMap<String, CMapToUnicode> uniMaps = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(FontUtil.class);
    private static final String UNIVERSAL_CMAP_DIR = "toUnicode/";
    private static final Set<String> UNIVERSAL_CMAP_ORDERINGS = new HashSet<String>(Arrays.asList("CNS1", "GB1", "Japan1", "Korea1", "KR"));

    private FontUtil() {
    }

    public static String addRandomSubsetPrefixForFontName(String fontName) {
        StringBuilder newFontName = FontUtil.getRandomFontPrefix(6);
        newFontName.append('+').append(fontName);
        return newFontName.toString();
    }

    static CMapToUnicode processToUnicode(PdfObject toUnicode) {
        CMapToUnicode cMapToUnicode = null;
        if (toUnicode instanceof PdfStream) {
            try {
                byte[] uniBytes = ((PdfStream)toUnicode).getBytes();
                CMapLocationFromBytes lb = new CMapLocationFromBytes(uniBytes);
                cMapToUnicode = new CMapToUnicode();
                CMapParser.parseCid("", cMapToUnicode, lb);
            }
            catch (Exception e) {
                LOGGER.error("Unknown error while processing CMap.", e);
                cMapToUnicode = CMapToUnicode.EmptyCMapToUnicodeMap;
            }
        } else if (PdfName.IdentityH.equals(toUnicode)) {
            cMapToUnicode = CMapToUnicode.getIdentity();
        }
        return cMapToUnicode;
    }

    static CMapToUnicode parseUniversalToUnicodeCMap(String ordering) {
        if (!UNIVERSAL_CMAP_ORDERINGS.contains(ordering)) {
            return null;
        }
        String cmapRelPath = "toUnicode/Adobe-" + ordering + "-UCS2";
        CMapToUnicode cMapToUnicode = new CMapToUnicode();
        try {
            CMapParser.parseCid(cmapRelPath, cMapToUnicode, new CMapLocationResource());
        }
        catch (Exception e) {
            LOGGER.error("Unknown error while processing CMap.", e);
            return null;
        }
        return cMapToUnicode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CMapToUnicode getToUnicodeFromUniMap(String uniMap) {
        if (uniMap == null) {
            return null;
        }
        HashMap<String, CMapToUnicode> hashMap = uniMaps;
        synchronized (hashMap) {
            CMapToUnicode toUnicode;
            if (uniMaps.containsKey(uniMap)) {
                return uniMaps.get(uniMap);
            }
            if ("Identity-H".equals(uniMap)) {
                toUnicode = CMapToUnicode.getIdentity();
            } else {
                CMapUniCid uni = CjkResourceLoader.getUni2CidCmap(uniMap);
                toUnicode = uni.exportToUnicode();
            }
            uniMaps.put(uniMap, toUnicode);
            return toUnicode;
        }
    }

    static String createRandomFontName() {
        return FontUtil.getRandomFontPrefix(7).toString();
    }

    static int[] convertSimpleWidthsArray(PdfArray widthsArray, int first, int missingWidth) {
        int[] res = new int[256];
        Arrays.fill(res, missingWidth);
        if (widthsArray == null) {
            Logger logger = LoggerFactory.getLogger(FontUtil.class);
            logger.warn("Font dictionary does not contain required /Widths entry.");
            return res;
        }
        for (int i = 0; i < widthsArray.size() && first + i < 256; ++i) {
            PdfNumber number = widthsArray.getAsNumber(i);
            res[first + i] = number != null ? number.intValue() : missingWidth;
        }
        return res;
    }

    static IntHashtable convertCompositeWidthsArray(PdfArray widthsArray) {
        IntHashtable res = new IntHashtable();
        if (widthsArray == null) {
            return res;
        }
        for (int k = 0; k < widthsArray.size(); ++k) {
            PdfObject obj;
            int c1 = widthsArray.getAsNumber(k).intValue();
            if ((obj = widthsArray.get(++k)).isArray()) {
                PdfArray subWidths = (PdfArray)obj;
                for (int j = 0; j < subWidths.size(); ++j) {
                    int c2 = subWidths.getAsNumber(j).intValue();
                    res.put(c1++, c2);
                }
                continue;
            }
            int c2 = ((PdfNumber)obj).intValue();
            int w = widthsArray.getAsNumber(++k).intValue();
            while (c1 <= c2) {
                res.put(c1, w);
                ++c1;
            }
        }
        return res;
    }

    private static StringBuilder getRandomFontPrefix(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        byte[] randomByte = new byte[length];
        NUMBER_GENERATOR.nextBytes(randomByte);
        for (int k = 0; k < length; ++k) {
            stringBuilder.append((char)(Math.abs(randomByte[k] % 26) + 65));
        }
        return stringBuilder;
    }
}

