/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.function;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.function.BaseInputOutPutConvertors;
import com.itextpdf.kernel.pdf.function.IPdfFunction;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractPdfFunction<T extends PdfDictionary>
extends PdfObjectWrapper<T>
implements IPdfFunction {
    private final int functionType;
    private double[] domain;
    private double[] range;

    protected AbstractPdfFunction(T pdfObject, int functionType, double[] domain, double[] range) {
        super(pdfObject);
        this.functionType = functionType;
        if (domain != null) {
            this.domain = Arrays.copyOf(domain, domain.length);
            ((PdfDictionary)pdfObject).put(PdfName.Domain, new PdfArray(domain));
        }
        if (range != null) {
            this.range = Arrays.copyOf(range, range.length);
            ((PdfDictionary)pdfObject).put(PdfName.Range, new PdfArray(range));
        }
        ((PdfDictionary)pdfObject).put(PdfName.FunctionType, new PdfNumber(functionType));
    }

    protected AbstractPdfFunction(T pdfObject) {
        super(pdfObject);
        PdfNumber functionTypeObj = ((PdfDictionary)pdfObject).getAsNumber(PdfName.FunctionType);
        this.functionType = functionTypeObj == null ? -1 : functionTypeObj.intValue();
        PdfArray domainObj = ((PdfDictionary)pdfObject).getAsArray(PdfName.Domain);
        this.domain = domainObj == null ? null : domainObj.toDoubleArray();
        PdfArray rangeObj = ((PdfDictionary)pdfObject).getAsArray(PdfName.Range);
        this.range = rangeObj == null ? null : rangeObj.toDoubleArray();
    }

    @Override
    public int getFunctionType() {
        return this.functionType;
    }

    @Override
    public boolean checkCompatibilityWithColorSpace(PdfColorSpace alternateSpace) {
        return this.getOutputSize() == alternateSpace.getNumberOfComponents();
    }

    @Override
    public int getInputSize() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Domain).size() / 2;
    }

    @Override
    public int getOutputSize() {
        return this.range == null ? 0 : this.range.length / 2;
    }

    @Override
    public double[] getDomain() {
        if (this.domain == null) {
            return null;
        }
        return Arrays.copyOf(this.domain, this.domain.length);
    }

    @Override
    public void setDomain(double[] value) {
        this.domain = Arrays.copyOf(value, value.length);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Domain, new PdfArray(this.domain));
    }

    @Override
    public double[] getRange() {
        if (this.range != null) {
            return Arrays.copyOf(this.range, this.range.length);
        }
        return null;
    }

    @Override
    public void setRange(double[] value) {
        if (value == null) {
            ((PdfDictionary)this.getPdfObject()).remove(PdfName.Range);
            return;
        }
        this.range = Arrays.copyOf(value, value.length);
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Range, new PdfArray(this.range));
    }

    @Override
    public byte[] calculateFromByteArray(byte[] bytes, int offset, int length, int wordSizeInputLength, int wordSizeOutputLength) throws IOException {
        return this.calculateFromByteArray(bytes, offset, length, wordSizeInputLength, wordSizeOutputLength, null, null);
    }

    @Override
    public byte[] calculateFromByteArray(byte[] bytes, int offset, int length, int wordSizeInputLength, int wordSizeOutputLength, BaseInputOutPutConvertors.IInputConversionFunction inputConvertor, BaseInputOutPutConvertors.IOutputConversionFunction outputConvertor) throws IOException {
        BaseInputOutPutConvertors.IOutputConversionFunction actualOutputConvertor;
        int bytesPerInputWord = (int)Math.ceil((double)wordSizeInputLength / 8.0);
        int bytesPerOutputWord = (int)Math.ceil((double)wordSizeOutputLength / 8.0);
        int inputSize = this.getInputSize();
        int outputSize = this.getOutputSize();
        BaseInputOutPutConvertors.IInputConversionFunction actualInputConvertor = inputConvertor;
        if (actualInputConvertor == null) {
            actualInputConvertor = BaseInputOutPutConvertors.getInputConvertor(bytesPerInputWord, 1.0);
        }
        if ((actualOutputConvertor = outputConvertor) == null) {
            actualOutputConvertor = BaseInputOutPutConvertors.getOutputConvertor(bytesPerOutputWord, 1.0);
        }
        double[] inValues = actualInputConvertor.convert(bytes, offset, length);
        double[] outValues = new double[inValues.length / inputSize * outputSize];
        int outIndex = 0;
        for (int i = 0; i < inValues.length; i += inputSize) {
            double[] singleRes = this.calculate(Arrays.copyOfRange(inValues, i, i + inputSize));
            System.arraycopy(singleRes, 0, outValues, outIndex, singleRes.length);
            outIndex += singleRes.length;
        }
        return actualOutputConvertor.convert(outValues);
    }

    @Override
    public double[] clipInput(double[] input) {
        if (input.length * 2 != this.domain.length) {
            throw new IllegalArgumentException("The size of the input array must be a multiple of the domain size");
        }
        return AbstractPdfFunction.clip(input, this.domain);
    }

    @Override
    public double[] clipOutput(double[] input) {
        if (this.range == null) {
            return input;
        }
        if (input.length * 2 != this.range.length) {
            throw new IllegalArgumentException("The size of the input array must be a multiple of the range size");
        }
        return AbstractPdfFunction.clip(input, this.range);
    }

    @Override
    public PdfObject getAsPdfObject() {
        return super.getPdfObject();
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }

    protected static double[] clip(double[] values, double[] limits) {
        assert (values.length * 2 == limits.length);
        double[] result = new double[values.length];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            double lowerBound = limits[j++];
            double upperBound = limits[j++];
            result[i] = Math.min(Math.max(lowerBound, values[i]), upperBound);
        }
        return result;
    }

    protected static double[] normalize(double[] values, double[] limits) {
        assert (values.length * 2 == limits.length);
        double[] normal = new double[values.length];
        int j = 0;
        for (int i = 0; i < values.length; ++i) {
            double lowerBound = limits[j++];
            double upperBound = Math.max(lowerBound + Double.MIN_VALUE, limits[j++]);
            normal[i] = Math.min(Math.max(0.0, (values[i] - lowerBound) / (upperBound - lowerBound)), 1.0);
        }
        return normal;
    }

    protected static double[] convertFloatArrayToDoubleArray(float[] array) {
        if (array == null) {
            return null;
        }
        double[] arrayDouble = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            arrayDouble[i] = array[i];
        }
        return arrayDouble;
    }
}

