/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.function;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.function.AbstractPdfFunction;
import com.itextpdf.kernel.pdf.function.IPdfFunction;
import com.itextpdf.kernel.pdf.function.IPdfFunctionFactory;
import com.itextpdf.kernel.pdf.function.PdfFunctionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PdfType3Function
extends AbstractPdfFunction<PdfDictionary> {
    private static final IPdfFunctionFactory DEFAULT_FUNCTION_FACTORY = pdfObject -> PdfFunctionFactory.create(pdfObject);
    private final IPdfFunctionFactory functionFactory;
    private List<IPdfFunction> functions;
    private double[] bounds;
    private double[] encode;

    public PdfType3Function(PdfDictionary dict) {
        this(dict, DEFAULT_FUNCTION_FACTORY);
    }

    public PdfType3Function(double[] domain, double[] range, List<AbstractPdfFunction<? extends PdfDictionary>> functions, double[] bounds, double[] encode) {
        super(new PdfDictionary(), 3, domain, range);
        this.functionFactory = DEFAULT_FUNCTION_FACTORY;
        PdfArray funcs = new PdfArray();
        for (AbstractPdfFunction<? extends PdfDictionary> func : functions) {
            funcs.add((PdfObject)func.getPdfObject());
        }
        ((PdfDictionary)super.getPdfObject()).put(PdfName.Functions, funcs);
        ((PdfDictionary)super.getPdfObject()).put(PdfName.Bounds, new PdfArray(bounds));
        ((PdfDictionary)super.getPdfObject()).put(PdfName.Encode, new PdfArray(encode));
    }

    public PdfType3Function(float[] domain, float[] range, List<AbstractPdfFunction<? extends PdfDictionary>> functions, float[] bounds, float[] encode) {
        this(PdfType3Function.convertFloatArrayToDoubleArray(domain), PdfType3Function.convertFloatArrayToDoubleArray(range), functions, PdfType3Function.convertFloatArrayToDoubleArray(bounds), PdfType3Function.convertFloatArrayToDoubleArray(encode));
    }

    PdfType3Function(PdfDictionary dict, IPdfFunctionFactory functionFactory) {
        super(dict);
        this.functionFactory = functionFactory;
        PdfArray functionsArray = dict.getAsArray(PdfName.Functions);
        this.functions = Collections.unmodifiableList(this.checkAndGetFunctions(functionsArray));
        if (super.getDomain().length < 2) {
            throw new PdfException("Invalid PDF Type 3 Function object, \"Domain\" array shall consist of 2 numbers.");
        }
        PdfArray boundsArray = dict.getAsArray(PdfName.Bounds);
        this.bounds = this.checkAndGetBounds(boundsArray);
        PdfArray encodeArray = dict.getAsArray(PdfName.Encode);
        this.encode = this.checkAndGetEncode(encodeArray);
    }

    public Collection<IPdfFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Iterable<AbstractPdfFunction<? extends PdfDictionary>> value) {
        PdfArray pdfFunctions = new PdfArray();
        for (AbstractPdfFunction<? extends PdfDictionary> f : value) {
            pdfFunctions.add(((PdfDictionary)f.getPdfObject()).getIndirectReference());
        }
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Functions, pdfFunctions);
    }

    public double[] getBounds() {
        return this.bounds;
    }

    public void setBounds(double[] value) {
        this.bounds = Arrays.copyOf(value, value.length);
    }

    public double[] getEncode() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Encode).toDoubleArray();
    }

    public void setEncode(double[] value) {
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Encode, new PdfArray(value));
    }

    @Override
    public boolean checkCompatibilityWithColorSpace(PdfColorSpace alternateSpace) {
        return false;
    }

    @Override
    public int getOutputSize() {
        return this.getRange() == null ? this.functions.get(0).getOutputSize() : this.getRange().length / 2;
    }

    @Override
    public double[] calculate(double[] input) {
        if (input == null || input.length != 1) {
            throw new PdfException("Invalid input value for PDF Type 3 Function, value should be a single number.");
        }
        double[] clipped = this.clipInput(input);
        double x = clipped[0];
        int subdomain = this.calculateSubdomain(x);
        double[] subdomainBorders = this.getSubdomainBorders(subdomain);
        x = PdfType3Function.mapValueFromActualRangeToExpected(x, subdomainBorders[0], subdomainBorders[1], this.encode[subdomain * 2], this.encode[subdomain * 2 + 1]);
        double[] output = this.functions.get(subdomain).calculate(new double[]{x});
        return this.clipOutput(output);
    }

    private int calculateSubdomain(double inputValue) {
        if (this.bounds.length > 0) {
            if (PdfType3Function.areThreeDoubleEqual(this.bounds[0], this.getDomain()[0], inputValue)) {
                return 0;
            }
            if (PdfType3Function.areThreeDoubleEqual(this.bounds[this.bounds.length - 1], this.getDomain()[1], inputValue)) {
                return this.bounds.length;
            }
        }
        for (int i = 0; i < this.bounds.length; ++i) {
            if (!(inputValue < this.bounds[i])) continue;
            return i;
        }
        return this.bounds.length;
    }

    private double[] getSubdomainBorders(int subdomain) {
        if (this.bounds.length == 0) {
            return this.getDomain();
        }
        if (subdomain == 0) {
            return new double[]{this.getDomain()[0], this.bounds[0]};
        }
        if (subdomain == this.bounds.length) {
            return new double[]{this.bounds[this.bounds.length - 1], this.getDomain()[1]};
        }
        return new double[]{this.bounds[subdomain - 1], this.bounds[subdomain]};
    }

    private List<IPdfFunction> checkAndGetFunctions(PdfArray functionsArray) {
        if (functionsArray == null || functionsArray.size() == 0) {
            throw new PdfException("Invalid PDF Type 3 Function object, \"Functions\" array should exist and can't be empty.");
        }
        Integer tempOutputSize = null;
        if (this.getRange() != null) {
            tempOutputSize = this.getOutputSize();
        }
        ArrayList<IPdfFunction> tempFunctions = new ArrayList<IPdfFunction>();
        for (PdfObject funcObj : functionsArray) {
            if (!(funcObj instanceof PdfDictionary)) continue;
            PdfDictionary funcDict = (PdfDictionary)funcObj;
            IPdfFunction tempFunc = this.functionFactory.create(funcDict);
            if (tempOutputSize == null) {
                tempOutputSize = tempFunc.getOutputSize();
            }
            if (tempOutputSize.intValue() != tempFunc.getOutputSize()) {
                throw new PdfException("Invalid PDF Type 3 Function object, the output dimensionality of all functions shall be the same, and compatible with the value of \"Range\".");
            }
            if (tempFunc.getInputSize() != 1) {
                throw new PdfException("Invalid PDF Type 3 Function object, all functions shall have 1 input value.");
            }
            tempFunctions.add(tempFunc);
        }
        return tempFunctions;
    }

    private double[] checkAndGetBounds(PdfArray boundsArray) {
        if (boundsArray == null || boundsArray.size() != this.functions.size() - 1) {
            throw new PdfException("Invalid PDF Type 3 Function object, \"Bounds\" array should exist and its size should correspond to the size of the \"Functions\" array.");
        }
        double[] bounds = boundsArray.toDoubleArray();
        boolean areBoundsInvalid = false;
        for (int i = 0; i < bounds.length; ++i) {
            areBoundsInvalid |= i == 0 ? bounds[i] < this.getDomain()[0] : bounds[i] <= this.getDomain()[0];
            areBoundsInvalid |= i == bounds.length - 1 ? this.getDomain()[1] < bounds[i] : this.getDomain()[1] <= bounds[i];
            areBoundsInvalid |= i != 0 && bounds[i] <= bounds[i - 1];
        }
        if (areBoundsInvalid) {
            throw new PdfException("Invalid PDF Type 3 Function object, \"Bounds\" elements shall be in order of increasing value, and each value shall be within the domain defined by \"Domain\".");
        }
        return bounds;
    }

    private double[] checkAndGetEncode(PdfArray encodeArray) {
        if (encodeArray == null || encodeArray.size() < this.functions.size() * 2) {
            throw new PdfException("Invalid PDF Type 3 Function object, \"Encode\" array should exist and its size should be 2 times more than the size of the \"Functions\" array.");
        }
        return encodeArray.toDoubleArray();
    }

    private static double mapValueFromActualRangeToExpected(double value, double aStart, double aEnd, double eStart, double eEnd) {
        double actualRangeLength = aEnd - aStart;
        if (actualRangeLength == 0.0) {
            return eStart;
        }
        double expectedRangeLength = eEnd - eStart;
        double x = value - aStart;
        double y = expectedRangeLength / actualRangeLength * x;
        return eStart + y;
    }

    private static boolean areThreeDoubleEqual(double first, double second, double third) {
        return Double.compare(first, second) == 0 && Double.compare(second, third) == 0;
    }
}

