/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.tagutils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagutils.ITagTreeIteratorHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TagTreeIterator {
    private final IStructureNode pointer;
    private final Set<ITagTreeIteratorHandler> handlerList;

    public TagTreeIterator(IStructureNode tagTreePointer) {
        if (tagTreePointer == null) {
            throw new IllegalArgumentException(MessageFormatUtil.format("{0} should not be null.", "tagTreepointer"));
        }
        this.pointer = tagTreePointer;
        this.handlerList = new HashSet<ITagTreeIteratorHandler>();
    }

    public TagTreeIterator addHandler(ITagTreeIteratorHandler handler) {
        this.handlerList.add(handler);
        return this;
    }

    public void traverse() {
        TagTreeIterator.traverse(this.pointer, this.handlerList);
    }

    private static void traverse(IStructureNode elem, Set<ITagTreeIteratorHandler> handlerList) {
        for (ITagTreeIteratorHandler handler : handlerList) {
            handler.nextElement(elem);
        }
        List<IStructureNode> kids = elem.getKids();
        if (kids != null) {
            for (IStructureNode kid : kids) {
                TagTreeIterator.traverse(kid, handlerList);
            }
        }
    }
}

