/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils.objectpathitems;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.utils.objectpathitems.ArrayPathItem;
import com.itextpdf.kernel.utils.objectpathitems.DictPathItem;
import com.itextpdf.kernel.utils.objectpathitems.IndirectPathItem;
import com.itextpdf.kernel.utils.objectpathitems.LocalPathItem;
import com.itextpdf.kernel.utils.objectpathitems.OffsetPathItem;
import java.util.ArrayList;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectPath {
    protected Stack<LocalPathItem> path = new Stack();
    private PdfIndirectReference baseCmpObject;
    private PdfIndirectReference baseOutObject;
    private Stack<IndirectPathItem> indirects = new Stack();

    public ObjectPath() {
    }

    public ObjectPath(ObjectPath objectPath) {
        this.baseCmpObject = objectPath.getBaseCmpObject();
        this.baseOutObject = objectPath.getBaseOutObject();
        this.path = objectPath.getLocalPath();
        this.indirects = objectPath.getIndirectPath();
    }

    public ObjectPath(PdfIndirectReference baseCmpObject, PdfIndirectReference baseOutObject) {
        this.baseCmpObject = baseCmpObject;
        this.baseOutObject = baseOutObject;
        this.indirects.push(new IndirectPathItem(baseCmpObject, baseOutObject));
    }

    public ObjectPath(PdfIndirectReference baseCmpObject, PdfIndirectReference baseOutObject, Stack<LocalPathItem> path, Stack<IndirectPathItem> indirects) {
        this.baseCmpObject = baseCmpObject;
        this.baseOutObject = baseOutObject;
        this.path = (Stack)path.clone();
        this.indirects = (Stack)indirects.clone();
    }

    public ObjectPath resetDirectPath(PdfIndirectReference baseCmpObject, PdfIndirectReference baseOutObject) {
        ObjectPath newPath = new ObjectPath(baseCmpObject, baseOutObject, new Stack<LocalPathItem>(), (Stack)this.indirects.clone());
        newPath.indirects.push(new IndirectPathItem(baseCmpObject, baseOutObject));
        return newPath;
    }

    public boolean isComparing(PdfIndirectReference cmpObject, PdfIndirectReference outObject) {
        return this.indirects.contains(new IndirectPathItem(cmpObject, outObject));
    }

    public void pushArrayItemToPath(int index) {
        this.path.push(new ArrayPathItem(index));
    }

    public void pushDictItemToPath(PdfName key) {
        this.path.push(new DictPathItem(key));
    }

    public void pushOffsetToPath(int offset) {
        this.path.push(new OffsetPathItem(offset));
    }

    public void pop() {
        this.path.pop();
    }

    public Stack<LocalPathItem> getLocalPath() {
        return (Stack)this.path.clone();
    }

    public Stack<IndirectPathItem> getIndirectPath() {
        return (Stack)this.indirects.clone();
    }

    public PdfIndirectReference getBaseCmpObject() {
        return this.baseCmpObject;
    }

    public PdfIndirectReference getBaseOutObject() {
        return this.baseOutObject;
    }

    public Node toXmlNode(Document document) {
        int i;
        Element element = document.createElement("path");
        Element baseNode = document.createElement("base");
        baseNode.setAttribute("cmp", MessageFormatUtil.format("{0} {1} obj", this.baseCmpObject.getObjNumber(), this.baseCmpObject.getGenNumber()));
        baseNode.setAttribute("out", MessageFormatUtil.format("{0} {1} obj", this.baseOutObject.getObjNumber(), this.baseOutObject.getGenNumber()));
        element.appendChild(baseNode);
        Stack pathClone = (Stack)this.path.clone();
        ArrayList localPathItems = new ArrayList(this.path.size());
        for (i = 0; i < this.path.size(); ++i) {
            localPathItems.add(pathClone.pop());
        }
        for (i = localPathItems.size() - 1; i >= 0; --i) {
            element.appendChild(((LocalPathItem)localPathItems.get(i)).toXmlNode(document));
        }
        return element;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormatUtil.format("Base cmp object: {0} obj. Base out object: {1} obj", this.baseCmpObject, this.baseOutObject));
        Stack pathClone = (Stack)this.path.clone();
        ArrayList localPathItems = new ArrayList(this.path.size());
        for (i = 0; i < this.path.size(); ++i) {
            localPathItems.add(pathClone.pop());
        }
        for (i = localPathItems.size() - 1; i >= 0; --i) {
            sb.append('\n');
            sb.append(((LocalPathItem)localPathItems.get(i)).toString());
        }
        return sb.toString();
    }

    public int hashCode() {
        int baseCmpObjectHashCode = 0;
        if (this.baseCmpObject != null) {
            baseCmpObjectHashCode = this.baseCmpObject.getObjNumber() * 31 + this.baseCmpObject.getGenNumber();
        }
        int baseOutObjectHashCode = 0;
        if (this.baseOutObject != null) {
            baseOutObjectHashCode = this.baseOutObject.getObjNumber() * 31 + this.baseOutObject.getGenNumber();
        }
        int hashCode = baseCmpObjectHashCode * 31 + baseOutObjectHashCode;
        for (LocalPathItem pathItem : this.path) {
            hashCode *= 31;
            hashCode += pathItem.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        boolean isBaseCmpObjectEqual;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectPath that = (ObjectPath)obj;
        if (this.baseCmpObject == that.baseCmpObject) {
            isBaseCmpObjectEqual = true;
        } else if (this.baseCmpObject == null || that.baseCmpObject == null || this.baseCmpObject.getClass() != that.baseCmpObject.getClass()) {
            isBaseCmpObjectEqual = false;
        } else {
            boolean bl = isBaseCmpObjectEqual = this.baseCmpObject.getObjNumber() == that.baseCmpObject.getObjNumber() && this.baseCmpObject.getGenNumber() == that.baseCmpObject.getGenNumber();
        }
        boolean isBaseOutObjectEqual = this.baseOutObject == that.baseOutObject ? true : (this.baseOutObject == null || that.baseOutObject == null || this.baseOutObject.getClass() != that.baseOutObject.getClass() ? false : this.baseOutObject.getObjNumber() == that.baseOutObject.getObjNumber() && this.baseOutObject.getGenNumber() == that.baseOutObject.getGenNumber());
        return isBaseCmpObjectEqual && isBaseOutObjectEqual && this.path.equals(((ObjectPath)obj).path);
    }
}

