/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.xmp.impl;

import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.options.PropertyOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class XMPNode
implements Comparable {
    private String name;
    private String value;
    private XMPNode parent;
    private List children = null;
    private List qualifier = null;
    private PropertyOptions options = null;
    private boolean implicit;
    private boolean hasAliases;
    private boolean alias;
    private boolean hasValueChild;

    public XMPNode(String name, String value, PropertyOptions options) {
        this.name = name;
        this.value = value;
        this.options = options;
    }

    public XMPNode(String name, PropertyOptions options) {
        this(name, null, options);
    }

    public void clear() {
        this.options = null;
        this.name = null;
        this.value = null;
        this.children = null;
        this.qualifier = null;
    }

    public XMPNode getParent() {
        return this.parent;
    }

    public XMPNode getChild(int index) {
        return (XMPNode)this.getChildren().get(index - 1);
    }

    public void addChild(XMPNode node) throws XMPException {
        this.assertChildNotExisting(node.getName());
        node.setParent(this);
        this.getChildren().add(node);
    }

    public void addChild(int index, XMPNode node) throws XMPException {
        this.assertChildNotExisting(node.getName());
        node.setParent(this);
        this.getChildren().add(index - 1, node);
    }

    public void replaceChild(int index, XMPNode node) {
        node.setParent(this);
        this.getChildren().set(index - 1, node);
    }

    public void removeChild(int itemIndex) {
        this.getChildren().remove(itemIndex - 1);
        this.cleanupChildren();
    }

    public void removeChild(XMPNode node) {
        this.getChildren().remove(node);
        this.cleanupChildren();
    }

    protected void cleanupChildren() {
        if (this.children.size() == 0) {
            this.children = null;
        }
    }

    public void removeChildren() {
        this.children = null;
    }

    public int getChildrenLength() {
        return this.children != null ? this.children.size() : 0;
    }

    public XMPNode findChildByName(String expr) {
        return this.find(this.getChildren(), expr);
    }

    public XMPNode getQualifier(int index) {
        return (XMPNode)this.getQualifier().get(index - 1);
    }

    public int getQualifierLength() {
        return this.qualifier != null ? this.qualifier.size() : 0;
    }

    public void addQualifier(XMPNode qualNode) throws XMPException {
        this.assertQualifierNotExisting(qualNode.getName());
        qualNode.setParent(this);
        qualNode.getOptions().setQualifier(true);
        this.getOptions().setHasQualifiers(true);
        if (qualNode.isLanguageNode()) {
            this.options.setHasLanguage(true);
            this.getQualifier().add(0, qualNode);
        } else if (qualNode.isTypeNode()) {
            this.options.setHasType(true);
            this.getQualifier().add(!this.options.getHasLanguage() ? 0 : 1, qualNode);
        } else {
            this.getQualifier().add(qualNode);
        }
    }

    public void removeQualifier(XMPNode qualNode) {
        PropertyOptions opts = this.getOptions();
        if (qualNode.isLanguageNode()) {
            opts.setHasLanguage(false);
        } else if (qualNode.isTypeNode()) {
            opts.setHasType(false);
        }
        this.getQualifier().remove(qualNode);
        if (this.qualifier.size() == 0) {
            opts.setHasQualifiers(false);
            this.qualifier = null;
        }
    }

    public void removeQualifiers() {
        PropertyOptions opts = this.getOptions();
        opts.setHasQualifiers(false);
        opts.setHasLanguage(false);
        opts.setHasType(false);
        this.qualifier = null;
    }

    public XMPNode findQualifierByName(String expr) {
        return this.find(this.qualifier, expr);
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public Iterator iterateChildren() {
        if (this.children != null) {
            return this.getChildren().iterator();
        }
        return Collections.emptyIterator();
    }

    public boolean hasQualifier() {
        return this.qualifier != null && this.qualifier.size() > 0;
    }

    public Iterator iterateQualifier() {
        if (this.qualifier != null) {
            final Iterator it = this.getQualifier().iterator();
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                public Object next() {
                    return it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove() is not allowed due to the internal contraints");
                }
            };
        }
        return Collections.emptyIterator();
    }

    public Object clone() {
        PropertyOptions newOptions;
        try {
            newOptions = new PropertyOptions(this.getOptions().getOptions());
        }
        catch (XMPException e) {
            newOptions = new PropertyOptions();
        }
        XMPNode newNode = new XMPNode(this.name, this.value, newOptions);
        this.cloneSubtree(newNode);
        return newNode;
    }

    public void cloneSubtree(XMPNode destination) {
        block4: {
            try {
                Iterator it = this.iterateChildren();
                while (it.hasNext()) {
                    XMPNode child = (XMPNode)it.next();
                    destination.addChild((XMPNode)child.clone());
                }
                it = this.iterateQualifier();
                while (it.hasNext()) {
                    XMPNode qualifier = (XMPNode)it.next();
                    destination.addQualifier((XMPNode)qualifier.clone());
                }
            }
            catch (XMPException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    public String dumpNode(boolean recursive) {
        StringBuffer result = new StringBuffer(512);
        this.dumpNode(result, recursive, 0, 0);
        return result.toString();
    }

    public int compareTo(Object xmpNode) {
        if (this.getOptions().isSchemaNode()) {
            return this.value.compareTo(((XMPNode)xmpNode).getValue());
        }
        return this.name.compareTo(((XMPNode)xmpNode).getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PropertyOptions getOptions() {
        if (this.options == null) {
            this.options = new PropertyOptions();
        }
        return this.options;
    }

    public void setOptions(PropertyOptions options) {
        this.options = options;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean getHasAliases() {
        return this.hasAliases;
    }

    public void setHasAliases(boolean hasAliases) {
        this.hasAliases = hasAliases;
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    public boolean getHasValueChild() {
        return this.hasValueChild;
    }

    public void setHasValueChild(boolean hasValueChild) {
        this.hasValueChild = hasValueChild;
    }

    public void sort() {
        if (this.hasQualifier()) {
            int sortFrom;
            Object[] quals = this.getQualifier().toArray(new XMPNode[this.getQualifierLength()]);
            for (sortFrom = 0; quals.length > sortFrom && ("xml:lang".equals(quals[sortFrom].getName()) || "rdf:type".equals(((XMPNode)quals[sortFrom]).getName())); ++sortFrom) {
                ((XMPNode)quals[sortFrom]).sort();
            }
            Arrays.sort(quals, sortFrom, quals.length);
            ListIterator<Object> it = this.qualifier.listIterator();
            for (int j = 0; j < quals.length; ++j) {
                it.next();
                it.set(quals[j]);
                ((XMPNode)quals[j]).sort();
            }
        }
        if (this.hasChildren()) {
            if (!this.getOptions().isArray()) {
                Collections.sort(this.children);
            }
            Iterator it = this.iterateChildren();
            while (it.hasNext()) {
                ((XMPNode)it.next()).sort();
            }
        }
    }

    private void dumpNode(StringBuffer result, boolean recursive, int indent, int index) {
        int i;
        for (int i2 = 0; i2 < indent; ++i2) {
            result.append('\t');
        }
        if (this.parent != null) {
            if (this.getOptions().isQualifier()) {
                result.append('?');
                result.append(this.name);
            } else if (this.getParent().getOptions().isArray()) {
                result.append('[');
                result.append(index);
                result.append(']');
            } else {
                result.append(this.name);
            }
        } else {
            result.append("ROOT NODE");
            if (this.name != null && this.name.length() > 0) {
                result.append(" (");
                result.append(this.name);
                result.append(')');
            }
        }
        if (this.value != null && this.value.length() > 0) {
            result.append(" = \"");
            result.append(this.value);
            result.append('\"');
        }
        if (this.getOptions().containsOneOf(-1)) {
            result.append("\t(");
            result.append(this.getOptions().toString());
            result.append(" : ");
            result.append(this.getOptions().getOptionsString());
            result.append(')');
        }
        result.append('\n');
        if (recursive && this.hasQualifier()) {
            Object[] quals = this.getQualifier().toArray(new XMPNode[this.getQualifierLength()]);
            for (i = 0; quals.length > i && ("xml:lang".equals(quals[i].getName()) || "rdf:type".equals(((XMPNode)quals[i]).getName())); ++i) {
            }
            Arrays.sort(quals, i, quals.length);
            for (i = 0; i < quals.length; ++i) {
                Object qualifier = quals[i];
                super.dumpNode(result, recursive, indent + 2, i + 1);
            }
        }
        if (recursive && this.hasChildren()) {
            Object[] children = this.getChildren().toArray(new XMPNode[this.getChildrenLength()]);
            if (!this.getOptions().isArray()) {
                Arrays.sort(children);
            }
            for (i = 0; i < children.length; ++i) {
                Object child = children[i];
                super.dumpNode(result, recursive, indent + 1, i + 1);
            }
        }
    }

    private boolean isLanguageNode() {
        return "xml:lang".equals(this.name);
    }

    private boolean isTypeNode() {
        return "rdf:type".equals(this.name);
    }

    protected List getChildren() {
        if (this.children == null) {
            this.children = new ArrayList(0);
        }
        return this.children;
    }

    public List getUnmodifiableChildren() {
        return Collections.unmodifiableList(new ArrayList(this.getChildren()));
    }

    private List getQualifier() {
        if (this.qualifier == null) {
            this.qualifier = new ArrayList(0);
        }
        return this.qualifier;
    }

    protected void setParent(XMPNode parent) {
        this.parent = parent;
    }

    private XMPNode find(List list, String expr) {
        if (list != null) {
            for (XMPNode child : list) {
                if (!child.getName().equals(expr)) continue;
                return child;
            }
        }
        return null;
    }

    private void assertChildNotExisting(String childName) throws XMPException {
        if (!"[]".equals(childName) && this.findChildByName(childName) != null) {
            throw new XMPException("Duplicate property or field node '" + childName + "'", 203);
        }
    }

    private void assertQualifierNotExisting(String qualifierName) throws XMPException {
        if (!"[]".equals(qualifierName) && this.findQualifierByName(qualifierName) != null) {
            throw new XMPException("Duplicate '" + qualifierName + "' qualifier", 203);
        }
    }
}

