/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.otf.ActualTextIterator;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.OverflowWrapPropertyValue;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.layout.renderer.TypographyUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class TextSequenceWordWrapping {
    private static final float OCCUPIED_AREA_RELAYOUT_EPS = 1.0E-4f;

    private TextSequenceWordWrapping() {
    }

    public static boolean isTextRendererAndRequiresSpecialScriptPreLayoutProcessing(IRenderer childRenderer) {
        return childRenderer instanceof TextRenderer && ((TextRenderer)childRenderer).getSpecialScriptsWordBreakPoints() == null && ((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(false) && !LineRenderer.isChildFloating(childRenderer);
    }

    public static void processSpecialScriptPreLayout(LineRenderer lineRenderer, int childPos) {
        SpecialScriptsContainingTextRendererSequenceInfo info = TextSequenceWordWrapping.getSpecialScriptsContainingTextRendererSequenceInfo(lineRenderer, childPos);
        int numberOfSequentialTextRenderers = info.numberOfSequentialTextRenderers;
        String sequentialTextContent = info.sequentialTextContent;
        List<Integer> indicesOfFloating = info.indicesOfFloating;
        List<Integer> possibleBreakPointsGlobal = TypographyUtils.getPossibleBreaks(sequentialTextContent);
        TextSequenceWordWrapping.distributePossibleBreakPointsOverSequentialTextRenderers(lineRenderer, childPos, numberOfSequentialTextRenderers, possibleBreakPointsGlobal, indicesOfFloating);
    }

    public static void updateTextSequenceLayoutResults(Map<Integer, LayoutResult> textRendererLayoutResults, boolean specialScripts, IRenderer childRenderer, int childPos, LayoutResult childResult) {
        if (childRenderer instanceof TextRenderer && ((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true) == specialScripts) {
            textRendererLayoutResults.put(childPos, childResult);
        }
    }

    public static void resetTextSequenceIfItEnded(Map<Integer, LayoutResult> textRendererLayoutResults, boolean specialScripts, IRenderer childRenderer, int childPos, MinMaxWidthOfTextRendererSequenceHelper minMaxWidthOfTextRendererSequenceHelper, boolean noSoftWrap, AbstractWidthHandler widthHandler) {
        if (childRenderer instanceof TextRenderer && ((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true) == specialScripts && !LineRenderer.isChildFloating(childRenderer)) {
            return;
        }
        if (!textRendererLayoutResults.isEmpty()) {
            int lastChildInTextSequence;
            for (lastChildInTextSequence = childPos; lastChildInTextSequence >= 0 && textRendererLayoutResults.get(lastChildInTextSequence) == null; --lastChildInTextSequence) {
            }
            LayoutResult childResult = textRendererLayoutResults.get(lastChildInTextSequence);
            TextSequenceWordWrapping.updateMinMaxWidthOfLineRendererAfterTextRendererSequenceProcessing(noSoftWrap, lastChildInTextSequence, childResult, widthHandler, minMaxWidthOfTextRendererSequenceHelper, textRendererLayoutResults);
            textRendererLayoutResults.clear();
        }
    }

    public static LineRenderer.LineAscentDescentState updateTextRendererSequenceAscentDescent(LineRenderer lineRenderer, Map<Integer, float[]> textRendererSequenceAscentDescent, int childPos, float[] childAscentDescent, LineRenderer.LineAscentDescentState preTextSequenceAscentDescent) {
        IRenderer childRenderer = (IRenderer)lineRenderer.childRenderers.get(childPos);
        if (childRenderer instanceof TextRenderer && !((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true)) {
            if (textRendererSequenceAscentDescent.isEmpty()) {
                preTextSequenceAscentDescent = new LineRenderer.LineAscentDescentState(lineRenderer.maxAscent, lineRenderer.maxDescent, lineRenderer.maxTextAscent, lineRenderer.maxTextDescent);
            }
            textRendererSequenceAscentDescent.put(childPos, childAscentDescent);
        } else if (!textRendererSequenceAscentDescent.isEmpty()) {
            textRendererSequenceAscentDescent.clear();
            preTextSequenceAscentDescent = null;
        }
        return preTextSequenceAscentDescent;
    }

    public static MinMaxWidthOfTextRendererSequenceHelper updateTextRendererSequenceMinMaxWidth(LineRenderer lineRenderer, AbstractWidthHandler widthHandler, int childPos, MinMaxWidthOfTextRendererSequenceHelper minMaxWidthOfTextRendererSequenceHelper, boolean anythingPlaced, Map<Integer, LayoutResult> textRendererLayoutResults, Map<Integer, LayoutResult> specialScriptLayoutResults, float textIndent) {
        IRenderer childRenderer = (IRenderer)lineRenderer.childRenderers.get(childPos);
        if (childRenderer instanceof TextRenderer) {
            boolean firstTextRendererWithoutSpecialScripts;
            boolean firstTextRendererWithSpecialScripts = ((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true) && specialScriptLayoutResults.size() == 1;
            boolean bl = firstTextRendererWithoutSpecialScripts = !((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true) && textRendererLayoutResults.size() == 1;
            if (firstTextRendererWithoutSpecialScripts || firstTextRendererWithSpecialScripts) {
                minMaxWidthOfTextRendererSequenceHelper = new MinMaxWidthOfTextRendererSequenceHelper(widthHandler.minMaxWidth.getChildrenMinWidth(), textIndent, anythingPlaced);
            }
            return minMaxWidthOfTextRendererSequenceHelper;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static LastFittingChildRendererData getIndexAndLayoutResultOfTheLastTextRendererWithNoSpecialScripts(LineRenderer lineRenderer, int childPos, Map<Integer, LayoutResult> textSequenceLayoutResults, boolean wasParentsHeightClipped, boolean isOverflowFit, boolean floatsPlaced) {
        LayoutResult lastAnalyzedTextLayoutResult = textSequenceLayoutResults.get(childPos);
        if (lastAnalyzedTextLayoutResult.getStatus() == 2 && !((TextLayoutResult)lastAnalyzedTextLayoutResult).isWordHasBeenSplit()) {
            return new LastFittingChildRendererData(childPos, textSequenceLayoutResults.get(childPos));
        }
        lastAnalyzedTextLayoutResult = null;
        int lastAnalyzedTextRenderer = childPos;
        int i = childPos;
        while (i >= 0) {
            if (lineRenderer.childRenderers.get(i) instanceof TextRenderer && !LineRenderer.isChildFloating((IRenderer)lineRenderer.childRenderers.get(i))) {
                TextRenderer textRenderer = (TextRenderer)lineRenderer.childRenderers.get(i);
                if (!textRenderer.textContainsSpecialScriptGlyphs(true)) {
                    TextLayoutResult textLayoutResult = (TextLayoutResult)textSequenceLayoutResults.get(i);
                    TextLayoutResult previousTextLayoutResult = (TextLayoutResult)textSequenceLayoutResults.get(lastAnalyzedTextRenderer);
                    if (i != lastAnalyzedTextRenderer && textLayoutResult.getStatus() == 1 && (previousTextLayoutResult.isStartsWithSplitCharacterWhiteSpace() || textLayoutResult.isEndsWithSplitCharacter())) {
                        lastAnalyzedTextLayoutResult = previousTextLayoutResult.getStatus() == 3 ? previousTextLayoutResult : new TextLayoutResult(3, null, null, (IRenderer)lineRenderer.childRenderers.get(lastAnalyzedTextRenderer));
                        break;
                    }
                    if (textLayoutResult.isContainsPossibleBreak() && textLayoutResult.getStatus() != 3) {
                        textRenderer.setIndexOfFirstCharacterToBeForcedToOverflow(textRenderer.line.end);
                        LayoutArea layoutArea = textRenderer.getOccupiedArea().clone();
                        layoutArea.getBBox().increaseHeight(1.0E-4f).increaseWidth(1.0E-4f);
                        LayoutResult newChildLayoutResult = textRenderer.layout(new LayoutContext(layoutArea, wasParentsHeightClipped));
                        textRenderer.setIndexOfFirstCharacterToBeForcedToOverflow(Integer.MAX_VALUE);
                        if (newChildLayoutResult.getStatus() == 1) {
                            lastAnalyzedTextLayoutResult = new TextLayoutResult(3, null, null, (IRenderer)lineRenderer.childRenderers.get(lastAnalyzedTextRenderer));
                            break;
                        }
                        lastAnalyzedTextLayoutResult = newChildLayoutResult;
                        lastAnalyzedTextRenderer = i;
                        break;
                    }
                    lastAnalyzedTextRenderer = i--;
                    continue;
                }
                lastAnalyzedTextLayoutResult = new TextLayoutResult(3, null, null, (IRenderer)lineRenderer.childRenderers.get(lastAnalyzedTextRenderer));
                break;
            }
            if (!LineRenderer.isChildFloating((IRenderer)lineRenderer.childRenderers.get(i)) && !(lineRenderer.childRenderers.get(i) instanceof ImageRenderer) && !LineRenderer.isInlineBlockChild((IRenderer)lineRenderer.childRenderers.get(i))) break;
            lastAnalyzedTextLayoutResult = new TextLayoutResult(3, null, null, (IRenderer)lineRenderer.childRenderers.get(lastAnalyzedTextRenderer));
            break;
        }
        if (lastAnalyzedTextLayoutResult == null) {
            boolean overflowWrapNotNormal;
            OverflowWrapPropertyValue overflowWrapValue = (OverflowWrapPropertyValue)((Object)((IRenderer)lineRenderer.childRenderers.get(childPos)).getProperty(102));
            boolean bl = overflowWrapNotNormal = overflowWrapValue == OverflowWrapPropertyValue.ANYWHERE || overflowWrapValue == OverflowWrapPropertyValue.BREAK_WORD;
            if (overflowWrapNotNormal && textSequenceLayoutResults.get(lastAnalyzedTextRenderer).getStatus() != 3 || isOverflowFit) {
                lastAnalyzedTextRenderer = childPos;
                lastAnalyzedTextLayoutResult = textSequenceLayoutResults.get(lastAnalyzedTextRenderer);
            } else {
                if (!floatsPlaced) {
                    return null;
                }
                lastAnalyzedTextLayoutResult = new TextLayoutResult(3, null, null, (IRenderer)lineRenderer.childRenderers.get(lastAnalyzedTextRenderer));
            }
        }
        if (lastAnalyzedTextLayoutResult != null) {
            return new LastFittingChildRendererData(lastAnalyzedTextRenderer, lastAnalyzedTextLayoutResult);
        }
        return null;
    }

    public static LastFittingChildRendererData getIndexAndLayoutResultOfTheLastTextRendererContainingSpecialScripts(LineRenderer lineRenderer, int childPos, Map<Integer, LayoutResult> specialScriptLayoutResults, boolean wasParentsHeightClipped, boolean isOverflowFit) {
        int indexOfRendererContainingLastFullyFittingWord = childPos;
        int splitPosition = 0;
        boolean needToSplitRendererContainingLastFullyFittingWord = false;
        int fittingLengthWithTrailingRightSideSpaces = 0;
        int amountOfTrailingRightSideSpaces = 0;
        LayoutResult childPosLayoutResult = specialScriptLayoutResults.get(childPos);
        LayoutResult returnLayoutResult = null;
        for (int analyzedTextRendererIndex = childPos; analyzedTextRendererIndex >= 0; --analyzedTextRendererIndex) {
            int possibleBreakPointPosition;
            List<Integer> breakPoints;
            TextRenderer textRenderer = (TextRenderer)lineRenderer.childRenderers.get(analyzedTextRendererIndex);
            if (analyzedTextRendererIndex != childPos) {
                fittingLengthWithTrailingRightSideSpaces = textRenderer.length();
            } else if (childPosLayoutResult.getSplitRenderer() != null) {
                TextRenderer splitTextRenderer = (TextRenderer)childPosLayoutResult.getSplitRenderer();
                GlyphLine splitText = splitTextRenderer.text;
                if (splitTextRenderer.length() > 0) {
                    fittingLengthWithTrailingRightSideSpaces = splitTextRenderer.length();
                    while (splitText.end + amountOfTrailingRightSideSpaces < splitText.size() && TextUtil.isWhitespace(splitText.get(splitText.end + amountOfTrailingRightSideSpaces))) {
                        ++fittingLengthWithTrailingRightSideSpaces;
                        ++amountOfTrailingRightSideSpaces;
                    }
                }
            }
            if (fittingLengthWithTrailingRightSideSpaces > 0 && (breakPoints = textRenderer.getSpecialScriptsWordBreakPoints()) != null && breakPoints.size() > 0 && breakPoints.get(0) != -1 && (possibleBreakPointPosition = TextRenderer.findPossibleBreaksSplitPosition(textRenderer.getSpecialScriptsWordBreakPoints(), fittingLengthWithTrailingRightSideSpaces + textRenderer.text.start, false)) > -1) {
                splitPosition = breakPoints.get(possibleBreakPointPosition) - amountOfTrailingRightSideSpaces;
                boolean bl = needToSplitRendererContainingLastFullyFittingWord = splitPosition != textRenderer.text.end;
                if (!needToSplitRendererContainingLastFullyFittingWord) {
                    ++analyzedTextRendererIndex;
                }
                indexOfRendererContainingLastFullyFittingWord = analyzedTextRendererIndex;
                break;
            }
            SpecialScriptsContainingSequenceStatus status = TextSequenceWordWrapping.getSpecialScriptsContainingSequenceStatus(lineRenderer, analyzedTextRendererIndex);
            if (status == SpecialScriptsContainingSequenceStatus.FORCED_SPLIT) {
                boolean overflowWrapNotNormal;
                OverflowWrapPropertyValue overflowWrapValue = (OverflowWrapPropertyValue)((Object)((IRenderer)lineRenderer.childRenderers.get(childPos)).getProperty(102));
                boolean bl = overflowWrapNotNormal = overflowWrapValue == OverflowWrapPropertyValue.ANYWHERE || overflowWrapValue == OverflowWrapPropertyValue.BREAK_WORD;
                if (overflowWrapNotNormal && childPosLayoutResult.getStatus() != 3 || isOverflowFit) {
                    if (childPosLayoutResult.getStatus() != 3) {
                        returnLayoutResult = childPosLayoutResult;
                    }
                    indexOfRendererContainingLastFullyFittingWord = childPos;
                    break;
                }
                return null;
            }
            if (status != SpecialScriptsContainingSequenceStatus.MOVE_SEQUENCE_CONTAINING_SPECIAL_SCRIPTS_ON_NEXT_LINE) continue;
            indexOfRendererContainingLastFullyFittingWord = analyzedTextRendererIndex;
            break;
        }
        if (returnLayoutResult == null) {
            returnLayoutResult = childPosLayoutResult;
            TextRenderer childRenderer = (TextRenderer)lineRenderer.childRenderers.get(indexOfRendererContainingLastFullyFittingWord);
            if (needToSplitRendererContainingLastFullyFittingWord) {
                int amountOfFitOnTheFirstLayout = fittingLengthWithTrailingRightSideSpaces - amountOfTrailingRightSideSpaces + childRenderer.text.start;
                if (amountOfFitOnTheFirstLayout != splitPosition) {
                    LayoutArea layoutArea = childRenderer.getOccupiedArea().clone();
                    layoutArea.getBBox().increaseHeight(1.0E-4f).increaseWidth(1.0E-4f);
                    childRenderer.setSpecialScriptFirstNotFittingIndex(splitPosition);
                    returnLayoutResult = childRenderer.layout(new LayoutContext(layoutArea, wasParentsHeightClipped));
                    childRenderer.setSpecialScriptFirstNotFittingIndex(-1);
                }
            } else {
                returnLayoutResult = new TextLayoutResult(3, null, null, childRenderer);
            }
        }
        return new LastFittingChildRendererData(indexOfRendererContainingLastFullyFittingWord, returnLayoutResult);
    }

    public static void preprocessTextSequenceOverflowX(LineRenderer lineRenderer, boolean textSequenceOverflowXProcessing, IRenderer childRenderer, boolean wasXOverflowChanged, OverflowPropertyValue oldXOverflow) {
        boolean specialScripts;
        boolean bl = specialScripts = childRenderer instanceof TextRenderer && ((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true);
        if (textSequenceOverflowXProcessing && specialScripts) {
            int firstPossibleBreakWithinTheRenderer = ((TextRenderer)childRenderer).getSpecialScriptsWordBreakPoints().get(0);
            if (firstPossibleBreakWithinTheRenderer != -1) {
                ((TextRenderer)childRenderer).setSpecialScriptFirstNotFittingIndex(firstPossibleBreakWithinTheRenderer);
            }
            if (wasXOverflowChanged) {
                lineRenderer.setProperty(103, (Object)oldXOverflow);
            }
        }
        if (textSequenceOverflowXProcessing && !specialScripts && wasXOverflowChanged) {
            lineRenderer.setProperty(103, (Object)oldXOverflow);
        }
    }

    public static boolean postprocessTextSequenceOverflowX(LineRenderer lineRenderer, boolean textSequenceOverflowXProcessing, int childPos, IRenderer childRenderer, LayoutResult childResult, boolean wasXOverflowChanged) {
        boolean lastElemOfTextSequence;
        boolean specialScripts = childRenderer instanceof TextRenderer && ((TextRenderer)childRenderer).textContainsSpecialScriptGlyphs(true);
        boolean shouldBreakLayouting = false;
        boolean bl = lastElemOfTextSequence = childPos + 1 == lineRenderer.childRenderers.size() || LineRenderer.isChildFloating((IRenderer)lineRenderer.childRenderers.get(childPos + 1)) || !(lineRenderer.childRenderers.get(childPos + 1) instanceof TextRenderer);
        if (textSequenceOverflowXProcessing && specialScripts) {
            if (((TextRenderer)childRenderer).getSpecialScriptFirstNotFittingIndex() > 0 || lastElemOfTextSequence) {
                shouldBreakLayouting = true;
            }
            ((TextRenderer)childRenderer).setSpecialScriptFirstNotFittingIndex(-1);
            if (wasXOverflowChanged) {
                lineRenderer.setProperty(103, (Object)OverflowPropertyValue.FIT);
            }
        }
        if (textSequenceOverflowXProcessing && !specialScripts) {
            if (childResult instanceof TextLayoutResult && ((TextLayoutResult)childResult).isContainsPossibleBreak() || lastElemOfTextSequence) {
                shouldBreakLayouting = true;
            }
            if (wasXOverflowChanged) {
                lineRenderer.setProperty(103, (Object)OverflowPropertyValue.FIT);
            }
        }
        return shouldBreakLayouting;
    }

    static SpecialScriptsContainingTextRendererSequenceInfo getSpecialScriptsContainingTextRendererSequenceInfo(LineRenderer lineRenderer, int childPos) {
        StringBuilder sequentialTextContentBuilder = new StringBuilder();
        int numberOfSequentialTextRenderers = 0;
        ArrayList<Integer> indicesOfFloating = new ArrayList<Integer>();
        for (int i = childPos; i < lineRenderer.childRenderers.size(); ++i) {
            if (LineRenderer.isChildFloating((IRenderer)lineRenderer.childRenderers.get(i))) {
                ++numberOfSequentialTextRenderers;
                indicesOfFloating.add(i);
                continue;
            }
            if (!(lineRenderer.childRenderers.get(i) instanceof TextRenderer) || !((TextRenderer)lineRenderer.childRenderers.get(i)).textContainsSpecialScriptGlyphs(false)) break;
            sequentialTextContentBuilder.append(((TextRenderer)lineRenderer.childRenderers.get((int)i)).text.toString());
            ++numberOfSequentialTextRenderers;
        }
        return new SpecialScriptsContainingTextRendererSequenceInfo(numberOfSequentialTextRenderers, sequentialTextContentBuilder.toString(), indicesOfFloating);
    }

    static void distributePossibleBreakPointsOverSequentialTextRenderers(LineRenderer lineRenderer, int childPos, int numberOfSequentialTextRenderers, List<Integer> possibleBreakPointsGlobal, List<Integer> indicesOfFloating) {
        int alreadyProcessedNumberOfCharsWithinGlyphLines = 0;
        int indexToBeginWith = 0;
        for (int i = 0; i < numberOfSequentialTextRenderers; ++i) {
            if (indicesOfFloating.contains(i)) continue;
            TextRenderer childTextRenderer = (TextRenderer)lineRenderer.childRenderers.get(childPos + i);
            ArrayList<Integer> amountOfCharsBetweenTextStartAndActualTextChunk = new ArrayList<Integer>();
            ArrayList<Integer> glyphLineBasedIndicesOfActualTextChunkEnds = new ArrayList<Integer>();
            TextSequenceWordWrapping.fillActualTextChunkRelatedLists(childTextRenderer.getText(), amountOfCharsBetweenTextStartAndActualTextChunk, glyphLineBasedIndicesOfActualTextChunkEnds);
            ArrayList<Integer> possibleBreakPoints = new ArrayList<Integer>();
            for (int j = indexToBeginWith; j < possibleBreakPointsGlobal.size(); ++j) {
                int amountOfCharsBetweenTextStartAndTextEnd;
                int shiftedBreakPoint = possibleBreakPointsGlobal.get(j) - alreadyProcessedNumberOfCharsWithinGlyphLines;
                if (shiftedBreakPoint > (amountOfCharsBetweenTextStartAndTextEnd = ((Integer)amountOfCharsBetweenTextStartAndActualTextChunk.get(amountOfCharsBetweenTextStartAndActualTextChunk.size() - 1)).intValue())) {
                    indexToBeginWith = j;
                    alreadyProcessedNumberOfCharsWithinGlyphLines += amountOfCharsBetweenTextStartAndTextEnd;
                    break;
                }
                possibleBreakPoints.add(shiftedBreakPoint);
            }
            List<Integer> glyphLineBasedPossibleBreakPoints = TextSequenceWordWrapping.convertPossibleBreakPointsToGlyphLineBased(possibleBreakPoints, amountOfCharsBetweenTextStartAndActualTextChunk, glyphLineBasedIndicesOfActualTextChunkEnds);
            childTextRenderer.setSpecialScriptsWordBreakPoints(glyphLineBasedPossibleBreakPoints);
        }
    }

    static SpecialScriptsContainingSequenceStatus getSpecialScriptsContainingSequenceStatus(LineRenderer lineRenderer, int analyzedTextRendererIndex) {
        boolean forcedSplit;
        boolean moveSequenceContainingSpecialScriptsOnNextLine = false;
        boolean moveToPreviousTextRendererContainingSpecialScripts = false;
        if (analyzedTextRendererIndex > 0) {
            IRenderer prevChildRenderer = (IRenderer)lineRenderer.childRenderers.get(analyzedTextRendererIndex - 1);
            if (prevChildRenderer instanceof TextRenderer && !LineRenderer.isChildFloating(prevChildRenderer)) {
                if (((TextRenderer)prevChildRenderer).textContainsSpecialScriptGlyphs(true)) {
                    moveToPreviousTextRendererContainingSpecialScripts = true;
                } else {
                    moveSequenceContainingSpecialScriptsOnNextLine = true;
                }
            } else if (LineRenderer.isChildFloating(prevChildRenderer) || prevChildRenderer instanceof ImageRenderer || LineRenderer.isInlineBlockChild(prevChildRenderer)) {
                moveSequenceContainingSpecialScriptsOnNextLine = true;
            }
        }
        boolean bl = forcedSplit = !moveToPreviousTextRendererContainingSpecialScripts && !moveSequenceContainingSpecialScriptsOnNextLine;
        if (moveSequenceContainingSpecialScriptsOnNextLine) {
            return SpecialScriptsContainingSequenceStatus.MOVE_SEQUENCE_CONTAINING_SPECIAL_SCRIPTS_ON_NEXT_LINE;
        }
        if (forcedSplit) {
            return SpecialScriptsContainingSequenceStatus.FORCED_SPLIT;
        }
        return SpecialScriptsContainingSequenceStatus.MOVE_TO_PREVIOUS_TEXT_RENDERER_CONTAINING_SPECIAL_SCRIPTS;
    }

    static float getCurWidthRelayoutedTextSequenceDecrement(int childPos, int newChildPos, Map<Integer, LayoutResult> textRendererLayoutResults) {
        float decrement = 0.0f;
        if (childPos != newChildPos) {
            for (int i = childPos - 1; i >= newChildPos; --i) {
                if (textRendererLayoutResults.get(i) == null) continue;
                decrement += textRendererLayoutResults.get(i).getOccupiedArea().getBBox().getWidth();
            }
        }
        return decrement;
    }

    private static void updateMinMaxWidthOfLineRendererAfterTextRendererSequenceProcessing(boolean noSoftWrap, int childPos, LayoutResult layoutResult, AbstractWidthHandler widthHandler, MinMaxWidthOfTextRendererSequenceHelper minMaxWidthOfTextRendererSequenceHelper, Map<Integer, LayoutResult> textRendererLayoutResults) {
        if (noSoftWrap) {
            return;
        }
        TextLayoutResult currLayoutResult = (TextLayoutResult)layoutResult;
        float leftMinWidthCurrRenderer = currLayoutResult.getLeftMinWidth();
        float generalMinWidthCurrRenderer = currLayoutResult.getMinMaxWidth().getMinWidth();
        float widthOfUnbreakableChunkSplitAcrossRenderers = leftMinWidthCurrRenderer;
        float minWidthOfTextRendererSequence = generalMinWidthCurrRenderer;
        for (int prevRendererIndex = childPos - 1; prevRendererIndex >= 0; --prevRendererIndex) {
            if (textRendererLayoutResults.get(prevRendererIndex) == null) continue;
            TextLayoutResult prevLayoutResult = (TextLayoutResult)textRendererLayoutResults.get(prevRendererIndex);
            float leftMinWidthPrevRenderer = prevLayoutResult.getLeftMinWidth();
            float generalMinWidthPrevRenderer = prevLayoutResult.getMinMaxWidth().getMinWidth();
            float rightMinWidthPrevRenderer = prevLayoutResult.getRightMinWidth();
            minWidthOfTextRendererSequence = Math.max(minWidthOfTextRendererSequence, generalMinWidthPrevRenderer);
            if (!prevLayoutResult.isEndsWithSplitCharacter() && !currLayoutResult.isStartsWithSplitCharacterWhiteSpace()) {
                widthOfUnbreakableChunkSplitAcrossRenderers = rightMinWidthPrevRenderer > -1.0f ? (widthOfUnbreakableChunkSplitAcrossRenderers += rightMinWidthPrevRenderer) : (widthOfUnbreakableChunkSplitAcrossRenderers += leftMinWidthPrevRenderer);
                minWidthOfTextRendererSequence = Math.max(minWidthOfTextRendererSequence, widthOfUnbreakableChunkSplitAcrossRenderers);
                if (rightMinWidthPrevRenderer > -1.0f) {
                    widthOfUnbreakableChunkSplitAcrossRenderers = leftMinWidthPrevRenderer;
                }
            } else {
                widthOfUnbreakableChunkSplitAcrossRenderers = leftMinWidthPrevRenderer;
            }
            currLayoutResult = prevLayoutResult;
        }
        if (!minMaxWidthOfTextRendererSequenceHelper.anythingPlacedBeforeTextRendererSequence) {
            minWidthOfTextRendererSequence = Math.max(minWidthOfTextRendererSequence, widthOfUnbreakableChunkSplitAcrossRenderers += minMaxWidthOfTextRendererSequenceHelper.textIndent);
        }
        float lineMinWidth = Math.max(minWidthOfTextRendererSequence, minMaxWidthOfTextRendererSequenceHelper.minWidthPreSequence);
        widthHandler.minMaxWidth.setChildrenMinWidth(lineMinWidth);
    }

    private static List<Integer> convertPossibleBreakPointsToGlyphLineBased(List<Integer> possibleBreakPoints, List<Integer> amountOfChars, List<Integer> indices) {
        if (possibleBreakPoints.isEmpty()) {
            possibleBreakPoints.add(-1);
            return possibleBreakPoints;
        }
        ArrayList<Integer> glyphLineBased = new ArrayList<Integer>();
        for (int j : possibleBreakPoints) {
            int found = TextRenderer.findPossibleBreaksSplitPosition(amountOfChars, j, true);
            if (found < 0) continue;
            glyphLineBased.add(indices.get(found));
        }
        return glyphLineBased;
    }

    private static void fillActualTextChunkRelatedLists(GlyphLine glyphLine, List<Integer> amountOfCharsBetweenTextStartAndActualTextChunk, List<Integer> glyphLineBasedIndicesOfActualTextChunkEnds) {
        ActualTextIterator actualTextIterator = new ActualTextIterator(glyphLine);
        int amountOfCharsBetweenTextStartAndCurrentActualTextStartOrGlyph = 0;
        while (actualTextIterator.hasNext()) {
            GlyphLine.GlyphLinePart part = actualTextIterator.next();
            int amountOfCharsWithinCurrentActualTextOrGlyph = 0;
            if (part.actualText != null) {
                amountOfCharsWithinCurrentActualTextOrGlyph = part.actualText.length();
                int nextAmountOfChars = amountOfCharsWithinCurrentActualTextOrGlyph + amountOfCharsBetweenTextStartAndCurrentActualTextStartOrGlyph;
                amountOfCharsBetweenTextStartAndActualTextChunk.add(nextAmountOfChars);
                glyphLineBasedIndicesOfActualTextChunkEnds.add(part.end);
                amountOfCharsBetweenTextStartAndCurrentActualTextStartOrGlyph = nextAmountOfChars;
                continue;
            }
            for (int j = part.start; j < part.end; ++j) {
                char[] chars = glyphLine.get(j).getChars();
                amountOfCharsWithinCurrentActualTextOrGlyph = chars != null ? chars.length : 0;
                int nextAmountOfChars = amountOfCharsWithinCurrentActualTextOrGlyph + amountOfCharsBetweenTextStartAndCurrentActualTextStartOrGlyph;
                amountOfCharsBetweenTextStartAndActualTextChunk.add(nextAmountOfChars);
                glyphLineBasedIndicesOfActualTextChunkEnds.add(j + 1);
                amountOfCharsBetweenTextStartAndCurrentActualTextStartOrGlyph = nextAmountOfChars;
            }
        }
    }

    static class SpecialScriptsContainingTextRendererSequenceInfo {
        public int numberOfSequentialTextRenderers;
        public String sequentialTextContent;
        List<Integer> indicesOfFloating;

        public SpecialScriptsContainingTextRendererSequenceInfo(int numberOfSequentialTextRenderers, String sequentialTextContent, List<Integer> indicesOfFloating) {
            this.numberOfSequentialTextRenderers = numberOfSequentialTextRenderers;
            this.sequentialTextContent = sequentialTextContent;
            this.indicesOfFloating = indicesOfFloating;
        }
    }

    static class LastFittingChildRendererData {
        public int childIndex;
        public LayoutResult childLayoutResult;

        public LastFittingChildRendererData(int childIndex, LayoutResult childLayoutResult) {
            this.childIndex = childIndex;
            this.childLayoutResult = childLayoutResult;
        }
    }

    static class MinMaxWidthOfTextRendererSequenceHelper {
        public float minWidthPreSequence;
        public float textIndent;
        public boolean anythingPlacedBeforeTextRendererSequence;

        public MinMaxWidthOfTextRendererSequenceHelper(float minWidthPreSequence, float textIndent, boolean anythingPlacedBeforeTextRendererSequence) {
            this.minWidthPreSequence = minWidthPreSequence;
            this.textIndent = textIndent;
            this.anythingPlacedBeforeTextRendererSequence = anythingPlacedBeforeTextRendererSequence;
        }
    }

    static enum SpecialScriptsContainingSequenceStatus {
        MOVE_SEQUENCE_CONTAINING_SPECIAL_SCRIPTS_ON_NEXT_LINE,
        MOVE_TO_PREVIOUS_TEXT_RENDERER_CONTAINING_SPECIAL_SCRIPTS,
        FORCED_SPLIT;

    }
}

