/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa;

import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.IConformanceLevel;
import com.itextpdf.kernel.pdf.IPdfPageFactory;
import com.itextpdf.kernel.pdf.IsoKey;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputIntent;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.utils.ValidationContainer;
import com.itextpdf.kernel.xmp.XMPException;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.XMPUtils;
import com.itextpdf.pdfa.PdfAPageFactory;
import com.itextpdf.pdfa.checker.PdfA1Checker;
import com.itextpdf.pdfa.checker.PdfA2Checker;
import com.itextpdf.pdfa.checker.PdfA3Checker;
import com.itextpdf.pdfa.checker.PdfA4Checker;
import com.itextpdf.pdfa.checker.PdfAChecker;
import com.itextpdf.pdfa.exceptions.PdfAConformanceException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfADocument
extends PdfDocument {
    private static IPdfPageFactory pdfAPageFactory = new PdfAPageFactory();
    protected PdfAChecker checker;
    private boolean alreadyLoggedThatObjectFlushingWasNotPerformed = false;
    private boolean alreadyLoggedThatPageFlushingWasNotPerformed = false;
    private boolean isPdfADocument = true;

    public PdfADocument(PdfWriter writer, PdfAConformanceLevel conformanceLevel, PdfOutputIntent outputIntent) {
        this(writer, conformanceLevel, outputIntent, new DocumentProperties());
    }

    public PdfADocument(PdfWriter writer, PdfAConformanceLevel conformanceLevel, PdfOutputIntent outputIntent, DocumentProperties properties) {
        super(writer, properties);
        this.setChecker(conformanceLevel);
        this.addOutputIntent(outputIntent);
    }

    @Override
    public PdfFont getDefaultFont() {
        if (this.isPdfADocument) {
            return null;
        }
        return super.getDefaultFont();
    }

    public PdfADocument(PdfReader reader, PdfWriter writer) {
        this(reader, writer, new StampingProperties());
    }

    public PdfADocument(PdfReader reader, PdfWriter writer, StampingProperties properties) {
        this(reader, writer, properties, false);
    }

    PdfADocument(PdfReader reader, PdfWriter writer, StampingProperties properties, boolean tolerant) {
        super(reader, writer, properties);
        PdfAConformanceLevel conformanceLevel = reader.getPdfAConformanceLevel();
        if (conformanceLevel == null) {
            if (tolerant) {
                this.isPdfADocument = false;
            } else {
                throw new PdfAConformanceException("Document to read from shall be a pdfa conformant file with valid xmp metadata");
            }
        }
        this.setChecker(conformanceLevel);
    }

    @Override
    public IConformanceLevel getConformanceLevel() {
        if (this.isPdfADocument) {
            return this.checker.getConformanceLevel();
        }
        return null;
    }

    @Override
    public void addOutputIntent(PdfOutputIntent outputIntent) {
        super.addOutputIntent(outputIntent);
        this.checker.setPdfAOutputIntentColorSpace((PdfDictionary)this.getCatalog().getPdfObject());
    }

    void logThatPdfAPageFlushingWasNotPerformed() {
        if (!this.alreadyLoggedThatPageFlushingWasNotPerformed) {
            this.alreadyLoggedThatPageFlushingWasNotPerformed = true;
            LoggerFactory.getLogger(PdfADocument.class).warn("Page flushing was not performed. Pages flushing in PDF/A mode works only with explicit calls to PdfPage#flush(boolean) with flushResourcesContentStreams argument set to true");
        }
    }

    @Override
    protected void addCustomMetadataExtensions(XMPMeta xmpMeta) {
        if (!this.isPdfADocument) {
            super.addCustomMetadataExtensions(xmpMeta);
            return;
        }
        if (this.isTagged()) {
            try {
                if (xmpMeta.getPropertyInteger("http://www.aiim.org/pdfua/ns/id/", "part") != null) {
                    XMPMeta taggedExtensionMeta = XMPMetaFactory.parseFromString("    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:namespaceURI>http://www.aiim.org/pdfua/ns/id/</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>pdfuaid</pdfaSchema:prefix>\n                <pdfaSchema:schema>PDF/UA identification schema</pdfaSchema:schema>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA version identifier</pdfaProperty:description>\n                      <pdfaProperty:name>part</pdfaProperty:name>\n                      <pdfaProperty:valueType>Integer</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA amendment identifier</pdfaProperty:description>\n                      <pdfaProperty:name>amd</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA corrigenda identifier</pdfaProperty:description>\n                      <pdfaProperty:name>corr</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>");
                    XMPUtils.appendProperties(taggedExtensionMeta, xmpMeta, true, false);
                }
            }
            catch (XMPException exc) {
                Logger logger = LoggerFactory.getLogger(PdfADocument.class);
                logger.error("Exception while updating XmpMetadata", exc);
            }
        }
    }

    @Override
    protected void updateXmpMetadata() {
        if (!this.isPdfADocument) {
            super.updateXmpMetadata();
            return;
        }
        try {
            XMPMeta xmpMeta = this.updateDefaultXmpMetadata();
            xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", this.checker.getConformanceLevel().getPart());
            if (this.checker.getConformanceLevel().getConformance() != null) {
                xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", this.checker.getConformanceLevel().getConformance());
            }
            if ("4".equals(this.checker.getConformanceLevel().getPart())) {
                xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "rev", "2020");
            }
            this.addCustomMetadataExtensions(xmpMeta);
            this.setXmpMetadata(xmpMeta);
        }
        catch (XMPException e) {
            Logger logger = LoggerFactory.getLogger(PdfADocument.class);
            logger.error("Exception while updating XmpMetadata", e);
        }
    }

    @Override
    protected void checkIsoConformance() {
        this.setCheckerIfChanged();
        super.checkIsoConformance();
    }

    @Override
    public void checkIsoConformance(Object obj, IsoKey key, PdfResources resources, PdfStream contentStream, Object extra) {
        this.setCheckerIfChanged();
        super.checkIsoConformance(obj, key, resources, contentStream, extra);
    }

    @Override
    protected void flushObject(PdfObject pdfObject, boolean canBeInObjStm) throws IOException {
        if (!this.isPdfADocument) {
            super.flushObject(pdfObject, canBeInObjStm);
            return;
        }
        this.markObjectAsMustBeFlushed(pdfObject);
        if (this.isClosing || this.checker.objectIsChecked(pdfObject)) {
            super.flushObject(pdfObject, canBeInObjStm);
        } else if (!this.alreadyLoggedThatObjectFlushingWasNotPerformed) {
            this.alreadyLoggedThatObjectFlushingWasNotPerformed = true;
            LoggerFactory.getLogger(PdfADocument.class).warn("Object flushing was not performed. Object in PDF/A mode can only be flushed if the document is closed or if this object has already been checked for compliance with PDF/A rules.");
        }
    }

    protected void setChecker(PdfAConformanceLevel conformanceLevel) {
        if (!this.isPdfADocument) {
            return;
        }
        this.setChecker(PdfADocument.getCorrectCheckerFromConformance(conformanceLevel));
    }

    protected void setChecker(PdfAChecker checker) {
        if (!this.isPdfADocument) {
            return;
        }
        this.checker = checker;
        ValidationContainer validationContainer = new ValidationContainer();
        validationContainer.addChecker(checker);
        this.getDiContainer().register(ValidationContainer.class, validationContainer);
    }

    private void setCheckerIfChanged() {
        if (!this.isPdfADocument) {
            return;
        }
        if (!this.getDiContainer().isRegistered(ValidationContainer.class)) {
            return;
        }
        ValidationContainer validationContainer = this.getDiContainer().getInstance(ValidationContainer.class);
        if (validationContainer != null && !validationContainer.containsChecker(this.checker)) {
            this.setChecker(this.checker);
        }
    }

    private static PdfAChecker getCorrectCheckerFromConformance(PdfAConformanceLevel conformanceLevel) {
        PdfA1Checker checker;
        switch (conformanceLevel.getPart()) {
            case "1": {
                checker = new PdfA1Checker(conformanceLevel);
                break;
            }
            case "2": {
                checker = new PdfA2Checker(conformanceLevel);
                break;
            }
            case "3": {
                checker = new PdfA3Checker(conformanceLevel);
                break;
            }
            case "4": {
                checker = new PdfA4Checker(conformanceLevel);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't find an appropriate checker for a specified name.");
            }
        }
        return checker;
    }

    @Override
    protected void initTagStructureContext() {
        if (this.isPdfADocument) {
            this.tagStructureContext = new TagStructureContext(this, PdfADocument.getPdfVersionForPdfA(this.checker.getConformanceLevel()));
        } else {
            super.initTagStructureContext();
        }
    }

    @Override
    protected IPdfPageFactory getPageFactory() {
        if (this.isPdfADocument) {
            return pdfAPageFactory;
        }
        return super.getPageFactory();
    }

    @Override
    protected void flushInfoDictionary(boolean appendMode) {
        if (!this.isPdfADocument || !"4".equals(this.checker.getConformanceLevel().getPart())) {
            super.flushInfoDictionary(appendMode);
        } else if (((PdfDictionary)this.getCatalog().getPdfObject()).get(PdfName.PieceInfo) != null) {
            this.getDocumentInfo().removeCreationDate();
            super.flushInfoDictionary(appendMode);
        }
    }

    boolean isClosing() {
        return this.isClosing;
    }

    private static PdfVersion getPdfVersionForPdfA(PdfAConformanceLevel conformanceLevel) {
        PdfVersion version;
        switch (conformanceLevel.getPart()) {
            case "1": {
                version = PdfVersion.PDF_1_4;
                break;
            }
            case "2": {
                version = PdfVersion.PDF_1_7;
                break;
            }
            case "3": {
                version = PdfVersion.PDF_1_7;
                break;
            }
            case "4": {
                version = PdfVersion.PDF_2_0;
                break;
            }
            default: {
                version = PdfVersion.PDF_1_4;
            }
        }
        return version;
    }
}

