/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.PatternColor;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.font.PdfType3Font;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfCatalog;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfXrefTable;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.canvas.parser.util.PdfCanvasParser;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.pdfa.checker.PdfAChecker;
import com.itextpdf.pdfa.exceptions.PdfAConformanceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfA1Checker
extends PdfAChecker {
    protected static final Set<PdfName> forbiddenAnnotations = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Sound, PdfName.Movie, PdfName.FileAttachment)));
    protected static final Set<PdfName> contentAnnotations = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Text, PdfName.FreeText, PdfName.Line, PdfName.Square, PdfName.Circle, PdfName.Stamp, PdfName.Ink, PdfName.Popup)));
    protected static final Set<PdfName> forbiddenActions = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Launch, PdfName.Sound, PdfName.Movie, PdfName.ResetForm, PdfName.ImportData, PdfName.JavaScript, PdfName.Hide)));
    protected static final Set<PdfName> allowedNamedActions = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.NextPage, PdfName.PrevPage, PdfName.FirstPage, PdfName.LastPage)));
    protected static final Set<PdfName> allowedRenderingIntents = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.RelativeColorimetric, PdfName.AbsoluteColorimetric, PdfName.Perceptual, PdfName.Saturation)));
    private static final int MAX_NUMBER_OF_DEVICEN_COLOR_COMPONENTS = 8;
    private static final Logger logger = LoggerFactory.getLogger(PdfAChecker.class);

    public PdfA1Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    public void checkCanvasStack(char stackOperation) {
        if ('q' == stackOperation) {
            if (++this.gsStackDepth > 28) {
                throw new PdfAConformanceException("Graphics state stack depth is greater than 28");
            }
        } else if ('Q' == stackOperation) {
            --this.gsStackDepth;
        }
    }

    @Override
    public void checkInlineImage(PdfStream inlineImage, PdfDictionary currentColorSpaces) {
        PdfObject filter = inlineImage.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("LZWDecode filter is not permitted");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (!f.equals(PdfName.LZWDecode)) continue;
                throw new PdfAConformanceException("LZWDecode filter is not permitted");
            }
        }
        this.checkImage(inlineImage, currentColorSpaces);
    }

    @Override
    @Deprecated
    public void checkColor(Color color, PdfDictionary currentColorSpaces, Boolean fill, PdfStream stream) {
        this.checkColor(null, color, currentColorSpaces, fill, stream);
    }

    @Override
    public void checkColor(CanvasGraphicsState graphicsState, Color color, PdfDictionary currentColorSpaces, Boolean fill, PdfStream stream) {
        PdfPattern pattern;
        this.checkColorSpace(color.getColorSpace(), stream, currentColorSpaces, true, fill);
        if (color instanceof PatternColor && (pattern = ((PatternColor)color).getPattern()) instanceof PdfPattern.Tiling) {
            this.checkContentStream((PdfStream)pattern.getPdfObject());
        }
    }

    @Override
    public void checkColorSpace(PdfColorSpace colorSpace, PdfObject pdfObject, PdfDictionary currentColorSpaces, boolean checkAlternate, Boolean fill) {
        if (colorSpace instanceof PdfSpecialCs.Separation) {
            colorSpace = ((PdfSpecialCs.Separation)colorSpace).getBaseCs();
        } else if (colorSpace instanceof PdfSpecialCs.DeviceN) {
            PdfSpecialCs.DeviceN deviceNColorspace = (PdfSpecialCs.DeviceN)colorSpace;
            if (deviceNColorspace.getNumberOfComponents() > 8) {
                throw new PdfAConformanceException("The number of color components in DeviceN colorspace should not exceed {0}", 8);
            }
            colorSpace = deviceNColorspace.getBaseCs();
        }
        if (colorSpace instanceof PdfDeviceCs.Rgb) {
            if (this.cmykIsUsed || !this.cmykUsedObjects.isEmpty()) {
                throw new PdfAConformanceException("Devicergb and devicecmyk colorspaces cannot be used both in one file");
            }
            this.rgbUsedObjects.add(pdfObject);
        } else if (colorSpace instanceof PdfDeviceCs.Cmyk) {
            if (this.rgbIsUsed || !this.rgbUsedObjects.isEmpty()) {
                throw new PdfAConformanceException("Devicergb and devicecmyk colorspaces cannot be used both in one file");
            }
            this.cmykUsedObjects.add(pdfObject);
        } else if (colorSpace instanceof PdfDeviceCs.Gray) {
            this.grayUsedObjects.add(pdfObject);
        }
    }

    @Override
    public void checkXrefTable(PdfXrefTable xrefTable) {
        if ((long)xrefTable.getCountOfIndirectObjects() > this.getMaxNumberOfIndirectObjects()) {
            throw new PdfAConformanceException("Maximum number of indirect objects exceeded");
        }
    }

    @Override
    protected Set<PdfName> getForbiddenActions() {
        return forbiddenActions;
    }

    @Override
    protected Set<PdfName> getAllowedNamedActions() {
        return allowedNamedActions;
    }

    @Override
    protected long getMaxNumberOfIndirectObjects() {
        return 0x7FFFFFL;
    }

    @Override
    protected void checkColorsUsages() {
    }

    @Override
    protected void checkPageColorsUsages(PdfDictionary pageDict, PdfDictionary pageResources) {
        if ((this.rgbIsUsed || this.cmykIsUsed || this.grayIsUsed || !this.rgbUsedObjects.isEmpty() || !this.cmykUsedObjects.isEmpty() || this.grayUsedObjects.isEmpty()) && this.pdfAOutputIntentColorSpace == null) {
            throw new PdfAConformanceException("If device rgb cmyk gray used in file, that file shall contain pdfa outputintent");
        }
        if (!(!this.rgbIsUsed && this.rgbUsedObjects.isEmpty() || "RGB ".equals(this.pdfAOutputIntentColorSpace))) {
            throw new PdfAConformanceException("Devicergb may be used only if the file has a rgb pdfa outputIntent");
        }
        if (!(!this.cmykIsUsed && this.cmykUsedObjects.isEmpty() || "CMYK".equals(this.pdfAOutputIntentColorSpace))) {
            throw new PdfAConformanceException("Devicecmyk may be used only if the file has a cmyk pdfa outputIntent");
        }
    }

    @Override
    public void checkExtGState(CanvasGraphicsState extGState, PdfStream contentStream) {
        if (extGState.getTransferFunction() != null) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the tr key");
        }
        PdfObject transferFunction2 = extGState.getTransferFunction2();
        if (transferFunction2 != null && !PdfName.Default.equals(transferFunction2)) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the TR2 key with a value other than default");
        }
        this.checkRenderingIntent(extGState.getRenderingIntent());
        PdfObject softMask = extGState.getSoftMask();
        if (softMask != null && !PdfName.None.equals(softMask)) {
            throw new PdfAConformanceException("The smask key is not allowed in extgstate");
        }
        PdfObject bm = extGState.getBlendMode();
        if (bm != null && !PdfName.Normal.equals(bm) && !PdfName.Compatible.equals(bm)) {
            throw new PdfAConformanceException("Blend mode shall have value normal or compatible");
        }
        Float ca = Float.valueOf(extGState.getStrokeOpacity());
        if (ca != null && ca.floatValue() != 1.0f) {
            throw new PdfAConformanceException("Transparency is not allowed. CA shall be equal to 1");
        }
        ca = Float.valueOf(extGState.getFillOpacity());
        if (ca != null && ca.floatValue() != 1.0f) {
            throw new PdfAConformanceException("Transparency is not allowed. ca shall be equal to 1");
        }
    }

    @Override
    public void checkFontGlyphs(PdfFont font, PdfStream contentStream) {
    }

    @Override
    public void checkRenderingIntent(PdfName intent) {
        if (intent == null) {
            return;
        }
        if (!allowedRenderingIntents.contains(intent)) {
            throw new PdfAConformanceException("If specified rendering shall be one of the following relativecolorimetric absolutecolorimetric perceptual or saturation");
        }
    }

    @Override
    public void checkFont(PdfFont pdfFont) {
        if (!pdfFont.isEmbedded()) {
            throw new PdfAConformanceException("All the fonts must be embedded. This one is not: {0}").setMessageParams(pdfFont.getFontProgram().getFontNames().getFontName());
        }
        if (pdfFont instanceof PdfTrueTypeFont) {
            PdfTrueTypeFont trueTypeFont = (PdfTrueTypeFont)pdfFont;
            boolean symbolic = trueTypeFont.getFontEncoding().isFontSpecific();
            if (symbolic) {
                this.checkSymbolicTrueTypeFont(trueTypeFont);
            } else {
                this.checkNonSymbolicTrueTypeFont(trueTypeFont);
            }
        }
        if (pdfFont instanceof PdfType3Font) {
            PdfDictionary charProcs = ((PdfDictionary)pdfFont.getPdfObject()).getAsDictionary(PdfName.CharProcs);
            for (PdfName charName : charProcs.keySet()) {
                this.checkContentStream(charProcs.getAsStream(charName));
            }
        }
    }

    @Override
    public void checkCrypto(PdfObject crypto) {
        if (crypto != null) {
            throw new PdfAConformanceException("Keyword encrypt shall not be used in the trailer dictionary");
        }
    }

    @Override
    public void checkSignatureType(boolean isCAdES) {
    }

    @Override
    public void checkText(String text, PdfFont font) {
        for (int i = 0; i < text.length(); ++i) {
            int ch;
            if (TextUtil.isSurrogatePair(text, i)) {
                ch = TextUtil.convertToUtf32(text, i);
                ++i;
            } else {
                ch = text.charAt(i);
            }
            if (font.containsGlyph(ch)) continue;
            throw new PdfAConformanceException("Embedded fonts shall define all glyphs referenced for rendering within the conforming file.");
        }
    }

    @Override
    protected void checkPageTransparency(PdfDictionary pageDict, PdfDictionary pageResources) {
    }

    @Override
    protected void checkContentStream(PdfStream contentStream) {
        if (this.isFullCheckMode() || contentStream.isModified()) {
            byte[] contentBytes = contentStream.getBytes();
            PdfTokenizer tokenizer = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(contentBytes)));
            PdfCanvasParser parser = new PdfCanvasParser(tokenizer);
            ArrayList<PdfObject> operands = new ArrayList<PdfObject>();
            try {
                while (parser.parse(operands).size() > 0) {
                    for (PdfObject operand : operands) {
                        this.checkContentStreamObject(operand);
                    }
                }
            }
            catch (IOException e) {
                throw new PdfException("Cannot parse content stream.", e);
            }
        }
    }

    @Override
    protected void checkNonSymbolicTrueTypeFont(PdfTrueTypeFont trueTypeFont) {
        String encoding = trueTypeFont.getFontEncoding().getBaseEncoding();
        if (!"Cp1252".equals(encoding) && !"MacRoman".equals(encoding) || trueTypeFont.getFontEncoding().hasDifferences()) {
            throw new PdfAConformanceException("All non-symbolic TrueType fonts shall specify MacRomanEncoding or WinAnsiEncoding as the value of the Encoding entry in the font dictionary  This also means that Encoding entry in the font dictionary shall not be an encoding dictionary ", trueTypeFont);
        }
    }

    @Override
    protected void checkSymbolicTrueTypeFont(PdfTrueTypeFont trueTypeFont) {
        if (trueTypeFont.getFontEncoding().hasDifferences()) {
            throw new PdfAConformanceException("All symbolic TrueType fonts shall not specify an Encoding entry in the font dictionary ");
        }
    }

    @Override
    protected void checkImage(PdfStream image, PdfDictionary currentColorSpaces) {
        PdfColorSpace colorSpace = null;
        if (this.isAlreadyChecked(image)) {
            colorSpace = (PdfColorSpace)this.checkedObjectsColorspace.get(image);
            this.checkColorSpace(colorSpace, image, currentColorSpaces, true, null);
            return;
        }
        PdfObject colorSpaceObj = image.get(PdfName.ColorSpace);
        if (colorSpaceObj != null) {
            colorSpace = PdfColorSpace.makeColorSpace(colorSpaceObj);
            this.checkColorSpace(colorSpace, image, currentColorSpaces, true, null);
            this.checkedObjectsColorspace.put(image, colorSpace);
        }
        if (image.containsKey(PdfName.Alternates)) {
            throw new PdfAConformanceException("An image dictionary shall not contain alternates key");
        }
        if (image.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("An image dictionary shall not contain opi key");
        }
        if (image.containsKey(PdfName.Interpolate) && image.getAsBool(PdfName.Interpolate).booleanValue()) {
            throw new PdfAConformanceException("The value of interpolate key shall not be true");
        }
        this.checkRenderingIntent(image.getAsName(PdfName.Intent));
        if (image.containsKey(PdfName.SMask) && !PdfName.None.equals(image.getAsName(PdfName.SMask))) {
            throw new PdfAConformanceException("The smask key is not allowed in xobjects");
        }
    }

    @Override
    protected void checkFormXObject(PdfStream form) {
        if (this.isAlreadyChecked(form)) {
            return;
        }
        if (form.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain opi key");
        }
        if (form.containsKey(PdfName.PS)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain PS key");
        }
        if (PdfName.PS.equals(form.getAsName(PdfName.Subtype2))) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain subtype2 key with a value of PS");
        }
        if (form.containsKey(PdfName.SMask) && !PdfName.None.equals(form.getAsName(PdfName.SMask))) {
            throw new PdfAConformanceException("The smask key is not allowed in xobjects");
        }
        if (PdfA1Checker.isContainsTransparencyGroup(form)) {
            throw new PdfAConformanceException("A group object with an s key with a value of transparency shall not be included in a form xobject");
        }
        this.checkResources(form.getAsDictionary(PdfName.Resources), form);
        this.checkContentStream(form);
    }

    @Override
    protected void checkLogicalStructure(PdfDictionary catalog) {
        if (PdfA1Checker.checkStructure(this.conformanceLevel)) {
            PdfDictionary markInfo = catalog.getAsDictionary(PdfName.MarkInfo);
            if (markInfo == null || markInfo.getAsBoolean(PdfName.Marked) == null || !markInfo.getAsBoolean(PdfName.Marked).getValue()) {
                throw new PdfAConformanceException("A catalog dictionary shall include a markinfo dictionary whose entry marked shall have a value of true");
            }
            if (!catalog.containsKey(PdfName.Lang)) {
                logger.warn("Catalog dictionary should contain lang entry");
            }
        }
    }

    @Override
    protected void checkMetaData(PdfDictionary catalog) {
        if (!catalog.containsKey(PdfName.Metadata)) {
            throw new PdfAConformanceException("A catalog dictionary shall contain metadata entry");
        }
    }

    @Override
    protected void checkOutputIntents(PdfDictionary catalog) {
        int i;
        PdfArray outputIntents = catalog.getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            return;
        }
        PdfObject destOutputProfile = null;
        for (i = 0; i < outputIntents.size() && destOutputProfile == null; ++i) {
            destOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
        }
        while (i < outputIntents.size()) {
            PdfObject otherDestOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
            if (otherDestOutputProfile != null && destOutputProfile != otherDestOutputProfile) {
                throw new PdfAConformanceException("If outputintents array has more than one entry with destoutputprofile key the same indirect object shall be used as the value of that object");
            }
            ++i;
        }
    }

    @Override
    protected void checkPdfNumber(PdfNumber number) {
        if (number.hasDecimalPoint()) {
            if ((double)Math.abs(number.longValue()) > this.getMaxRealValue()) {
                throw new PdfAConformanceException("Real number is out of range");
            }
        } else if (number.longValue() > this.getMaxIntegerValue() || number.longValue() < this.getMinIntegerValue()) {
            throw new PdfAConformanceException("Integer number is out of range");
        }
    }

    protected double getMaxRealValue() {
        return 32767.0;
    }

    protected long getMaxIntegerValue() {
        return Integer.MAX_VALUE;
    }

    protected long getMinIntegerValue() {
        return Integer.MIN_VALUE;
    }

    @Override
    protected void checkPdfArray(PdfArray array) {
        if (array.size() > this.getMaxArrayCapacity()) {
            throw new PdfAConformanceException("Maximum array capacity is exceeded");
        }
    }

    @Override
    protected void checkPdfDictionary(PdfDictionary dictionary) {
        if (dictionary.size() > this.getMaxDictionaryCapacity()) {
            throw new PdfAConformanceException("Maximum dictionary capacity is exceeded");
        }
    }

    @Override
    protected void checkPdfStream(PdfStream stream) {
        this.checkPdfDictionary(stream);
        if (stream.containsKey(PdfName.F) || stream.containsKey(PdfName.FFilter) || stream.containsKey(PdfName.FDecodeParams)) {
            throw new PdfAConformanceException("Stream object dictionary shall not contain the f ffilter or fdecodeparams keys");
        }
        PdfObject filter = stream.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("LZWDecode filter is not permitted");
            }
        } else if (filter instanceof PdfArray) {
            for (PdfObject f : (PdfArray)filter) {
                if (!f.equals(PdfName.LZWDecode)) continue;
                throw new PdfAConformanceException("LZWDecode filter is not permitted");
            }
        }
    }

    @Override
    protected void checkPdfName(PdfName name) {
        if (name.getValue().length() > this.getMaxNameLength()) {
            throw new PdfAConformanceException("PdfName is too long");
        }
    }

    protected int getMaxNameLength() {
        return 127;
    }

    @Override
    protected void checkPdfString(PdfString string) {
        if (string.getValueBytes().length > this.getMaxStringLength()) {
            throw new PdfAConformanceException("PdfString is too long");
        }
    }

    protected int getMaxStringLength() {
        return 65535;
    }

    @Override
    protected void checkPageSize(PdfDictionary page) {
    }

    @Override
    protected void checkFileSpec(PdfDictionary fileSpec) {
        if (fileSpec.containsKey(PdfName.EF)) {
            throw new PdfAConformanceException("File specification dictionary shall not contain the EF key");
        }
    }

    @Override
    protected void checkAnnotation(PdfDictionary annotDic) {
        PdfName subtype = annotDic.getAsName(PdfName.Subtype);
        if (subtype == null) {
            throw new PdfAConformanceException("Annotation type {0} is not permitted").setMessageParams("null");
        }
        if (this.getForbiddenAnnotations().contains(subtype)) {
            throw new PdfAConformanceException("Annotation type {0} is not permitted").setMessageParams(subtype.getValue());
        }
        PdfNumber ca = annotDic.getAsNumber(PdfName.CA);
        if (ca != null && (double)ca.floatValue() != 1.0) {
            throw new PdfAConformanceException("An annotation dictionary shall not contain the ca key with a value other than 1");
        }
        if (!annotDic.containsKey(PdfName.F)) {
            throw new PdfAConformanceException("An annotation dictionary shall contain the f key");
        }
        int flags = annotDic.getAsInt(PdfName.F);
        if (!PdfA1Checker.checkFlag(flags, 4) || PdfA1Checker.checkFlag(flags, 2) || PdfA1Checker.checkFlag(flags, 1) || PdfA1Checker.checkFlag(flags, 32)) {
            throw new PdfAConformanceException("The f keys print flag bit shall be set to 1 and its hidden invisible and noview flag bits shall be set to 0");
        }
        if (!(!subtype.equals(PdfName.Text) || PdfA1Checker.checkFlag(flags, 8) && PdfA1Checker.checkFlag(flags, 16))) {
            throw new PdfAConformanceException("Text annotations should set the nozoom and norotate flag bits of the f key to 1");
        }
        if ((annotDic.containsKey(PdfName.C) || annotDic.containsKey(PdfName.IC)) && !"RGB ".equals(this.pdfAOutputIntentColorSpace)) {
            throw new PdfAConformanceException("Destoutputprofile in the pdfa1 outputintent dictionary shall be rgb");
        }
        PdfDictionary ap = annotDic.getAsDictionary(PdfName.AP);
        if (ap != null) {
            if (ap.containsKey(PdfName.D) || ap.containsKey(PdfName.R)) {
                throw new PdfAConformanceException("Appearance dictionary shall contain only the n key with stream value");
            }
            if (PdfName.Widget.equals(annotDic.getAsName(PdfName.Subtype)) && PdfName.Btn.equals(PdfFormField.getFormType(annotDic))) {
                if (ap.getAsDictionary(PdfName.N) == null) {
                    throw new PdfAConformanceException("If an annotation dictionary's Subtype key has a value of Widget and its FT key has a value of Btn, the value of the N key shall be an appearance subdictionary");
                }
            } else if (ap.getAsStream(PdfName.N) == null) {
                throw new PdfAConformanceException("Appearance dictionary shall contain only the n key with stream value");
            }
            this.checkResourcesOfAppearanceStreams(ap);
        }
        if (PdfName.Widget.equals(subtype) && (annotDic.containsKey(PdfName.AA) || annotDic.containsKey(PdfName.A))) {
            throw new PdfAConformanceException("Widget annotation dictionary or field dictionary shall not include a or aa entry");
        }
        if (annotDic.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("An annotation dictionary shall not contain aa key");
        }
        if (PdfA1Checker.checkStructure(this.conformanceLevel) && contentAnnotations.contains(subtype) && !annotDic.containsKey(PdfName.Contents)) {
            logger.warn(MessageFormatUtil.format("Annotation of type {0} should have contents key", subtype.getValue()));
        }
    }

    protected Set<PdfName> getForbiddenAnnotations() {
        return forbiddenAnnotations;
    }

    @Override
    protected void checkForm(PdfDictionary form) {
        if (form == null) {
            return;
        }
        PdfBoolean needAppearances = form.getAsBoolean(PdfName.NeedAppearances);
        if (needAppearances != null && needAppearances.getValue()) {
            throw new PdfAConformanceException("Needappearances flag of the interactive form dictionary shall either not be presented or shall be false");
        }
        this.checkResources(form.getAsDictionary(PdfName.DR), form);
        PdfArray fields = form.getAsArray(PdfName.Fields);
        if (fields != null) {
            fields = this.getFormFields(fields);
            for (PdfObject field : fields) {
                PdfDictionary fieldDic = (PdfDictionary)field;
                if (fieldDic.containsKey(PdfName.A) || fieldDic.containsKey(PdfName.AA)) {
                    throw new PdfAConformanceException("Widget annotation dictionary or field dictionary shall not include a or aa entry");
                }
                this.checkResources(fieldDic.getAsDictionary(PdfName.DR), fieldDic);
            }
        }
    }

    @Override
    protected void checkAction(PdfDictionary action) {
        PdfName n;
        if (this.isAlreadyChecked(action)) {
            return;
        }
        PdfName s = action.getAsName(PdfName.S);
        if (this.getForbiddenActions().contains(s)) {
            throw new PdfAConformanceException("{0} actions are not allowed").setMessageParams(s.getValue());
        }
        if (s.equals(PdfName.Named) && (n = action.getAsName(PdfName.N)) != null && !this.getAllowedNamedActions().contains(n)) {
            throw new PdfAConformanceException("Named action type {0} not allowed").setMessageParams(n.getValue());
        }
        if (s.equals(PdfName.SetState) || s.equals(PdfName.NoOp)) {
            throw new PdfAConformanceException("Deprecated setstate and noop actions are not allowed");
        }
    }

    @Override
    protected void checkCatalog(PdfCatalog catalog) {
        String pdfVersion = catalog.getDocument().getPdfVersion().toString();
        if ('1' != pdfVersion.charAt(4) || '1' > pdfVersion.charAt(6) || '7' < pdfVersion.charAt(6)) {
            throw new PdfAConformanceException(MessageFormatUtil.format("The file header shall begin at byte zero and shall consist of \u201c%PDF-{0}.n\u201d", "1"));
        }
    }

    @Override
    protected void checkCatalogValidEntries(PdfDictionary catalogDict) {
        if (catalogDict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("A catalog dictionary shall not contain aa entry");
        }
        if (catalogDict.containsKey(PdfName.OCProperties)) {
            throw new PdfAConformanceException("A catalog dictionary shall not contain the ocproperties key");
        }
        if (catalogDict.containsKey(PdfName.Names) && catalogDict.getAsDictionary(PdfName.Names).containsKey(PdfName.EmbeddedFiles)) {
            throw new PdfAConformanceException("A name dictionary shall not contain the EmbeddedFiles key");
        }
    }

    @Override
    protected void checkPageObject(PdfDictionary pageDict, PdfDictionary pageResources) {
        PdfDictionary actions = pageDict.getAsDictionary(PdfName.AA);
        if (actions != null) {
            for (PdfName key : actions.keySet()) {
                PdfDictionary action = actions.getAsDictionary(key);
                this.checkAction(action);
            }
        }
        if (PdfA1Checker.isContainsTransparencyGroup(pageDict)) {
            throw new PdfAConformanceException("A group object with an s key with a value of transparency shall not be included in a page xobject");
        }
    }

    @Override
    protected void checkTrailer(PdfDictionary trailer) {
    }

    protected PdfArray getFormFields(PdfArray array) {
        PdfArray fields = new PdfArray();
        for (PdfObject field : array) {
            PdfArray kids = ((PdfDictionary)field).getAsArray(PdfName.Kids);
            fields.add(field);
            if (kids == null) continue;
            fields.addAll(this.getFormFields(kids));
        }
        return fields;
    }

    private int getMaxArrayCapacity() {
        return 8191;
    }

    private int getMaxDictionaryCapacity() {
        return 4095;
    }
}

