/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfa.checker;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.io.colors.IccProfile;
import com.itextpdf.io.font.FontEncoding;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.image.Jpeg2000ImageData;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.PatternColor;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfTrueTypeFont;
import com.itextpdf.kernel.font.PdfType3Font;
import com.itextpdf.kernel.font.Type3Glyph;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfAConformanceLevel;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.colorspace.PdfCieBasedCs;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import com.itextpdf.kernel.pdf.colorspace.PdfPattern;
import com.itextpdf.kernel.pdf.colorspace.PdfSpecialCs;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.pdfa.checker.PdfA1Checker;
import com.itextpdf.pdfa.checker.PdfAChecker;
import com.itextpdf.pdfa.exceptions.PdfAConformanceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfA2Checker
extends PdfA1Checker {
    protected static final Set<PdfName> forbiddenAnnotations = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName._3D, PdfName.Sound, PdfName.Screen, PdfName.Movie)));
    protected static final Set<PdfName> apLessAnnotations = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Popup, PdfName.Link)));
    protected static final Set<PdfName> forbiddenActions = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Launch, PdfName.Sound, PdfName.Movie, PdfName.ResetForm, PdfName.ImportData, PdfName.JavaScript, PdfName.Hide, PdfName.SetOCGState, PdfName.Rendition, PdfName.Trans, PdfName.GoTo3DView)));
    protected static final Set<PdfName> allowedBlendModes = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.Normal, PdfName.Compatible, PdfName.Multiply, PdfName.Screen, PdfName.Overlay, PdfName.Darken, PdfName.Lighten, PdfName.ColorDodge, PdfName.ColorBurn, PdfName.HardLight, PdfName.SoftLight, PdfName.Difference, PdfName.Exclusion, PdfName.Hue, PdfName.Saturation, PdfName.Color, PdfName.Luminosity)));
    protected static final Set<PdfName> allowedFilters = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.ASCIIHexDecode, PdfName.ASCII85Decode, PdfName.RunLengthDecode, PdfName.FlateDecode, PdfName.CCITTFaxDecode, PdfName.JBIG2Decode, PdfName.DCTDecode, PdfName.JPXDecode, PdfName.Crypt)));
    protected static final Set<PdfName> allowedInlineImageFilters = Collections.unmodifiableSet(new HashSet<PdfName>(Arrays.asList(PdfName.DeviceGray, PdfName.DeviceRGB, PdfName.DeviceCMYK, PdfName.Indexed, PdfName.ASCIIHexDecode, PdfName.ASCII85Decode, PdfName.FlateDecode, PdfName.RunLengthDecode, PdfName.CCITTFaxDecode, PdfName.DCTDecode, PdfName.G, PdfName.RGB, PdfName.CMYK, PdfName.I, PdfName.AHx, PdfName.A85, PdfName.Fl, PdfName.RL, PdfName.CCF, PdfName.DCT)));
    protected Set<PdfObject> transparencyObjects = new HashSet<PdfObject>();
    static final int MAX_PAGE_SIZE = 14400;
    static final int MIN_PAGE_SIZE = 3;
    private static final int MAX_NUMBER_OF_DEVICEN_COLOR_COMPONENTS = 32;
    private static final Logger logger = LoggerFactory.getLogger(PdfAChecker.class);
    private static final String TRANSPARENCY_ERROR_MESSAGE = "If the document does not contain a OutputIntent, then page with transparency shall include the dictionary with Group key that include a CS with blending colour space";
    private boolean currentFillCsIsIccBasedCMYK = false;
    private boolean currentStrokeCsIsIccBasedCMYK = false;
    private Map<PdfName, PdfArray> separationColorSpaces = new HashMap<PdfName, PdfArray>();

    public PdfA2Checker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    @Override
    public void checkInlineImage(PdfStream inlineImage, PdfDictionary currentColorSpaces) {
        PdfObject filter = inlineImage.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("LZWDecode filter is not permitted");
            }
            if (filter.equals(PdfName.Crypt)) {
                throw new PdfAConformanceException("Crypt filter is not permitted inline image");
            }
            if (!allowedInlineImageFilters.contains((PdfName)filter)) {
                throw new PdfAConformanceException("Filters that are not listed in ISO 32000-2:\u2014, 8.9.7, Table 92 or an array containing any such value shall not be used.");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals(PdfName.LZWDecode)) {
                    throw new PdfAConformanceException("LZWDecode filter is not permitted");
                }
                if (f.equals(PdfName.Crypt)) {
                    throw new PdfAConformanceException("Crypt filter is not permitted inline image");
                }
                if (allowedInlineImageFilters.contains(f)) continue;
                throw new PdfAConformanceException("Filters that are not listed in ISO 32000-2:\u2014, 8.9.7, Table 92 or an array containing any such value shall not be used.");
            }
        }
        this.checkImage(inlineImage, currentColorSpaces);
    }

    @Override
    @Deprecated
    public void checkColor(Color color, PdfDictionary currentColorSpaces, Boolean fill, PdfStream contentStream) {
        this.checkColor(null, color, currentColorSpaces, fill, contentStream);
    }

    @Override
    public void checkColor(CanvasGraphicsState gState, Color color, PdfDictionary currentColorSpaces, Boolean fill, PdfStream contentStream) {
        if (color instanceof PatternColor) {
            PdfPattern pattern = ((PatternColor)color).getPattern();
            if (pattern instanceof PdfPattern.Shading) {
                PdfDictionary shadingDictionary = ((PdfPattern.Shading)pattern).getShading();
                PdfObject colorSpace = shadingDictionary.get(PdfName.ColorSpace);
                this.checkColorSpace(PdfColorSpace.makeColorSpace(colorSpace), contentStream, currentColorSpaces, true, true);
                if (gState == null) {
                    PdfDictionary extGStateDict = ((PdfDictionary)pattern.getPdfObject()).getAsDictionary(PdfName.ExtGState);
                    gState = new UpdateCanvasGraphicsState(extGStateDict);
                }
                this.checkExtGState(gState, contentStream);
            } else if (pattern instanceof PdfPattern.Tiling) {
                this.checkContentStream((PdfStream)pattern.getPdfObject());
            }
        }
        super.checkColor(gState, color, currentColorSpaces, fill, contentStream);
    }

    @Override
    public void checkColorSpace(PdfColorSpace colorSpace, PdfObject pdfObject, PdfDictionary currentColorSpaces, boolean checkAlternate, Boolean fill) {
        byte[] iccBytes;
        if (fill != null) {
            if (fill.booleanValue()) {
                this.currentFillCsIsIccBasedCMYK = false;
            } else {
                this.currentStrokeCsIsIccBasedCMYK = false;
            }
        }
        if (colorSpace instanceof PdfSpecialCs.Separation) {
            PdfSpecialCs.Separation separation = (PdfSpecialCs.Separation)colorSpace;
            this.checkSeparationCS((PdfArray)separation.getPdfObject());
            if (checkAlternate) {
                this.checkColorSpace(separation.getBaseCs(), pdfObject, currentColorSpaces, false, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.DeviceN) {
            PdfSpecialCs.DeviceN deviceN = (PdfSpecialCs.DeviceN)colorSpace;
            this.checkNumberOfDeviceNComponents(deviceN);
            if (((PdfArray)deviceN.getPdfObject()).size() != 5) {
                throw new PdfAConformanceException("For any spot color used in a DeviceN or NChannel colorspace, an entry in the Colorants dictionary shall be present.");
            }
            PdfDictionary attributes = ((PdfArray)deviceN.getPdfObject()).getAsDictionary(4);
            PdfDictionary colorants = attributes.getAsDictionary(PdfName.Colorants);
            if (colorants != null && !colorants.isEmpty()) {
                for (Map.Entry<PdfName, PdfObject> entry : colorants.entrySet()) {
                    PdfArray separation = (PdfArray)entry.getValue();
                    this.checkSeparationInsideDeviceN(separation, ((PdfArray)deviceN.getPdfObject()).get(2), ((PdfArray)deviceN.getPdfObject()).get(3));
                }
            } else {
                throw new PdfAConformanceException("For any spot color used in a DeviceN or NChannel colorspace, an entry in the Colorants dictionary shall be present.");
            }
            if (checkAlternate) {
                this.checkColorSpace(deviceN.getBaseCs(), pdfObject, currentColorSpaces, false, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.Indexed) {
            if (checkAlternate) {
                this.checkColorSpace(((PdfSpecialCs.Indexed)colorSpace).getBaseCs(), pdfObject, currentColorSpaces, true, fill);
            }
        } else if (colorSpace instanceof PdfSpecialCs.UncoloredTilingPattern) {
            if (checkAlternate) {
                this.checkColorSpace(((PdfSpecialCs.UncoloredTilingPattern)colorSpace).getUnderlyingColorSpace(), pdfObject, currentColorSpaces, true, fill);
            }
        } else if (colorSpace instanceof PdfDeviceCs.Rgb) {
            if (!this.checkDefaultCS(pdfObject, currentColorSpaces, fill, PdfName.DefaultRGB, 3)) {
                this.rgbUsedObjects.add(pdfObject);
            }
        } else if (colorSpace instanceof PdfDeviceCs.Cmyk) {
            if (!this.checkDefaultCS(pdfObject, currentColorSpaces, fill, PdfName.DefaultCMYK, 4)) {
                this.cmykUsedObjects.add(pdfObject);
            }
        } else if (colorSpace instanceof PdfDeviceCs.Gray && !this.checkDefaultCS(pdfObject, currentColorSpaces, fill, PdfName.DefaultGray, 1)) {
            this.grayUsedObjects.add(pdfObject);
        }
        if (fill != null && colorSpace instanceof PdfCieBasedCs.IccBased && "CMYK".equals(IccProfile.getIccColorSpaceName(iccBytes = ((PdfArray)colorSpace.getPdfObject()).getAsStream(1).getBytes()))) {
            if (fill.booleanValue()) {
                this.currentFillCsIsIccBasedCMYK = true;
            } else {
                this.currentStrokeCsIsIccBasedCMYK = true;
            }
        }
    }

    @Override
    public void checkExtGState(CanvasGraphicsState extGState, PdfStream contentStream) {
        PdfObject bm;
        if (Integer.valueOf(1).equals(extGState.getOverprintMode())) {
            if (extGState.getFillOverprint() && this.currentFillCsIsIccBasedCMYK) {
                throw new PdfAConformanceException("Overprint mode shall not be one when an ICCBased CMYK colour space is used and when overprinting is set to true");
            }
            if (extGState.getStrokeOverprint() && this.currentStrokeCsIsIccBasedCMYK) {
                throw new PdfAConformanceException("Overprint mode shall not be one when an ICCBased CMYK colour space is used and when overprinting is set to true");
            }
        }
        if (extGState.getTransferFunction() != null) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the tr key");
        }
        if (extGState.getHTP() != null) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the HTP key");
        }
        PdfObject transferFunction2 = extGState.getTransferFunction2();
        if (transferFunction2 != null && !PdfName.Default.equals(transferFunction2)) {
            throw new PdfAConformanceException("An extgstate dictionary shall not contain the TR2 key with a value other than default");
        }
        if (extGState.getHalftone() instanceof PdfDictionary) {
            PdfDictionary halftoneDict = (PdfDictionary)extGState.getHalftone();
            Integer halftoneType = halftoneDict.getAsInt(PdfName.HalftoneType);
            if (halftoneType != 1 && halftoneType != 5) {
                throw new PdfAConformanceException("All halftones shall have halftonetype 1 or 5");
            }
            if (halftoneDict.containsKey(PdfName.HalftoneName)) {
                throw new PdfAConformanceException("Halftones shall not contain halftonename");
            }
        }
        this.checkRenderingIntent(extGState.getRenderingIntent());
        if (extGState.getSoftMask() != null && extGState.getSoftMask() instanceof PdfDictionary) {
            this.transparencyObjects.add(contentStream);
        }
        if (extGState.getStrokeOpacity() < 1.0f) {
            this.transparencyObjects.add(contentStream);
        }
        if (extGState.getFillOpacity() < 1.0f) {
            this.transparencyObjects.add(contentStream);
        }
        if ((bm = extGState.getBlendMode()) != null) {
            if (!PdfName.Normal.equals(bm)) {
                this.transparencyObjects.add(contentStream);
            }
            if (bm instanceof PdfArray) {
                for (PdfObject b : (PdfArray)bm) {
                    this.checkBlendMode((PdfName)b);
                }
            } else if (bm instanceof PdfName) {
                this.checkBlendMode((PdfName)bm);
            }
        }
    }

    @Override
    public void checkSignature(PdfDictionary signatureDict) {
        if (this.isAlreadyChecked(signatureDict)) {
            return;
        }
        PdfArray references = signatureDict.getAsArray(PdfName.Reference);
        if (references != null) {
            for (int i = 0; i < references.size(); ++i) {
                PdfDictionary referenceDict = references.getAsDictionary(i);
                if (!referenceDict.containsKey(PdfName.DigestLocation) && !referenceDict.containsKey(PdfName.DigestMethod) && !referenceDict.containsKey(PdfName.DigestValue)) continue;
                throw new PdfAConformanceException("Signature references dictionary shall not contain digestlocation digestmethod digestvalue");
            }
        }
    }

    protected void checkNumberOfDeviceNComponents(PdfSpecialCs.DeviceN deviceN) {
        if (deviceN.getNumberOfComponents() > 32) {
            throw new PdfAConformanceException("The number of color components in DeviceN colorspace should not exceed {0}", 32);
        }
    }

    @Override
    protected void checkNonSymbolicTrueTypeFont(PdfTrueTypeFont trueTypeFont) {
        String encoding = trueTypeFont.getFontEncoding().getBaseEncoding();
        if (!"Cp1252".equals(encoding) && !"MacRoman".equals(encoding)) {
            throw new PdfAConformanceException("All non-symbolic TrueType fonts shall specify MacRomanEncoding or WinAnsiEncoding as the value of the Encoding entry in the font dictionary ", trueTypeFont);
        }
    }

    @Override
    protected double getMaxRealValue() {
        return 3.4028234663852886E38;
    }

    @Override
    protected int getMaxStringLength() {
        return Short.MAX_VALUE;
    }

    @Override
    protected void checkPdfArray(PdfArray array) {
    }

    @Override
    protected void checkPdfDictionary(PdfDictionary dictionary) {
    }

    @Override
    protected void checkAnnotation(PdfDictionary annotDic) {
        PdfDictionary ap;
        PdfName subtype = annotDic.getAsName(PdfName.Subtype);
        if (subtype == null) {
            throw new PdfAConformanceException("Annotation type {0} is not permitted").setMessageParams("null");
        }
        if (this.getForbiddenAnnotations().contains(subtype)) {
            throw new PdfAConformanceException("Annotation type {0} is not permitted").setMessageParams(subtype.getValue());
        }
        if (!subtype.equals(PdfName.Popup)) {
            PdfNumber f = annotDic.getAsNumber(PdfName.F);
            if (f == null) {
                throw new PdfAConformanceException("An annotation dictionary shall contain the f key");
            }
            int flags = f.intValue();
            if (!PdfA2Checker.checkFlag(flags, 4) || PdfA2Checker.checkFlag(flags, 2) || PdfA2Checker.checkFlag(flags, 1) || PdfA2Checker.checkFlag(flags, 32) || PdfA2Checker.checkFlag(flags, 256)) {
                throw new PdfAConformanceException("The f keys print flag bit shall be set to 1 and its hidden invisible noview and togglenoview flag bits shall be set to 0");
            }
            if (!(!subtype.equals(PdfName.Text) || PdfA2Checker.checkFlag(flags, 8) && PdfA2Checker.checkFlag(flags, 16))) {
                throw new PdfAConformanceException("Text annotations should set the nozoom and norotate flag bits of the f key to 1");
            }
        }
        this.checkAnnotationAgainstActions(annotDic);
        if (PdfA2Checker.checkStructure(this.conformanceLevel) && contentAnnotations.contains(subtype) && !annotDic.containsKey(PdfName.Contents)) {
            logger.warn(MessageFormatUtil.format("Annotation of type {0} should have contents key", subtype.getValue()));
        }
        if ((ap = annotDic.getAsDictionary(PdfName.AP)) != null) {
            if (ap.containsKey(PdfName.R) || ap.containsKey(PdfName.D)) {
                throw new PdfAConformanceException("Appearance dictionary shall contain only the n key with stream value");
            }
            PdfObject n = ap.get(PdfName.N);
            if (PdfName.Widget.equals(subtype) && PdfName.Btn.equals(PdfFormField.getFormType(annotDic))) {
                if (n == null || !n.isDictionary()) {
                    throw new PdfAConformanceException("Appearance dictionary of widget subtype and btn field type shall contain only the n key with dictionary value");
                }
            } else if (n == null || !n.isStream()) {
                throw new PdfAConformanceException("Appearance dictionary shall contain only the n key with stream value");
            }
            this.checkResourcesOfAppearanceStreams(ap);
        } else {
            boolean isCorrectRect = false;
            PdfArray rect = annotDic.getAsArray(PdfName.Rect);
            if (rect != null && rect.size() == 4) {
                PdfNumber index0 = rect.getAsNumber(0);
                PdfNumber index1 = rect.getAsNumber(1);
                PdfNumber index2 = rect.getAsNumber(2);
                PdfNumber index3 = rect.getAsNumber(3);
                if (index0 != null && index1 != null && index2 != null && index3 != null && index0.floatValue() == index2.floatValue() && index1.floatValue() == index3.floatValue()) {
                    isCorrectRect = true;
                }
            }
            if (!this.getAppearanceLessAnnotations().contains(subtype) && !isCorrectRect) {
                throw new PdfAConformanceException("Every annotation shall have at least one appearance dictionary");
            }
        }
    }

    protected Set<PdfName> getAppearanceLessAnnotations() {
        return apLessAnnotations;
    }

    protected void checkAnnotationAgainstActions(PdfDictionary annotDic) {
        if (PdfName.Widget.equals(annotDic.getAsName(PdfName.Subtype)) && (annotDic.containsKey(PdfName.AA) || annotDic.containsKey(PdfName.A))) {
            throw new PdfAConformanceException("Widget annotation dictionary or field dictionary shall not include a or aa entry");
        }
        if (annotDic.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("An annotation dictionary shall not contain aa key");
        }
    }

    @Override
    protected Set<PdfName> getForbiddenAnnotations() {
        return forbiddenAnnotations;
    }

    @Override
    protected void checkAppearanceStream(PdfStream appearanceStream) {
        if (this.isAlreadyChecked(appearanceStream)) {
            return;
        }
        if (PdfA2Checker.isContainsTransparencyGroup(appearanceStream)) {
            this.transparencyObjects.add(appearanceStream);
        }
        this.checkResources(appearanceStream.getAsDictionary(PdfName.Resources), appearanceStream);
    }

    @Override
    protected void checkForm(PdfDictionary form) {
        if (form != null) {
            PdfBoolean needAppearances = form.getAsBoolean(PdfName.NeedAppearances);
            if (needAppearances != null && needAppearances.getValue()) {
                throw new PdfAConformanceException("Needappearances flag of the interactive form dictionary shall either not be presented or shall be false");
            }
            if (form.containsKey(PdfName.XFA)) {
                throw new PdfAConformanceException("The interactive form dictionary shall not contain the xfa key");
            }
            this.checkResources(form.getAsDictionary(PdfName.DR), form);
            PdfArray fields = form.getAsArray(PdfName.Fields);
            if (fields != null) {
                fields = this.getFormFields(fields);
                for (PdfObject field : fields) {
                    PdfDictionary fieldDic = (PdfDictionary)field;
                    this.checkResources(fieldDic.getAsDictionary(PdfName.DR), fieldDic);
                }
            }
        }
    }

    protected void checkCatalogAAConformance(PdfDictionary dict) {
        if (dict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("A catalog dictionary shall not contain aa entry");
        }
    }

    @Override
    protected void checkCatalogValidEntries(PdfDictionary catalogDict) {
        PdfDictionary namesDictionary;
        if (catalogDict.containsKey(PdfName.NeedsRendering)) {
            throw new PdfAConformanceException("The catalog dictionary shall not contain the needsrendering key");
        }
        this.checkCatalogAAConformance(catalogDict);
        if (catalogDict.containsKey(PdfName.Requirements)) {
            throw new PdfAConformanceException("A catalog dictionary shall not contain a requirements entry");
        }
        PdfDictionary permissions = catalogDict.getAsDictionary(PdfName.Perms);
        if (permissions != null) {
            for (PdfName dictKey : permissions.keySet()) {
                if (PdfName.DocMDP.equals(dictKey)) {
                    PdfDictionary signatureDict = permissions.getAsDictionary(PdfName.DocMDP);
                    if (signatureDict == null) continue;
                    this.checkSignature(signatureDict);
                    continue;
                }
                if (PdfName.UR3.equals(dictKey)) continue;
                throw new PdfAConformanceException("No keys other than UR3 and DocMDP shall be present in a permissions dictionary");
            }
        }
        if ((namesDictionary = catalogDict.getAsDictionary(PdfName.Names)) != null && namesDictionary.containsKey(PdfName.AlternatePresentations)) {
            throw new PdfAConformanceException("A catalog dictionary shall not contain alternatepresentations names entry");
        }
        this.checkOCProperties(catalogDict.getAsDictionary(PdfName.OCProperties));
    }

    @Override
    protected void checkPageSize(PdfDictionary page) {
        PdfName[] boxNames;
        for (PdfName boxName : boxNames = new PdfName[]{PdfName.MediaBox, PdfName.CropBox, PdfName.TrimBox, PdfName.ArtBox, PdfName.BleedBox}) {
            Rectangle box = page.getAsRectangle(boxName);
            if (box == null) continue;
            float width = box.getWidth();
            float height = box.getHeight();
            if (!(width < 3.0f || width > 14400.0f || height < 3.0f) && !(height > 14400.0f)) continue;
            throw new PdfAConformanceException("The page is less than 3 units or greater than 14400 in either direction");
        }
    }

    @Override
    protected void checkFileSpec(PdfDictionary fileSpec) {
        if (fileSpec.containsKey(PdfName.EF)) {
            PdfDictionary ef;
            PdfStream embeddedFile;
            if (!fileSpec.containsKey(PdfName.F) || !fileSpec.containsKey(PdfName.UF)) {
                throw new PdfAConformanceException("File specification dictionary shall contain f key and uf key");
            }
            if (!fileSpec.containsKey(PdfName.Desc)) {
                logger.warn("File specification dictionary should contain desc key");
            }
            if ((embeddedFile = (ef = fileSpec.getAsDictionary(PdfName.EF)).getAsStream(PdfName.F)) == null) {
                throw new PdfAConformanceException("Ef key of file specification dictionary shall contain dictionary with valid f key");
            }
            logger.warn("Embedded file shall be compliant with either ISO 19005-1 (PDF-A/1 standard) or ISO 19005-2 (PDF-A/2 standard). Please ensure that fact, because iText doesn't check embedded file.");
        }
    }

    @Override
    protected void checkPdfStream(PdfStream stream) {
        this.checkPdfDictionary(stream);
        if (stream.containsKey(PdfName.F) || stream.containsKey(PdfName.FFilter) || stream.containsKey(PdfName.FDecodeParams)) {
            throw new PdfAConformanceException("Stream object dictionary shall not contain the f ffilter or fdecodeparams keys");
        }
        PdfObject filter = stream.get(PdfName.Filter);
        if (filter instanceof PdfName) {
            PdfName cryptFilterName;
            PdfDictionary decodeParams;
            if (filter.equals(PdfName.LZWDecode)) {
                throw new PdfAConformanceException("LZWDecode filter is not permitted");
            }
            if (filter.equals(PdfName.Crypt) && (decodeParams = stream.getAsDictionary(PdfName.DecodeParms)) != null && (cryptFilterName = decodeParams.getAsName(PdfName.Name)) != null && !cryptFilterName.equals(PdfName.Identity)) {
                throw new PdfAConformanceException("Not identity crypt filter is not permitted");
            }
            if (!allowedFilters.contains((PdfName)filter)) {
                throw new PdfAConformanceException("Filters that are not listed in ISO 32000-2:\u2014, 7.4, Table 6 shall not be used.");
            }
        } else if (filter instanceof PdfArray) {
            for (int i = 0; i < ((PdfArray)filter).size(); ++i) {
                PdfDictionary decodeParam;
                PdfName cryptFilterName;
                PdfArray decodeParams;
                PdfName f = ((PdfArray)filter).getAsName(i);
                if (f.equals(PdfName.LZWDecode)) {
                    throw new PdfAConformanceException("LZWDecode filter is not permitted");
                }
                if (f.equals(PdfName.Crypt) && (decodeParams = stream.getAsArray(PdfName.DecodeParms)) != null && i < decodeParams.size() && (cryptFilterName = (decodeParam = decodeParams.getAsDictionary(i)).getAsName(PdfName.Name)) != null && !cryptFilterName.equals(PdfName.Identity)) {
                    throw new PdfAConformanceException("Not identity crypt filter is not permitted");
                }
                if (allowedFilters.contains(f)) continue;
                throw new PdfAConformanceException("Filters that are not listed in ISO 32000-2:\u2014, 7.4, Table 6 shall not be used.");
            }
        }
    }

    protected void checkPageAAConformance(PdfDictionary dict) {
        if (dict.containsKey(PdfName.AA)) {
            throw new PdfAConformanceException("The page dictionary shall not contain aa entry");
        }
    }

    @Override
    protected void checkPageObject(PdfDictionary pageDict, PdfDictionary pageResources) {
        PdfObject cs;
        this.checkPageAAConformance(pageDict);
        if (pageDict.containsKey(PdfName.PresSteps)) {
            throw new PdfAConformanceException("The page dictionary shall not contain pressteps entry");
        }
        if (PdfA2Checker.isContainsTransparencyGroup(pageDict) && (cs = pageDict.getAsDictionary(PdfName.Group).get(PdfName.CS)) != null) {
            PdfDictionary currentColorSpaces = pageResources.getAsDictionary(PdfName.ColorSpace);
            this.checkColorSpace(PdfColorSpace.makeColorSpace(cs), pageDict, currentColorSpaces, true, null);
        }
    }

    @Override
    protected void checkPageTransparency(PdfDictionary pageDict, PdfDictionary pageResources) {
        if (this.pdfAOutputIntentColorSpace == null && this.transparencyObjects.size() > 0 && (pageDict.getAsDictionary(PdfName.Group) == null || pageDict.getAsDictionary(PdfName.Group).get(PdfName.CS) == null)) {
            this.checkContentsForTransparency(pageDict);
            this.checkAnnotationsForTransparency(pageDict.getAsArray(PdfName.Annots));
            this.checkResourcesForTransparency(pageResources, new HashSet<PdfObject>());
        }
    }

    @Override
    protected void checkOutputIntents(PdfDictionary catalog) {
        int i;
        PdfArray outputIntents = catalog.getAsArray(PdfName.OutputIntents);
        if (outputIntents == null) {
            return;
        }
        PdfObject destOutputProfile = null;
        for (i = 0; i < outputIntents.size() && destOutputProfile == null; ++i) {
            destOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
        }
        while (i < outputIntents.size()) {
            PdfObject otherDestOutputProfile = outputIntents.getAsDictionary(i).get(PdfName.DestOutputProfile);
            if (otherDestOutputProfile != null && destOutputProfile != otherDestOutputProfile) {
                throw new PdfAConformanceException("If outputintents array has more than one entry with destoutputprofile key the same indirect object shall be used as the value of that object");
            }
            ++i;
        }
        if (destOutputProfile != null) {
            String deviceClass = IccProfile.getIccDeviceClass(((PdfStream)destOutputProfile).getBytes());
            if (!"prtr".equals(deviceClass) && !"mntr".equals(deviceClass)) {
                throw new PdfAConformanceException("Profile stream of outputintent shall be output profile (prtr) or monitor profile (mntr)");
            }
            String cs = IccProfile.getIccColorSpaceName(((PdfStream)destOutputProfile).getBytes());
            if (!("RGB ".equals(cs) || "CMYK".equals(cs) || "GRAY".equals(cs))) {
                throw new PdfAConformanceException("Output intent color space shall be either gray rgb or cmyk");
            }
        }
    }

    @Override
    protected Set<PdfName> getForbiddenActions() {
        return forbiddenActions;
    }

    @Override
    protected Set<PdfName> getAllowedNamedActions() {
        return allowedNamedActions;
    }

    @Override
    protected void checkPageColorsUsages(PdfDictionary pageDict, PdfDictionary pageResources) {
        if ((this.rgbIsUsed || this.cmykIsUsed || this.grayIsUsed || !this.rgbUsedObjects.isEmpty() || !this.cmykUsedObjects.isEmpty() || !this.grayUsedObjects.isEmpty()) && this.pdfAOutputIntentColorSpace == null) {
            throw new PdfAConformanceException("If device rgb cmyk gray used in file that file shall contain pdfa outputintent or DefaultRgb Cmyk Gray in usage context");
        }
        if (!(!this.rgbIsUsed && this.rgbUsedObjects.isEmpty() || "RGB ".equals(this.pdfAOutputIntentColorSpace))) {
            throw new PdfAConformanceException("Devicergb may be used only if the file has a rgb pdfa outputIntent or defaultrgb in usage context");
        }
        if (!(!this.cmykIsUsed && this.cmykUsedObjects.isEmpty() || "CMYK".equals(this.pdfAOutputIntentColorSpace))) {
            throw new PdfAConformanceException("Devicecmyk may be used only if the file has a cmyk pdfa outputIntent or defaultcmyk in usage context");
        }
    }

    private void checkOCProperties(PdfDictionary oCProperties) {
        if (oCProperties != null) {
            PdfArray configs;
            ArrayList<PdfDictionary> configList = new ArrayList<PdfDictionary>();
            PdfDictionary d = oCProperties.getAsDictionary(PdfName.D);
            if (d != null) {
                configList.add(d);
            }
            if ((configs = oCProperties.getAsArray(PdfName.Configs)) != null) {
                for (PdfObject config : configs) {
                    configList.add((PdfDictionary)config);
                }
            }
            HashSet<PdfObject> ocgs = new HashSet<PdfObject>();
            PdfArray ocgsArray = oCProperties.getAsArray(PdfName.OCGs);
            if (ocgsArray != null) {
                for (PdfObject ocg : ocgsArray) {
                    ocgs.add(ocg);
                }
            }
            HashSet<String> names = new HashSet<String>();
            for (PdfDictionary config : configList) {
                this.checkCatalogConfig(config, ocgs, names);
            }
        }
    }

    @Override
    protected void checkImage(PdfStream image, PdfDictionary currentColorSpaces) {
        PdfColorSpace colorSpace = null;
        if (this.isAlreadyChecked(image)) {
            colorSpace = (PdfColorSpace)this.checkedObjectsColorspace.get(image);
            this.checkColorSpace(colorSpace, image, currentColorSpaces, true, null);
            return;
        }
        PdfObject colorSpaceObj = image.get(PdfName.ColorSpace);
        if (colorSpaceObj != null) {
            colorSpace = PdfColorSpace.makeColorSpace(colorSpaceObj);
            this.checkColorSpace(colorSpace, image, currentColorSpaces, true, null);
            this.checkedObjectsColorspace.put(image, colorSpace);
        }
        if (image.containsKey(PdfName.Alternates)) {
            throw new PdfAConformanceException("An image dictionary shall not contain alternates key");
        }
        if (image.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("An image dictionary shall not contain opi key");
        }
        if (image.containsKey(PdfName.Interpolate) && image.getAsBool(PdfName.Interpolate).booleanValue()) {
            throw new PdfAConformanceException("The value of interpolate key shall not be true");
        }
        this.checkRenderingIntent(image.getAsName(PdfName.Intent));
        if (image.getAsStream(PdfName.SMask) != null) {
            this.transparencyObjects.add(image);
        }
        if (image.containsKey(PdfName.SMaskInData) && image.getAsInt(PdfName.SMaskInData) > 0) {
            this.transparencyObjects.add(image);
        }
        if (PdfName.JPXDecode.equals(image.get(PdfName.Filter))) {
            Jpeg2000ImageData jpgImage = (Jpeg2000ImageData)ImageDataFactory.createJpeg2000(image.getBytes(false));
            Jpeg2000ImageData.Parameters params = jpgImage.getParameters();
            if (!params.isJp2) {
                throw new PdfAConformanceException("Only jpx baseline set of features shall be used");
            }
            if (params.numOfComps != 1 && params.numOfComps != 3 && params.numOfComps != 4) {
                throw new PdfAConformanceException("The number of colour channels in the jpeg2000 data shall be 1, 3 or 4");
            }
            if (params.colorSpecBoxes != null && params.colorSpecBoxes.size() > 1) {
                int numOfApprox0x01 = 0;
                for (Jpeg2000ImageData.ColorSpecBox colorSpecBox : params.colorSpecBoxes) {
                    if (colorSpecBox.getApprox() == 1) {
                        if (++numOfApprox0x01 == 1 && colorSpecBox.getMeth() != 1 && colorSpecBox.getMeth() != 2 && colorSpecBox.getMeth() != 3) {
                            throw new PdfAConformanceException("The value of the meth entry in colr box shall be 1, 2 or 3");
                        }
                        if (image.get(PdfName.ColorSpace) == null) {
                            switch (colorSpecBox.getEnumCs()) {
                                case 1: {
                                    PdfDeviceCs.Gray deviceGrayCs = new PdfDeviceCs.Gray();
                                    this.checkColorSpace(deviceGrayCs, image, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceGrayCs);
                                    break;
                                }
                                case 3: {
                                    PdfDeviceCs.Rgb deviceRgbCs = new PdfDeviceCs.Rgb();
                                    this.checkColorSpace(deviceRgbCs, image, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceRgbCs);
                                    break;
                                }
                                case 12: {
                                    PdfDeviceCs.Cmyk deviceCmykCs = new PdfDeviceCs.Cmyk();
                                    this.checkColorSpace(deviceCmykCs, image, currentColorSpaces, true, null);
                                    this.checkedObjectsColorspace.put(image, deviceCmykCs);
                                }
                            }
                        }
                    }
                    if (colorSpecBox.getEnumCs() != 19) continue;
                    throw new PdfAConformanceException("jpeg2000 enumerated colour space 19 (CIEJab) shall not be used");
                }
                if (numOfApprox0x01 != 1) {
                    throw new PdfAConformanceException("Exactly one colour space specification shall have the value 0x01 in the approx field");
                }
            }
            if (jpgImage.getBpc() < 1 || jpgImage.getBpc() > 38) {
                throw new PdfAConformanceException("The bit-depth of the jpeg2000 data shall have a value in the range 1 to 38");
            }
            if (params.bpcBoxData != null) {
                throw new PdfAConformanceException("All colour channels in the jpeg2000 data shall have the same bit-depth");
            }
        }
    }

    @Override
    public void checkFontGlyphs(PdfFont font, PdfStream contentStream) {
        if (font instanceof PdfType3Font) {
            this.checkType3FontGlyphs((PdfType3Font)font, contentStream);
        }
    }

    @Override
    @Deprecated
    protected void checkFormXObject(PdfStream form) {
        this.checkFormXObject(form, null);
    }

    protected void checkFormXObject(PdfStream form, PdfStream contentStream) {
        if (this.isAlreadyChecked(form)) {
            return;
        }
        if (form.containsKey(PdfName.OPI)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain opi key");
        }
        if (form.containsKey(PdfName.PS)) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain PS key");
        }
        if (PdfName.PS.equals(form.getAsName(PdfName.Subtype2))) {
            throw new PdfAConformanceException("A form xobject dictionary shall not contain subtype2 key with a value of PS");
        }
        this.checkTransparencyGroup(form, contentStream);
        this.checkResources(form.getAsDictionary(PdfName.Resources), contentStream != null ? contentStream : form);
        this.checkContentStream(form);
    }

    protected void checkTransparencyGroup(PdfStream form, PdfStream contentStream) {
        if (PdfA2Checker.isContainsTransparencyGroup(form)) {
            if (contentStream != null) {
                this.transparencyObjects.add(contentStream);
            } else {
                this.transparencyObjects.add(form);
            }
            PdfObject cs = form.getAsDictionary(PdfName.Group).get(PdfName.CS);
            PdfDictionary resources = form.getAsDictionary(PdfName.Resources);
            if (cs != null && resources != null) {
                PdfDictionary currentColorSpaces = resources.getAsDictionary(PdfName.ColorSpace);
                this.checkColorSpace(PdfColorSpace.makeColorSpace(cs), contentStream != null ? contentStream : form, currentColorSpaces, true, null);
            }
        }
    }

    protected void checkContentConfigurationDictAgainstAsKey(PdfDictionary config) {
        if (config.containsKey(PdfName.AS)) {
            throw new PdfAConformanceException("The as key shall not appear in any optional content configuration dictionary");
        }
    }

    protected String getTransparencyErrorMessage() {
        return TRANSPARENCY_ERROR_MESSAGE;
    }

    protected void checkBlendMode(PdfName blendMode) {
        if (!allowedBlendModes.contains(blendMode)) {
            throw new PdfAConformanceException("Only standard blend modes shall be used for the value of the BM key in an extended graphic state dictionary");
        }
    }

    void checkContentsForTransparency(PdfDictionary pageDict) {
        PdfStream contentStream = pageDict.getAsStream(PdfName.Contents);
        if (contentStream != null && this.transparencyObjects.contains(contentStream)) {
            throw new PdfAConformanceException(this.getTransparencyErrorMessage());
        }
        PdfArray contentSteamArray = pageDict.getAsArray(PdfName.Contents);
        if (contentSteamArray != null) {
            for (int i = 0; i < contentSteamArray.size(); ++i) {
                if (!this.transparencyObjects.contains(contentSteamArray.get(i))) continue;
                throw new PdfAConformanceException(this.getTransparencyErrorMessage());
            }
        }
    }

    void checkAnnotationsForTransparency(PdfArray annotations) {
        if (annotations == null) {
            return;
        }
        for (int i = 0; i < annotations.size(); ++i) {
            PdfDictionary annot = annotations.getAsDictionary(i);
            if (this.transparencyObjects.contains(annot)) {
                throw new PdfAConformanceException(this.getTransparencyErrorMessage());
            }
            PdfDictionary ap = annot.getAsDictionary(PdfName.AP);
            if (ap == null) continue;
            this.checkAppearanceStreamForTransparency(ap, new HashSet<PdfObject>());
        }
    }

    private void checkAppearanceStreamForTransparency(PdfDictionary ap, Set<PdfObject> checkedObjects) {
        if (checkedObjects.contains(ap)) {
            return;
        }
        checkedObjects.add(ap);
        for (PdfObject val : ap.values()) {
            if (this.transparencyObjects.contains(val)) {
                throw new PdfAConformanceException(this.getTransparencyErrorMessage());
            }
            if (val.isDictionary()) {
                this.checkAppearanceStreamForTransparency((PdfDictionary)val, checkedObjects);
                continue;
            }
            if (!val.isStream()) continue;
            this.checkObjectWithResourcesForTransparency(val, checkedObjects);
        }
    }

    private void checkObjectWithResourcesForTransparency(PdfObject objectWithResources, Set<PdfObject> checkedObjects) {
        if (checkedObjects.contains(objectWithResources)) {
            return;
        }
        checkedObjects.add(objectWithResources);
        if (this.transparencyObjects.contains(objectWithResources)) {
            throw new PdfAConformanceException(this.getTransparencyErrorMessage());
        }
        if (objectWithResources instanceof PdfDictionary) {
            this.checkResourcesForTransparency(((PdfDictionary)objectWithResources).getAsDictionary(PdfName.Resources), checkedObjects);
        }
    }

    void checkResourcesForTransparency(PdfDictionary resources, Set<PdfObject> checkedObjects) {
        if (resources != null) {
            this.checkSingleResourceTypeForTransparency(resources.getAsDictionary(PdfName.XObject), checkedObjects);
            this.checkSingleResourceTypeForTransparency(resources.getAsDictionary(PdfName.Pattern), checkedObjects);
        }
    }

    private void checkSingleResourceTypeForTransparency(PdfDictionary singleResourceDict, Set<PdfObject> checkedObjects) {
        if (singleResourceDict != null) {
            for (PdfObject resource : singleResourceDict.values()) {
                this.checkObjectWithResourcesForTransparency(resource, checkedObjects);
            }
        }
    }

    private void checkSeparationInsideDeviceN(PdfArray separation, PdfObject deviceNColorSpace, PdfObject deviceNTintTransform) {
        if (!this.isAltCSIsTheSame(separation.get(2), deviceNColorSpace) || !deviceNTintTransform.equals(separation.get(3))) {
            logger.warn("TintTransform and alternateSpace of separation arrays in the colorants of deviceN should be consistent with same attributes of deviceN");
        }
        this.checkSeparationCS(separation);
    }

    private void checkSeparationCS(PdfArray separation) {
        if (this.separationColorSpaces.containsKey(separation.getAsName(0))) {
            boolean tintTransformIsTheSame;
            PdfArray sameNameSeparation = this.separationColorSpaces.get(separation.getAsName(0));
            PdfObject cs1 = separation.get(2);
            PdfObject cs2 = sameNameSeparation.get(2);
            boolean altCSIsTheSame = this.isAltCSIsTheSame(cs1, cs2);
            PdfObject f1Obj = separation.get(3);
            PdfObject f2Obj = sameNameSeparation.get(3);
            boolean bothAllowedType = f1Obj.getType() == f2Obj.getType() && (f1Obj.isDictionary() || f1Obj.isStream());
            boolean bl = tintTransformIsTheSame = bothAllowedType && f1Obj.equals(f2Obj);
            if (!altCSIsTheSame || !tintTransformIsTheSame) {
                throw new PdfAConformanceException("TintTransform and alternateSpace shall be the same for the all separation cs with the same name");
            }
        } else {
            this.separationColorSpaces.put(separation.getAsName(0), separation);
        }
    }

    private boolean isAltCSIsTheSame(PdfObject cs1, PdfObject cs2) {
        boolean altCSIsTheSame = false;
        if (cs1 instanceof PdfName) {
            altCSIsTheSame = cs1.equals(cs2);
        } else if (cs1 instanceof PdfArray && cs2 instanceof PdfArray) {
            altCSIsTheSame = ((PdfArray)cs1).get(0).equals(((PdfArray)cs1).get(0));
        }
        return altCSIsTheSame;
    }

    private void checkCatalogConfig(PdfDictionary config, HashSet<PdfObject> ocgs, HashSet<String> names) {
        PdfString name = config.getAsString(PdfName.Name);
        if (name == null) {
            throw new PdfAConformanceException("Optional content configuration dictionary shall contain name entry");
        }
        if (!names.add(name.toUnicodeString())) {
            throw new PdfAConformanceException("Value of name entry shall be unique among all optional content configuration dictionaries");
        }
        this.checkContentConfigurationDictAgainstAsKey(config);
        PdfArray orderArray = config.getAsArray(PdfName.Order);
        if (orderArray != null) {
            HashSet<PdfObject> order = new HashSet<PdfObject>();
            this.fillOrderRecursively(orderArray, order);
            if (!order.equals(ocgs)) {
                throw new PdfAConformanceException("Order array shall contain references to all ocgs");
            }
        }
    }

    private void fillOrderRecursively(PdfArray orderArray, Set<PdfObject> order) {
        for (PdfObject orderItem : orderArray) {
            if (!orderItem.isArray()) {
                order.add(orderItem);
                continue;
            }
            this.fillOrderRecursively((PdfArray)orderItem, order);
        }
    }

    private boolean checkDefaultCS(PdfObject pdfObject, PdfDictionary currentColorSpaces, Boolean fill, PdfName defaultCsName, int numOfComponents) {
        if (currentColorSpaces == null) {
            return false;
        }
        if (!currentColorSpaces.containsKey(defaultCsName)) {
            return false;
        }
        PdfObject defaultCsObj = currentColorSpaces.get(defaultCsName);
        PdfColorSpace defaultCs = PdfColorSpace.makeColorSpace(defaultCsObj);
        if (defaultCs instanceof PdfDeviceCs) {
            throw new PdfAConformanceException("Color space {0} shall be device independent").setMessageParams(defaultCsName.toString());
        }
        if (defaultCs.getNumberOfComponents() != numOfComponents) {
            throw new PdfAConformanceException("Color space {0} shall have {1} components").setMessageParams(defaultCsName.getValue(), numOfComponents);
        }
        this.checkColorSpace(defaultCs, pdfObject, currentColorSpaces, false, fill);
        return true;
    }

    private void checkType3FontGlyphs(PdfType3Font font, PdfStream contentStream) {
        for (int i = 0; i <= 255; ++i) {
            Type3Glyph type3Glyph;
            FontEncoding fontEncoding = font.getFontEncoding();
            if (!fontEncoding.canDecode(i) || (type3Glyph = font.getType3Glyph(fontEncoding.getUnicode(i))) == null) continue;
            this.checkFormXObject(type3Glyph.getContentStream(), contentStream);
        }
    }

    private static final class UpdateCanvasGraphicsState
    extends CanvasGraphicsState {
        public UpdateCanvasGraphicsState(PdfDictionary extGStateDict) {
            this.updateFromExtGState(new PdfExtGState(extGStateDict));
        }
    }
}

