/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.signatures.DigestAlgorithms;
import com.itextpdf.signatures.ICrlClient;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.IIssuingCertificateRetriever;
import com.itextpdf.signatures.IOcspClient;
import com.itextpdf.signatures.ISignatureMechanismParams;
import com.itextpdf.signatures.ITSAClient;
import com.itextpdf.signatures.IssuingCertificateRetriever;
import com.itextpdf.signatures.LtvVerification;
import com.itextpdf.signatures.PdfPadesSigner;
import com.itextpdf.signatures.PdfTwoPhaseSigner;
import com.itextpdf.signatures.SignatureMechanisms;
import com.itextpdf.signatures.SignerProperties;
import com.itextpdf.signatures.cms.AlgorithmIdentifier;
import com.itextpdf.signatures.cms.CMSContainer;
import com.itextpdf.signatures.cms.CmsAttribute;
import com.itextpdf.signatures.cms.SignerInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PadesTwoPhaseSigningHelper {
    private static final IBouncyCastleFactory FACTORY = BouncyCastleFactoryCreator.getFactory();
    private IOcspClient ocspClient;
    private ICrlClient crlClient;
    private ITSAClient tsaClient;
    private String temporaryDirectoryPath;
    private String timestampSignatureName;
    private StampingProperties stampingProperties = new StampingProperties().useAppendMode();
    private IIssuingCertificateRetriever issuingCertificateRetriever = new IssuingCertificateRetriever();
    private int estimatedSize = -1;

    public PadesTwoPhaseSigningHelper setOcspClient(IOcspClient ocspClient) {
        this.ocspClient = ocspClient;
        return this;
    }

    public PadesTwoPhaseSigningHelper setTrustedCertificates(List<Certificate> certificateList) {
        this.issuingCertificateRetriever.setTrustedCertificates(certificateList);
        return this;
    }

    public PadesTwoPhaseSigningHelper setCrlClient(ICrlClient crlClient) {
        this.crlClient = crlClient;
        return this;
    }

    public PadesTwoPhaseSigningHelper setTSAClient(ITSAClient tsaClient) {
        this.tsaClient = tsaClient;
        return this;
    }

    public PadesTwoPhaseSigningHelper setIssuingCertificateRetriever(IIssuingCertificateRetriever issuingCertificateRetriever) {
        this.issuingCertificateRetriever = issuingCertificateRetriever;
        return this;
    }

    public PadesTwoPhaseSigningHelper setEstimatedSize(int estimatedSize) {
        this.estimatedSize = estimatedSize;
        return this;
    }

    public PadesTwoPhaseSigningHelper setTemporaryDirectoryPath(String temporaryDirectoryPath) {
        this.temporaryDirectoryPath = temporaryDirectoryPath;
        return this;
    }

    public PadesTwoPhaseSigningHelper setTimestampSignatureName(String timestampSignatureName) {
        this.timestampSignatureName = timestampSignatureName;
        return this;
    }

    public PadesTwoPhaseSigningHelper setStampingProperties(StampingProperties stampingProperties) {
        this.stampingProperties = stampingProperties;
        return this;
    }

    public CMSContainer createCMSContainerWithoutSignature(Certificate[] certificates, String digestAlgorithm, PdfReader inputDocument, OutputStream outputStream, SignerProperties signerProperties) throws IOException, GeneralSecurityException {
        Certificate[] fullChain = this.issuingCertificateRetriever.retrieveMissingCertificates(certificates);
        X509Certificate[] x509FullChain = Arrays.asList(fullChain).toArray(new X509Certificate[0]);
        PdfPadesSigner padesSigner = this.createPadesSigner(inputDocument, outputStream);
        PdfTwoPhaseSigner pdfTwoPhaseSigner = new PdfTwoPhaseSigner(inputDocument, outputStream);
        CMSContainer cms = new CMSContainer();
        SignerInfo signerInfo = new SignerInfo();
        String digestAlgorithmOid = DigestAlgorithms.getAllowedDigest(digestAlgorithm);
        signerInfo.setSigningCertificateAndAddToSignedAttributes(x509FullChain[0], digestAlgorithmOid);
        signerInfo.setDigestAlgorithm(new AlgorithmIdentifier(digestAlgorithmOid));
        cms.addCertificates(x509FullChain);
        cms.setSignerInfo(signerInfo);
        MessageDigest messageDigest = MessageDigest.getInstance(DigestAlgorithms.getDigest(digestAlgorithmOid));
        int realSignatureSize = messageDigest.getDigestLength() + (int)cms.getSizeEstimation();
        if (this.tsaClient != null) {
            realSignatureSize += this.tsaClient.getTokenSizeEstimate();
        }
        int expectedSignatureSize = this.estimatedSize < 0 ? realSignatureSize : this.estimatedSize;
        byte[] digestedDocumentBytes = pdfTwoPhaseSigner.prepareDocumentForSignature(signerProperties, digestAlgorithm, PdfName.Adobe_PPKLite, PdfName.ETSI_CAdES_DETACHED, expectedSignatureSize, true);
        signerInfo.setMessageDigest(digestedDocumentBytes);
        return cms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signCMSContainerWithBaselineBProfile(IExternalSignature externalSignature, PdfReader inputDocument, OutputStream outputStream, String signatureFieldName, CMSContainer cmsContainer) throws Exception {
        this.setSignatureAlgorithmAndSignature(externalSignature, cmsContainer);
        try (PdfDocument document = new PdfDocument(inputDocument);){
            PdfTwoPhaseSigner.addSignatureToPreparedDocument(document, signatureFieldName, outputStream, cmsContainer);
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signCMSContainerWithBaselineTProfile(IExternalSignature externalSignature, PdfReader inputDocument, OutputStream outputStream, String signatureFieldName, CMSContainer cmsContainer) throws Exception {
        byte[] signature = this.setSignatureAlgorithmAndSignature(externalSignature, cmsContainer);
        if (this.tsaClient == null) {
            throw new PdfException("ITSAClient must be present to reach this PAdES level. Please use setTSAClient method to provide it.");
        }
        byte[] signatureDigest = this.tsaClient.getMessageDigest().digest(signature);
        byte[] timestamp = this.tsaClient.getTimeStampToken(signatureDigest);
        try (IASN1InputStream tempStream = FACTORY.createASN1InputStream(new ByteArrayInputStream(timestamp));){
            IASN1Sequence seq = FACTORY.createASN1Sequence(tempStream.readObject());
            CmsAttribute timestampAttribute = new CmsAttribute("1.2.840.113549.1.9.16.2.14", FACTORY.createDERSet(seq));
            cmsContainer.getSignerInfo().addUnSignedAttribute(timestampAttribute);
        }
        try {
            var10_10 = null;
            try (PdfDocument document = new PdfDocument(inputDocument);){
                PdfTwoPhaseSigner.addSignatureToPreparedDocument(document, signatureFieldName, outputStream, cmsContainer);
            }
            catch (Throwable throwable) {
                var10_10 = throwable;
                throw throwable;
            }
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signCMSContainerWithBaselineLTProfile(IExternalSignature externalSignature, PdfReader inputDocument, OutputStream outputStream, String signatureFieldName, CMSContainer cmsContainer) throws Exception {
        PdfPadesSigner padesSigner = this.createPadesSigner(inputDocument, outputStream);
        padesSigner.createRevocationClients(cmsContainer.getSignerInfo().getSigningCertificate(), true);
        try (OutputStream tempOutput = padesSigner.createOutputStream();){
            this.signCMSContainerWithBaselineTProfile(externalSignature, inputDocument, tempOutput, signatureFieldName, cmsContainer);
            try (InputStream inputStream = padesSigner.createInputStream();
                 PdfDocument pdfDocument = new PdfDocument(new PdfReader(inputStream), new PdfWriter(outputStream), new StampingProperties().useAppendMode());){
                padesSigner.performLtvVerification(pdfDocument, Collections.singletonList(signatureFieldName), LtvVerification.RevocationDataNecessity.REQUIRED_FOR_SIGNING_CERTIFICATE);
            }
        }
        finally {
            padesSigner.deleteTempFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signCMSContainerWithBaselineLTAProfile(IExternalSignature externalSignature, PdfReader inputDocument, OutputStream outputStream, String signatureFieldName, CMSContainer cmsContainer) throws Exception {
        PdfPadesSigner padesSigner = this.createPadesSigner(inputDocument, outputStream);
        padesSigner.createRevocationClients(cmsContainer.getSignerInfo().getSigningCertificate(), true);
        try (OutputStream tempOutput = padesSigner.createOutputStream();){
            this.signCMSContainerWithBaselineTProfile(externalSignature, inputDocument, tempOutput, signatureFieldName, cmsContainer);
            try (InputStream inputStream = padesSigner.createInputStream();
                 PdfDocument pdfDocument = new PdfDocument(new PdfReader(inputStream), new PdfWriter(padesSigner.createOutputStream()), new StampingProperties().useAppendMode());){
                padesSigner.performLtvVerification(pdfDocument, Collections.singletonList(signatureFieldName), LtvVerification.RevocationDataNecessity.REQUIRED_FOR_SIGNING_CERTIFICATE);
                padesSigner.performTimestamping(pdfDocument, outputStream, this.tsaClient);
            }
        }
        finally {
            padesSigner.deleteTempFiles();
        }
    }

    private byte[] setSignatureAlgorithmAndSignature(IExternalSignature externalSignature, CMSContainer cmsContainer) throws IOException, GeneralSecurityException {
        String signatureDigest = externalSignature.getDigestAlgorithmName();
        String containerDigest = cmsContainer.getDigestAlgorithm().getAlgorithmOid();
        String providedSignatureAlgorithm = externalSignature.getSignatureAlgorithmName();
        if (!DigestAlgorithms.getAllowedDigest(signatureDigest).equals(containerDigest)) {
            throw new PdfException(MessageFormatUtil.format("Digest algorithm used in the provided IExternalSignature shall be the same as digest algorithm in the provided CMSContainer. Digest algorithm in CMS container: \"{0}\". Digest algorithm in IExternalSignature: \"{1}\"", DigestAlgorithms.getDigest(containerDigest), signatureDigest));
        }
        ISignatureMechanismParams signatureMechanismParams = externalSignature.getSignatureMechanismParameters();
        if (signatureMechanismParams == null) {
            cmsContainer.getSignerInfo().setSignatureAlgorithm(new AlgorithmIdentifier(SignatureMechanisms.getSignatureMechanismOid(providedSignatureAlgorithm, signatureDigest)));
        } else {
            cmsContainer.getSignerInfo().setSignatureAlgorithm(new AlgorithmIdentifier(SignatureMechanisms.getSignatureMechanismOid(providedSignatureAlgorithm, signatureDigest), signatureMechanismParams.toEncodable().toASN1Primitive()));
        }
        byte[] signedAttributes = cmsContainer.getSerializedSignedAttributes();
        byte[] signature = externalSignature.sign(signedAttributes);
        cmsContainer.getSignerInfo().setSignature(signature);
        return signature;
    }

    private PdfPadesSigner createPadesSigner(PdfReader inputDocument, OutputStream outputStream) {
        PdfPadesSigner padesSigner = new PdfPadesSigner(inputDocument, outputStream);
        padesSigner.setOcspClient(this.ocspClient);
        padesSigner.setCrlClient(this.crlClient);
        padesSigner.setStampingProperties(this.stampingProperties);
        padesSigner.setTemporaryDirectoryPath(this.temporaryDirectoryPath);
        padesSigner.setTimestampSignatureName(this.timestampSignatureName);
        padesSigner.setIssuingCertificateRetriever(this.issuingCertificateRetriever);
        padesSigner.setEstimatedSize(this.estimatedSize);
        return padesSigner;
    }
}

