/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable;

import com.lyris.signarstandaloneintegrable.AppConstants;
import com.lyris.signarstandaloneintegrable.configs.AppConfig;
import com.lyris.signarstandaloneintegrable.controllers.UIController;
import com.lyris.signarstandaloneintegrable.tasks.DocumentLoadingTask;
import com.lyris.signarstandaloneintegrable.tasks.KeyStoreLoadingTask;
import com.lyris.signarstandaloneintegrable.tasks.LicenseLoadingTask;
import com.lyris.signarstandaloneintegrable.utils.AlertUtils;
import com.lyris.signarstandaloneintegrable.utils.LogUtils;
import com.lyris.signarstandaloneintegrable.utils.ThreadUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.http.HttpClient;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.apache.commons.codec.digest.DigestUtils;

public class App
extends Application {
    private final UIController uiController = UIController.getInstance();
    private final HttpClient http = HttpClient.newBuilder().build();
    private AppConfig appConfig;

    public static void main(String[] args) {
        App.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            this.createDirectoriesAndFiles();
            this.uiController.createAndShowUI(stage);
            this.executeLicenseLoadingTask();
        }
        catch (Exception e) {
            AlertUtils.showAndWaitUnexpectedErrorAlert(e, "iniciar la aplicaci\u00f3n");
        }
    }

    private void createDirectoriesAndFiles() {
        List<String> directories = List.of(AppConstants.LYRIS_DIR, AppConstants.LYRIS_LICENSE_DIR, AppConstants.LYRIS_DOWNLOAD_DIR, AppConstants.LYRIS_SIGNED_DIR, AppConstants.LYRIS_LOG_DIR);
        for (String directory : directories) {
            try {
                Files.createDirectory(Path.of(directory, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                if (e instanceof FileAlreadyExistsException) continue;
                AlertUtils.showAndWaitUnexpectedErrorAlert(e, "crear los directorios y archivos de la aplicaci\u00f3n");
            }
        }
        try {
            Files.createFile(Path.of(AppConstants.LYRIS_DEVICE_PROPS_FILE, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            if (e instanceof FileAlreadyExistsException) {
                return;
            }
            AlertUtils.showAndWaitUnexpectedErrorAlert(e, "crear los directorios y archivos de la aplicaci\u00f3n");
        }
        try (FileOutputStream os = new FileOutputStream(AppConstants.LYRIS_DEVICE_PROPS_FILE);){
            Properties props = new Properties();
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            props.setProperty("os", osName);
            props.setProperty("arch", osArch);
            props.setProperty("id", DigestUtils.sha256Hex(String.format("%d,%s,%s", Instant.now().toEpochMilli(), osName, osArch)));
            props.store(os, null);
        }
        catch (IOException e) {
            AlertUtils.showAndWaitUnexpectedErrorAlert(e, "crear los directorios y archivos de la aplicaci\u00f3n");
        }
    }

    private void executeLicenseLoadingTask() {
        List<String> arguments = this.getParameters().getRaw();
        if (arguments.size() != 1) {
            Platform.exit();
        }
        LogUtils.info("Loading license");
        String argument = arguments.get(0).replaceAll("'", "").replaceAll("\"", "").replaceFirst("signarint:", "").replaceAll("/$", "");
        LicenseLoadingTask task = new LicenseLoadingTask(new String(Base64.getDecoder().decode(argument)));
        task.setOnSucceeded(event -> {
            LogUtils.info("License loaded");
            this.appConfig = (AppConfig)task.getValue();
            this.uiController.setTemplateId(this.appConfig.getTemplateId());
            this.uiController.setSignatureConfig(this.appConfig.getSignatureConfig());
            this.uiController.setDocumentDestinationConfig(this.appConfig.getDocumentDestinationConfig());
            this.uiController.fillComboKeyStoreSources(this.appConfig.getKeyStoreConfig().getSources());
            this.executeKeyStoreLoadingTask();
        });
        task.setOnFailed(event -> AlertUtils.showAndWaitUnexpectedErrorAlert(task.getException(), "procesar la licencia"));
        this.uiController.bindProgressProperties(task);
        ThreadUtils.createAndStartThread(task);
    }

    private void executeKeyStoreLoadingTask() {
        LogUtils.info("Loading key store");
        KeyStoreLoadingTask task = new KeyStoreLoadingTask(this.http, this.appConfig.getKeyStoreConfig());
        task.setOnSucceeded(event -> {
            LogUtils.info("Key store loaded");
            this.uiController.setKeyStoreDownloadPath(task.getDownloadPath());
            this.uiController.enablePassword();
            this.executeDocumentLoadingTask();
        });
        task.setOnFailed(event -> AlertUtils.showAndWaitUnexpectedErrorAlert(task.getException(), "configurar/obtener el almac\u00e9n de claves"));
        this.uiController.bindProgressProperties(task);
        ThreadUtils.createAndStartThread(task);
    }

    private void executeDocumentLoadingTask() {
        LogUtils.info("Loading documents");
        DocumentLoadingTask task = new DocumentLoadingTask(this.http, this.appConfig.getDocumentOriginConfig());
        task.setOnSucceeded(event -> {
            LogUtils.info("Documents loaded");
            this.uiController.enableSigning();
        });
        task.setOnFailed(event -> AlertUtils.showAndWaitUnexpectedErrorAlert(task.getException(), "obtener los documentos"));
        this.uiController.bindProgressProperties(task);
        this.uiController.bindTableDocuments(task.documentsProperty());
        ThreadUtils.createAndStartThread(task);
    }
}

