/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.configs;

import com.itextpdf.kernel.geom.Rectangle;
import com.lyris.signarstandaloneintegrable.configs.SignatureMode;
import com.lyris.signarstandaloneintegrable.configs.SignaturePage;
import com.lyris.signarstandaloneintegrable.configs.SignaturePosition;
import com.lyris.signarstandaloneintegrable.exceptions.PageNumberOutOfRangeException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class SignatureConfig {
    private static final float RECTANGLE_WIDTH = 250.0f;
    private static final float RECTANGLE_HEIGHT = 50.0f;
    private static final float RECTANGLE_MARGIN = 25.0f;
    private static final String TEXT_CN_FLAG = "$CN$";
    private static final String TEXT_DATETIME_FLAG = "$DATETIME$";
    private final SignatureMode mode;
    private Integer existingSheetPageNumber;
    private SignaturePage existingSheetPage;
    private Float[] existingSheetCoordinates;
    private SignaturePosition existingSheetPosition;
    private String text;

    public SignatureConfig(SignatureMode mode) {
        this.mode = mode;
    }

    public SignatureMode getMode() {
        return this.mode;
    }

    public Integer getExistingSheetPageNumber() {
        return this.existingSheetPageNumber;
    }

    public void setExistingSheetPageNumber(Integer existingSheetPageNumber) {
        this.existingSheetPageNumber = existingSheetPageNumber;
    }

    public SignaturePage getExistingSheetPage() {
        return this.existingSheetPage;
    }

    public void setExistingSheetPage(SignaturePage existingSheetPage) {
        this.existingSheetPage = existingSheetPage;
    }

    public Float[] getExistingSheetCoordinates() {
        return this.existingSheetCoordinates;
    }

    public void setExistingSheetCoordinates(Float[] existingSheetCoordinates) {
        this.existingSheetCoordinates = existingSheetCoordinates;
    }

    public SignaturePosition getExistingSheetPosition() {
        return this.existingSheetPosition;
    }

    public void setExistingSheetPosition(SignaturePosition existingSheetPosition) {
        this.existingSheetPosition = existingSheetPosition;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isVisible() {
        return this.mode != SignatureMode.INVISIBLE;
    }

    public Integer getPageNumber(int numberOfPages) throws PageNumberOutOfRangeException {
        if (this.existingSheetPageNumber != null) {
            if (this.existingSheetPageNumber < 1 || this.existingSheetPageNumber > numberOfPages) {
                throw new PageNumberOutOfRangeException(this.existingSheetPageNumber, numberOfPages);
            }
            return this.existingSheetPageNumber;
        }
        if (this.existingSheetPage != null) {
            switch (this.existingSheetPage) {
                case FIRST: {
                    return 1;
                }
                case LAST: {
                    return numberOfPages;
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public Rectangle getRectangle(float pageWidth, float pageHeight) {
        Float[] coords = this.existingSheetCoordinates;
        if (coords != null) {
            return new Rectangle(coords[0].floatValue(), coords[1].floatValue(), coords[2].floatValue(), coords[3].floatValue());
        }
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, 250.0f, 50.0f);
        switch (this.existingSheetPosition) {
            case BOTTOM_CENTER: {
                rectangle.setX((pageWidth - 250.0f) / 2.0f);
                rectangle.setY(25.0f);
                break;
            }
            case BOTTOM_LEFT: {
                rectangle.setX(25.0f);
                rectangle.setY(25.0f);
                break;
            }
            case BOTTOM_RIGHT: {
                rectangle.setX(pageWidth - 25.0f - 250.0f);
                rectangle.setY(25.0f);
                break;
            }
            case CENTER_CENTER: {
                rectangle.setX((pageWidth - 250.0f) / 2.0f);
                rectangle.setY((pageHeight - 50.0f) / 2.0f);
                break;
            }
            case CENTER_LEFT: {
                rectangle.setX(25.0f);
                rectangle.setY((pageHeight - 50.0f) / 2.0f);
                break;
            }
            case CENTER_RIGHT: {
                rectangle.setX(pageWidth - 25.0f - 250.0f);
                rectangle.setY((pageHeight - 50.0f) / 2.0f);
                break;
            }
            case TOP_CENTER: {
                rectangle.setX((pageWidth - 250.0f) / 2.0f);
                rectangle.setY(pageHeight - 25.0f - 50.0f);
                break;
            }
            case TOP_LEFT: {
                rectangle.setX(25.0f);
                rectangle.setY(pageHeight - 25.0f - 50.0f);
                break;
            }
            case TOP_RIGHT: {
                rectangle.setX(pageWidth - 25.0f - 250.0f);
                rectangle.setY(pageHeight - 25.0f - 50.0f);
            }
        }
        return rectangle;
    }

    public String getText(JcaX509CertificateHolder signingCertificateHolder) {
        if (this.text.contains(TEXT_CN_FLAG)) {
            this.text = this.text.replace(TEXT_CN_FLAG, IETFUtils.valueToString(signingCertificateHolder.getSubject().getRDNs(BCStyle.CN)[0].getFirst().getValue()));
        }
        if (this.text.contains(TEXT_DATETIME_FLAG)) {
            this.text = this.text.replace(TEXT_DATETIME_FLAG, OffsetDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")));
        }
        return this.text;
    }
}

