/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.controllers;

import com.lyris.signarstandaloneintegrable.configs.DocumentDestinationConfig;
import com.lyris.signarstandaloneintegrable.configs.KeyStoreSource;
import com.lyris.signarstandaloneintegrable.configs.SignatureConfig;
import com.lyris.signarstandaloneintegrable.exceptions.TokenNotFoundException;
import com.lyris.signarstandaloneintegrable.models.Document;
import com.lyris.signarstandaloneintegrable.models.KeyStoreEntry;
import com.lyris.signarstandaloneintegrable.tasks.DocumentSigningTask;
import com.lyris.signarstandaloneintegrable.tasks.DocumentTransferTask;
import com.lyris.signarstandaloneintegrable.tasks.FootprintRecordTask;
import com.lyris.signarstandaloneintegrable.tasks.KeyStoreAccessTask;
import com.lyris.signarstandaloneintegrable.utils.AlertUtils;
import com.lyris.signarstandaloneintegrable.utils.LogUtils;
import com.lyris.signarstandaloneintegrable.utils.ThreadUtils;
import com.lyris.signarstandaloneintegrable.views.KeyStoreEntrySelectionDialog;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.PasswordField;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.Pair;
import javax.security.auth.login.FailedLoginException;

public class UIController {
    private static UIController instance;
    private final ComboBox<Pair<String, KeyStoreSource>> comboKeyStoreSources = new ComboBox();
    private final PasswordField fieldPassword = new PasswordField();
    private final Label labelPasswordError = new Label();
    private final TableView<Document> tableDocuments = new TableView();
    private final ProgressBar progressBar = new ProgressBar();
    private final Label labelProgress = new Label();
    private final Button buttonSign = new Button("Firmar");
    private String templateId;
    private SignatureConfig signatureConfig;
    private DocumentDestinationConfig documentDestinationConfig;
    private Path keyStoreDownloadPath;
    private boolean isSigningEnabled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIController getInstance() {
        if (instance != null) return instance;
        Class<UIController> clazz = UIController.class;
        synchronized (UIController.class) {
            if (instance != null) return instance;
            instance = new UIController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setSignatureConfig(SignatureConfig signatureConfig) {
        this.signatureConfig = signatureConfig;
    }

    public void setDocumentDestinationConfig(DocumentDestinationConfig documentDestinationConfig) {
        this.documentDestinationConfig = documentDestinationConfig;
    }

    public void setKeyStoreDownloadPath(Path path) {
        this.keyStoreDownloadPath = path;
    }

    public void createAndShowUI(Stage stage) {
        LogUtils.info("Creating UI");
        this.comboKeyStoreSources.setPrefWidth(165.0);
        Callback comboKeyStoreSourcesFactory = lv -> new ListCell<Pair<String, KeyStoreSource>>(){

            @Override
            protected void updateItem(Pair<String, KeyStoreSource> item, boolean empty) {
                super.updateItem(item, empty);
                this.setText(empty ? "" : item.getKey());
            }
        };
        this.comboKeyStoreSources.setCellFactory(comboKeyStoreSourcesFactory);
        this.comboKeyStoreSources.setButtonCell(comboKeyStoreSourcesFactory.call(null));
        GridPane gridPassword = new GridPane(10.0, 5.0);
        gridPassword.add(new Label("Ingrese la contrase\u00f1a de su certificado:"), 1, 0);
        gridPassword.add(this.comboKeyStoreSources, 0, 1);
        gridPassword.add(this.fieldPassword, 1, 1);
        gridPassword.add(this.labelPasswordError, 2, 1);
        this.fieldPassword.setDisable(true);
        this.fieldPassword.prefWidthProperty().bind(gridPassword.widthProperty().multiply(0.4));
        this.fieldPassword.textProperty().addListener((obs, s1, s2) -> this.labelPasswordError.setText(null));
        this.fieldPassword.setOnKeyPressed(event -> this.handleEnterEvent((KeyEvent)event));
        this.labelPasswordError.setStyle("-fx-text-fill: #CC0000;");
        TableColumn columnTitle = new TableColumn("Documentos");
        TableColumn columnName = new TableColumn("Nombre");
        TableColumn columnType = new TableColumn("Tipo");
        TableColumn columnSize = new TableColumn("Peso (kb)");
        columnName.setCellValueFactory(new PropertyValueFactory("name"));
        columnType.setCellValueFactory(new PropertyValueFactory("type"));
        columnSize.setCellValueFactory(new PropertyValueFactory("size"));
        columnName.prefWidthProperty().bind(this.tableDocuments.widthProperty().multiply(0.7));
        columnType.prefWidthProperty().bind(this.tableDocuments.widthProperty().multiply(0.1));
        columnSize.prefWidthProperty().bind(this.tableDocuments.widthProperty().multiply(0.2));
        columnName.setResizable(false);
        columnType.setResizable(false);
        columnSize.setResizable(false);
        columnName.setStyle("-fx-alignment: center-left; -fx-padding: 0 0 0 15;");
        columnType.setStyle("-fx-alignment: center;");
        columnSize.setStyle("-fx-alignment: center-right; -fx-padding: 0 20 0 0;");
        columnTitle.getColumns().add(columnName);
        columnTitle.getColumns().add(columnType);
        columnTitle.getColumns().add(columnSize);
        this.tableDocuments.getColumns().add(columnTitle);
        this.tableDocuments.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.tableDocuments.setFocusTraversable(false);
        VBox.setVgrow(this.tableDocuments, Priority.ALWAYS);
        HBox boxProgress = new HBox(this.progressBar, this.labelProgress);
        boxProgress.setSpacing(5.0);
        this.buttonSign.setOnMouseClicked(event -> this.handleSigningEvent());
        this.buttonSign.setOnKeyPressed(event -> this.handleEnterEvent((KeyEvent)event));
        this.buttonSign.setStyle("-fx-base: -fx-default-button;");
        ButtonBar.setButtonData(this.buttonSign, ButtonBar.ButtonData.OK_DONE);
        Button buttonCancel = new Button("Cancelar");
        ButtonBar.setButtonData(buttonCancel, ButtonBar.ButtonData.CANCEL_CLOSE);
        buttonCancel.setOnMouseClicked(event -> {
            Optional<ButtonType> result = AlertUtils.showAndWaitConfirmationAlert("Cancelar operaci\u00f3n", "\u00bfEst\u00e1 seguro de que desea cancelar la operaci\u00f3n y abandonar la aplicaci\u00f3n?");
            if (result.get() == ButtonType.OK) {
                Platform.exit();
            }
        });
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.getButtons().addAll((Node[])new Node[]{this.buttonSign, buttonCancel});
        HBox.setHgrow(buttonBar, Priority.ALWAYS);
        VBox box = new VBox(gridPassword, this.tableDocuments, new Separator(), new HBox(boxProgress, buttonBar));
        box.setSpacing(10.0);
        box.setStyle(String.format("%s; -fx-font-size: 14; -fx-padding: 10;", "-fx-accent: #599CD3; -fx-default-button: #A5E8FF; -fx-focus-color: #73B6ED; -fx-faint-focus-color: #73B6ED22"));
        stage.setScene(new Scene(box, 710.0, 460.0));
        stage.getIcons().add(new Image(this.getClass().getClassLoader().getResourceAsStream("app.png")));
        stage.setTitle("Firmador Signar 3.0.0");
        stage.show();
        LogUtils.info("UI created");
    }

    public void fillComboKeyStoreSources(List<KeyStoreSource> keyStoreSources) {
        ArrayList<Pair<String, KeyStoreSource>> pairs = new ArrayList<Pair<String, KeyStoreSource>>();
        for (KeyStoreSource source : keyStoreSources) {
            switch (source) {
                case USB_TOKEN: {
                    pairs.add(new Pair<String, KeyStoreSource>("Token USB", KeyStoreSource.USB_TOKEN));
                    break;
                }
                case REMOTE: {
                    pairs.add(new Pair<String, KeyStoreSource>("Remoto", KeyStoreSource.REMOTE));
                    break;
                }
                case BUILT_IN: {
                    pairs.add(new Pair<String, KeyStoreSource>("Incorporado (test)", KeyStoreSource.BUILT_IN));
                }
            }
        }
        this.comboKeyStoreSources.getItems().addAll((Collection<Pair<String, KeyStoreSource>>)pairs);
        this.comboKeyStoreSources.setValue((Pair)pairs.get(0));
    }

    public void enablePassword() {
        this.fieldPassword.setDisable(false);
        this.fieldPassword.requestFocus();
    }

    public void enableSigning() {
        this.isSigningEnabled = true;
    }

    public void bindProgressProperties(Task<?> task) {
        this.buttonSign.disableProperty().bind(task.runningProperty());
        this.progressBar.visibleProperty().bind(task.runningProperty());
        this.progressBar.progressProperty().bind(task.progressProperty());
        this.labelProgress.visibleProperty().bind(task.runningProperty());
        this.labelProgress.textProperty().bind(task.messageProperty());
    }

    public void bindTableDocuments(ReadOnlyObjectProperty<ObservableList<Document>> documents) {
        this.tableDocuments.itemsProperty().bind(documents);
    }

    private UIController() {
    }

    private void handleEnterEvent(KeyEvent event) {
        if (event.getCode() == KeyCode.ENTER) {
            this.handleSigningEvent();
        }
    }

    private void handleSigningEvent() {
        if (!this.isSigningEnabled) {
            return;
        }
        String pin = this.fieldPassword.getText();
        if (pin == null || pin.isBlank()) {
            this.labelPasswordError.setText("Debes ingresar la contrase\u00f1a");
            this.fieldPassword.requestFocus();
            return;
        }
        this.executeKeyStoreAccessTask(pin);
    }

    private void executeKeyStoreAccessTask(String pin) {
        LogUtils.info("Accessing the key store");
        KeyStoreAccessTask task = new KeyStoreAccessTask((KeyStoreSource)((Object)((Pair)this.comboKeyStoreSources.getValue()).getValue()), pin, this.keyStoreDownloadPath);
        task.setOnSucceeded(event -> {
            LogUtils.info("Key store accessed");
            List entries = (List)task.getValue();
            if (entries.isEmpty()) {
                AlertUtils.showAndWaitErrorAlert("No se encontraron certificados", "No se encontraron certificados para firma en su dispositivo.");
                return;
            }
            new KeyStoreEntrySelectionDialog(entries).showAndWait().ifPresent(keyStoreEntry -> this.executeDocumentSigningTask((KeyStoreEntry)keyStoreEntry, task.getProvider()));
        });
        task.setOnFailed(event -> {
            boolean p12PasswordIsWrong;
            Throwable cause3;
            Throwable cause2;
            Throwable exception = task.getException();
            Throwable cause = exception.getCause();
            if (exception instanceof TokenNotFoundException || exception instanceof ProviderException && exception.getMessage().equals("Token has been removed")) {
                AlertUtils.showAndWaitErrorAlert(exception, "Token no detectado", "Aseg\u00farese de tener el dispositivo conectado e intente nuevamente. Si el problema persiste, puede que necesite instalar un controlador para su token, p\u00f3ngase en contacto con un referente inform\u00e1tico.");
                return;
            }
            boolean tokenPasswordIsWrong = false;
            if (exception instanceof KeyStoreException && cause != null && cause instanceof IOException && (cause2 = cause.getCause()) != null && cause2 instanceof FailedLoginException && (cause3 = cause2.getCause()) != null && cause3.getMessage().equals("CKR_PIN_INCORRECT")) {
                tokenPasswordIsWrong = true;
            }
            boolean bl = p12PasswordIsWrong = exception instanceof IOException && cause != null && cause instanceof UnrecoverableKeyException;
            if (tokenPasswordIsWrong || p12PasswordIsWrong) {
                AlertUtils.showAndWaitErrorAlert(exception, "Contrase\u00f1a incorrecta", "Vuelva a escribir la contrase\u00f1a e intente nuevamente.");
                this.fieldPassword.clear();
                this.fieldPassword.requestFocus();
                return;
            }
            AlertUtils.showAndWaitUnexpectedErrorAlert(task.getException(), "acceder al almac\u00e9n de claves");
        });
        this.bindProgressProperties(task);
        ThreadUtils.createAndStartThread(task);
    }

    private void executeDocumentSigningTask(KeyStoreEntry keyStoreEntry, Provider provider) {
        LogUtils.info("Signing documents");
        DocumentSigningTask task = new DocumentSigningTask(keyStoreEntry, provider, this.tableDocuments.getItems(), this.signatureConfig);
        task.setOnSucceeded(event -> {
            LogUtils.info("Documents signed");
            this.executeFootprintRecordTask((Integer)task.getValue());
        });
        task.setOnFailed(event -> AlertUtils.showAndWaitUnexpectedErrorAlert(task.getException(), "firmar un documento"));
        this.bindProgressProperties(task);
        ThreadUtils.createAndStartThread(task);
    }

    private void executeFootprintRecordTask(Integer signedDocsNumber) {
        LogUtils.info("Registering footprint");
        FootprintRecordTask task = new FootprintRecordTask(this.templateId, signedDocsNumber);
        task.setOnSucceeded(event -> {
            LogUtils.info("Footprint registered");
            this.executeDocumentTransferTask();
        });
        task.setOnFailed(event -> AlertUtils.showAndWaitUnexpectedErrorAlert(task.getException(), "finalizar la firma de documentos"));
        ThreadUtils.createAndStartThread(task);
    }

    private void executeDocumentTransferTask() {
        LogUtils.info("Transferring documents");
        DocumentTransferTask task = new DocumentTransferTask(this.tableDocuments.getItems(), this.documentDestinationConfig);
        task.setOnSucceeded(event -> {
            LogUtils.info("Documents transferred");
            AlertUtils.showAndWaitFinalizationAlert();
        });
        task.setOnFailed(event -> AlertUtils.showAndWaitUnexpectedErrorAlert(task.getException(), "transferir un documento"));
        this.bindProgressProperties(task);
        this.bindTableDocuments(task.documentsProperty());
        ThreadUtils.createAndStartThread(task);
    }
}

