/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.models;

import com.lyris.signarstandaloneintegrable.AppConstants;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public class Document {
    private final File originalFile;
    private final File signedFile;
    private final String name;
    private final String type;
    private final Double size;
    private String remoteId;

    public Document(Path originalPath) {
        this.originalFile = originalPath.toFile();
        this.originalFile.deleteOnExit();
        String fileName = this.originalFile.getName();
        this.signedFile = Path.of(AppConstants.LYRIS_SIGNED_DIR, fileName).toFile();
        this.signedFile.deleteOnExit();
        this.name = fileName.toLowerCase().endsWith(".pdf") ? fileName.substring(0, fileName.length() - 4) : fileName;
        this.type = "PDF";
        this.size = Math.floor((double)this.originalFile.length() / 1024.0 * 100.0) / 100.0;
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    public File getSignedFile() {
        return this.signedFile;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Double getSize() {
        return this.size;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.originalFile, this.remoteId, this.signedFile, this.size, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.originalFile, other.originalFile) && Objects.equals(this.remoteId, other.remoteId) && Objects.equals(this.signedFile, other.signedFile) && Objects.equals(this.size, other.size) && Objects.equals(this.type, other.type);
    }
}

