/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.models;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;

public class KeyStoreEntry {
    private final PrivateKey privateKey;
    private final Certificate[] certificateChain;
    private final X509Certificate x509SigningCertificate;
    private final Map<String, String> oids = new HashMap<String, String>();

    public KeyStoreEntry(PrivateKey privateKey, Certificate[] certificateChain) {
        this.privateKey = privateKey;
        this.certificateChain = certificateChain;
        this.x509SigningCertificate = (X509Certificate)this.certificateChain[0];
        this.oids.put("2.5.4.5", "serialNumber");
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public X509Certificate getX509SigningCertificate() {
        return this.x509SigningCertificate;
    }

    public JcaX509CertificateHolder getSigningCertificateHolder() throws CertificateEncodingException {
        return new JcaX509CertificateHolder(this.x509SigningCertificate);
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.x509SigningCertificate.checkValidity();
    }

    public long getNotAfterMillis() {
        return this.x509SigningCertificate.getNotAfter().getTime();
    }

    public String toString() {
        String format = "%s\n\nEmitido por %s";
        return String.format("%s\n\nEmitido por %s", this.x509SigningCertificate.getSubjectX500Principal().getName("RFC2253", this.oids), this.x509SigningCertificate.getIssuerX500Principal().getName("RFC2253", this.oids));
    }
}

