/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.tasks;

import com.lyris.signarstandaloneintegrable.AppConstants;
import com.lyris.signarstandaloneintegrable.configs.DocumentOriginConfig;
import com.lyris.signarstandaloneintegrable.configs.DocumentOriginSource;
import com.lyris.signarstandaloneintegrable.models.Document;
import com.lyris.signarstandaloneintegrable.utils.FileDownloadHandler;
import com.lyris.signarstandaloneintegrable.utils.LogUtils;
import com.lyris.signarstandaloneintegrable.utils.MiscUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;

public class DocumentLoadingTask
extends Task<Void> {
    private final HttpClient http;
    private final DocumentOriginConfig documentOriginConfig;
    private final ReadOnlyObjectWrapper<ObservableList<Document>> documents = new ReadOnlyObjectWrapper(this, "documents", FXCollections.observableArrayList(new ArrayList()));

    public DocumentLoadingTask(HttpClient http, DocumentOriginConfig documentOriginConfig) {
        this.http = http;
        this.documentOriginConfig = documentOriginConfig;
    }

    public final ObservableList<Document> getDocuments() {
        return (ObservableList)this.documents.get();
    }

    public final ReadOnlyObjectProperty<ObservableList<Document>> documentsProperty() {
        return this.documents.getReadOnlyProperty();
    }

    @Override
    protected Void call() throws Exception {
        DocumentOriginSource source = this.documentOriginConfig.getSource();
        LogUtils.info("Documents origin source: " + String.valueOf((Object)source));
        block0 : switch (source) {
            case LOCAL: {
                break;
            }
            case REMOTE: {
                Map<String, URI> urls = this.documentOriginConfig.getRemoteUrls();
                String[] headers = MiscUtils.mapToArray(this.documentOriginConfig.getRemoteHeaders());
                int size = urls.size();
                int count = 1;
                for (final Map.Entry<String, URI> entry : urls.entrySet()) {
                    if (this.isCancelled()) break block0;
                    this.updateMessage(String.format("Descargando documento (%d/%d)...", count, size));
                    HttpRequest request = HttpRequest.newBuilder().GET().uri(entry.getValue()).headers(headers).build();
                    final HttpResponse<Path> response = this.http.send(request, new FileDownloadHandler(Path.of(AppConstants.LYRIS_DOWNLOAD_DIR, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE));
                    Platform.runLater(new Runnable(){

                        @Override
                        public void run() {
                            Document document = new Document((Path)response.body());
                            document.setRemoteId((String)entry.getKey());
                            ((ObservableList)DocumentLoadingTask.this.documents.get()).add(document);
                        }
                    });
                    this.updateProgress(count++, size);
                }
                break;
            }
        }
        return null;
    }
}

