/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.tasks;

import com.itextpdf.forms.form.element.SignatureFieldAppearance;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.signatures.BouncyCastleDigest;
import com.itextpdf.signatures.PdfSigner;
import com.itextpdf.signatures.PrivateKeySignature;
import com.lyris.signarstandaloneintegrable.configs.SignatureConfig;
import com.lyris.signarstandaloneintegrable.models.Document;
import com.lyris.signarstandaloneintegrable.models.KeyStoreEntry;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.List;
import javafx.concurrent.Task;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DocumentSigningTask
extends Task<Integer> {
    private final KeyStoreEntry keyStore;
    private final List<Document> documents;
    private final SignatureConfig signatureConfig;
    private final Provider provider;

    public DocumentSigningTask(KeyStoreEntry keyStore, Provider provider, List<Document> documents, SignatureConfig signatureConfig) {
        this.keyStore = keyStore;
        this.provider = provider;
        this.documents = documents;
        this.signatureConfig = signatureConfig;
    }

    @Override
    protected Integer call() throws Exception {
        BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();
        Security.addProvider(bouncyCastleProvider);
        String providerName = (this.provider == null ? bouncyCastleProvider : this.provider).getName();
        PrivateKey pk = this.keyStore.getPrivateKey();
        Certificate[] chain = this.keyStore.getCertificateChain();
        int size = this.documents.size();
        int count = 1;
        for (Document document : this.documents) {
            this.updateMessage(String.format("Firmando documento (%d/%d)...", count, size));
            try (PdfReader pdfReader = new PdfReader(document.getOriginalFile());
                 FileOutputStream fos = new FileOutputStream(document.getSignedFile());){
                PdfSigner pdfSigner = new PdfSigner(pdfReader, (OutputStream)fos, System.getProperty("java.io.tmpdir"), new StampingProperties().useAppendMode());
                if (this.signatureConfig.isVisible()) {
                    try (PdfReader pdfReader2 = new PdfReader(document.getOriginalFile());
                         PdfDocument pdfDocument = new PdfDocument(pdfReader2);){
                        Integer pageNumber = this.signatureConfig.getPageNumber(pdfDocument.getNumberOfPages());
                        Rectangle pageSize = pdfDocument.getPage(pageNumber).getPageSize();
                        pdfSigner.setPageNumber(pageNumber);
                        pdfSigner.setPageRect(this.signatureConfig.getRectangle(pageSize.getWidth(), pageSize.getHeight()));
                    }
                    SignatureFieldAppearance appearance = new SignatureFieldAppearance("").setContent(this.signatureConfig.getText(this.keyStore.getSigningCertificateHolder()));
                    pdfSigner.setSignatureAppearance(appearance);
                }
                pdfSigner.signDetached(new BouncyCastleDigest(), new PrivateKeySignature(pk, "SHA-256", providerName), chain, null, null, null, 0, PdfSigner.CryptoStandard.CADES);
            }
            this.updateProgress(count++, size);
        }
        return size;
    }
}

