/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.tasks;

import com.lyris.signarstandaloneintegrable.configs.DocumentDestinationConfig;
import com.lyris.signarstandaloneintegrable.configs.DocumentDestinationSource;
import com.lyris.signarstandaloneintegrable.models.Document;
import com.lyris.signarstandaloneintegrable.utils.FileUploadHandler;
import com.lyris.signarstandaloneintegrable.utils.LogUtils;
import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;

public class DocumentTransferTask
extends Task<Void> {
    private final List<Document> initialDocuments;
    private final DocumentDestinationConfig documentDestinationConfig;
    private final ReadOnlyObjectWrapper<ObservableList<Document>> documents;

    public DocumentTransferTask(ObservableList<Document> documents, DocumentDestinationConfig documentDestinationConfig) {
        this.initialDocuments = documents.stream().toList();
        this.documentDestinationConfig = documentDestinationConfig;
        this.documents = new ReadOnlyObjectWrapper<ObservableList<Document>>(this, "documents", documents);
    }

    public final ObservableList<Document> getDocuments() {
        return (ObservableList)this.documents.get();
    }

    public final ReadOnlyObjectProperty<ObservableList<Document>> documentsProperty() {
        return this.documents.getReadOnlyProperty();
    }

    @Override
    protected Void call() throws Exception {
        DocumentDestinationSource source = this.documentDestinationConfig.getSource();
        LogUtils.info("Documents destination source: " + String.valueOf((Object)source));
        switch (source) {
            case LOCAL: {
                break;
            }
            case REMOTE: {
                Map<String, URI> urls = this.documentDestinationConfig.getRemoteUrls();
                Map<String, String> headers = this.documentDestinationConfig.getRemoteHeaders();
                Map<String, String> extras = this.documentDestinationConfig.getRemoteExtras();
                int size = urls.size();
                int count = 1;
                CloseableHttpClient http = HttpClients.createDefault();
                try {
                    for (final Document document : this.initialDocuments) {
                        if (this.isCancelled()) break;
                        this.updateMessage(String.format("Subiendo documento (%d/%d)...", count, size));
                        File signedFile = document.getSignedFile();
                        MultipartEntityBuilder multipartBuilder = MultipartEntityBuilder.create();
                        String fileFieldName = this.documentDestinationConfig.getRemoteFileFieldName();
                        multipartBuilder.addBinaryBody(fileFieldName != null ? fileFieldName : "file", signedFile, ContentType.APPLICATION_PDF, signedFile.getName());
                        for (Map.Entry<String, String> entry : extras.entrySet()) {
                            multipartBuilder.addTextBody(entry.getKey(), entry.getValue());
                        }
                        HttpPost post = new HttpPost(urls.get(document.getRemoteId()));
                        for (Map.Entry<String, String> header : headers.entrySet()) {
                            post.setHeader(header.getKey(), header.getValue());
                        }
                        post.setEntity(multipartBuilder.build());
                        try (CloseableHttpResponse closeableHttpResponse = (CloseableHttpResponse)http.execute((ClassicHttpRequest)post, new FileUploadHandler());){
                            Platform.runLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((ObservableList)DocumentTransferTask.this.documents.get()).remove(document);
                                }
                            });
                        }
                        this.updateProgress(count++, size);
                    }
                    if (http == null) break;
                }
                catch (Throwable throwable) {
                    if (http != null) {
                        try {
                            http.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                http.close();
                break;
            }
        }
        return null;
    }
}

