/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.tasks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lyris.signarstandaloneintegrable.AppConstants;
import com.lyris.signarstandaloneintegrable.exceptions.StatusCodeUnexpectedException;
import com.lyris.signarstandaloneintegrable.models.footprint.Origin;
import com.lyris.signarstandaloneintegrable.models.footprint.Transaction;
import java.io.FileInputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.util.List;
import java.util.Properties;
import javafx.concurrent.Task;

public class FootprintRecordTask
extends Task<Void> {
    private final HttpClient http = HttpClient.newBuilder().build();
    private final String url = "https://sigtelemetry.signar.com.ar/firmas/registrar";
    private final String templateId;
    private final Integer signedDocsNumber;

    public FootprintRecordTask(String templateId, Integer signedDocsNumber) {
        this.templateId = templateId;
        this.signedDocsNumber = signedDocsNumber;
    }

    @Override
    protected Void call() throws Exception {
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(AppConstants.LYRIS_DEVICE_PROPS_FILE);){
            props.load(is);
        }
        List<Transaction> transactions = List.of(new Transaction(this.templateId, this.signedDocsNumber, Instant.now().getEpochSecond()));
        Origin origin = new Origin(props.getProperty("id"), props.getProperty("arch"), props.getProperty("os"), transactions);
        String[] headers = new String[]{"User-Agent", String.format("SignarStandaloneIntegrable/%s", "3.0.0"), "Content-Type", "application/json"};
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(new ObjectMapper().writeValueAsString(origin))).uri(new URI(this.url)).headers(headers).build();
        HttpResponse<Void> response = this.http.send(request, HttpResponse.BodyHandlers.discarding());
        int statusCode = response.statusCode();
        if (statusCode < 200 || statusCode > 299) {
            throw new StatusCodeUnexpectedException(statusCode);
        }
        return null;
    }
}

