/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.tasks;

import com.lyris.signarstandaloneintegrable.configs.KeyStoreSource;
import com.lyris.signarstandaloneintegrable.exceptions.TokenNotFoundException;
import com.lyris.signarstandaloneintegrable.models.KeyStoreEntry;
import com.lyris.signarstandaloneintegrable.utils.LogUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.concurrent.Task;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.commons.lang3.SystemUtils;

public class KeyStoreAccessTask
extends Task<List<KeyStoreEntry>> {
    private final KeyStoreSource source;
    private final char[] pin;
    private final Path downloadPath;
    private Provider provider;

    public KeyStoreAccessTask(KeyStoreSource source, String pin, Path downloadPath) {
        this.source = source;
        this.pin = pin.toCharArray();
        this.downloadPath = downloadPath;
    }

    public Provider getProvider() {
        return this.provider;
    }

    @Override
    protected List<KeyStoreEntry> call() throws Exception {
        this.updateMessage("Accediendo al almac\u00e9n de claves...");
        KeyStore keyStore = this.getKeyStore();
        this.updateMessage("Obteniendo certificados...");
        ArrayList<KeyStoreEntry> entries = new ArrayList<KeyStoreEntry>();
        KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(this.pin);
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            LogUtils.info("Alias found: " + alias);
            if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
            LogUtils.info("Contains private key");
            entries.add(new KeyStoreEntry(((KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, protParam)).getPrivateKey(), keyStore.getCertificateChain(alias)));
        }
        protParam.destroy();
        return entries;
    }

    private KeyStore getKeyStore() throws Exception {
        LogUtils.info("Selected key store source: " + String.valueOf((Object)this.source));
        switch (this.source) {
            case USB_TOKEN: {
                KeyStore.CallbackHandlerProtection callbackHandlerProtection = new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        if (callbacks.length > 0 && callbacks[0] instanceof PasswordCallback) {
                            ((PasswordCallback)callbacks[0]).setPassword(KeyStoreAccessTask.this.pin);
                        }
                    }
                });
                List<String> osList = List.of("windows", "linux", "mac");
                if (SystemUtils.IS_OS_WINDOWS) {
                    osList = List.of("windows");
                } else if (SystemUtils.IS_OS_LINUX) {
                    osList = List.of("linux");
                } else if (SystemUtils.IS_OS_MAC) {
                    osList = List.of("mac");
                }
                LogUtils.info("OS: " + osList.stream().collect(Collectors.joining(", ")));
                for (String os : osList) {
                    Stream<Path> configPaths = Files.list(Path.of("pkcs11", os)).filter(path -> path.toString().endsWith(".config"));
                    try {
                        for (Path path2 : configPaths.toList()) {
                            Provider provider = Security.getProvider("SunPKCS11").configure(path2.toString());
                            try {
                                KeyStore keyStore = KeyStore.Builder.newInstance("PKCS11", provider, callbackHandlerProtection).getKeyStore();
                                Security.addProvider(provider);
                                this.provider = provider;
                                LogUtils.info("PKCS11 provider found: " + this.provider.getName());
                                KeyStore keyStore2 = keyStore;
                                return keyStore2;
                            }
                            catch (Exception e) {
                                Throwable cause = e.getCause();
                                if (e instanceof KeyStoreException && cause != null && cause instanceof KeyStoreException && cause.getMessage().equals("PKCS11 not found")) continue;
                                throw e;
                            }
                        }
                    }
                    finally {
                        if (configPaths == null) continue;
                        configPaths.close();
                    }
                }
                throw new TokenNotFoundException();
            }
            case REMOTE: {
                KeyStore keyStore = KeyStore.getInstance("PKCS12");
                try (FileInputStream fis = new FileInputStream(this.downloadPath.toString());){
                    keyStore.load(fis, this.pin);
                }
                return keyStore;
            }
            case BUILT_IN: {
                KeyStore builtInKeyStore = KeyStore.getInstance("PKCS12");
                try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("example.p12");){
                    builtInKeyStore.load(is, this.pin);
                }
                return builtInKeyStore;
            }
        }
        return null;
    }
}

