/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.tasks;

import com.lyris.signarstandaloneintegrable.AppConstants;
import com.lyris.signarstandaloneintegrable.configs.KeyStoreConfig;
import com.lyris.signarstandaloneintegrable.configs.KeyStoreSource;
import com.lyris.signarstandaloneintegrable.utils.FileDownloadHandler;
import com.lyris.signarstandaloneintegrable.utils.LogUtils;
import com.lyris.signarstandaloneintegrable.utils.MiscUtils;
import java.io.File;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import javafx.concurrent.Task;

public class KeyStoreLoadingTask
extends Task<Void> {
    private final HttpClient http;
    private final KeyStoreConfig keyStoreConfig;
    private Path downloadPath;

    public KeyStoreLoadingTask(HttpClient http, KeyStoreConfig keyStoreConfig) {
        this.http = http;
        this.keyStoreConfig = keyStoreConfig;
    }

    public Path getDownloadPath() {
        return this.downloadPath;
    }

    @Override
    protected Void call() throws Exception {
        List<KeyStoreSource> sources = this.keyStoreConfig.getSources();
        LogUtils.info("Key store sources: " + sources.stream().map(Enum::toString).collect(Collectors.joining(", ")));
        for (KeyStoreSource source : sources) {
            switch (source) {
                case USB_TOKEN: {
                    break;
                }
                case REMOTE: {
                    this.updateMessage("Descargando almac\u00e9n de claves...");
                    HttpRequest request = HttpRequest.newBuilder().GET().uri(this.keyStoreConfig.getRemoteUrl()).headers(MiscUtils.mapToArray(this.keyStoreConfig.getRemoteHeaders())).build();
                    HttpResponse<Path> response = this.http.send(request, new FileDownloadHandler(Path.of(AppConstants.LYRIS_DOWNLOAD_DIR, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE));
                    File file = response.body().toFile();
                    file.deleteOnExit();
                    this.downloadPath = file.toPath();
                    break;
                }
            }
        }
        return null;
    }
}

