/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.tasks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lyris.signarstandaloneintegrable.AppConstants;
import com.lyris.signarstandaloneintegrable.configs.AppConfig;
import com.lyris.signarstandaloneintegrable.configs.DocumentDestinationConfig;
import com.lyris.signarstandaloneintegrable.configs.DocumentDestinationSource;
import com.lyris.signarstandaloneintegrable.configs.DocumentOriginConfig;
import com.lyris.signarstandaloneintegrable.configs.DocumentOriginSource;
import com.lyris.signarstandaloneintegrable.configs.KeyStoreConfig;
import com.lyris.signarstandaloneintegrable.configs.KeyStoreSource;
import com.lyris.signarstandaloneintegrable.configs.SignatureConfig;
import com.lyris.signarstandaloneintegrable.configs.SignatureMode;
import com.lyris.signarstandaloneintegrable.configs.SignaturePage;
import com.lyris.signarstandaloneintegrable.configs.SignaturePosition;
import com.lyris.signarstandaloneintegrable.exceptions.LicenseException;
import com.lyris.signarstandaloneintegrable.utils.JsonNodeUtils;
import com.lyris.signarstandaloneintegrable.utils.LogUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.concurrent.Task;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class LicenseLoadingTask
extends Task<AppConfig> {
    private final String args;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Pattern patternOfVariable = Pattern.compile("\\{\\{(\\w*)\\}\\}");
    private JsonNode params;
    private JsonNode data;
    private List<String> docIds;
    private AppConfig appConfig;

    public LicenseLoadingTask(String args) {
        this.args = args;
    }

    @Override
    protected AppConfig call() throws Exception {
        JsonNode args = this.objectMapper.readTree(this.args);
        this.params = JsonNodeUtils.getObject("params", args, false);
        this.updateMessage("Obteniendo licencia...");
        JsonNode license = this.getLicense(JsonNodeUtils.getString("url", args, false));
        this.updateMessage("Validando licencia...");
        this.data = JsonNodeUtils.getObject("data", license, false);
        this.validateLicense(JsonNodeUtils.getString("signature", license, false));
        this.updateMessage("Procesando configuraci\u00f3n...");
        JsonNode docIds = JsonNodeUtils.getArray("docIds", this.params, true);
        if (docIds != null) {
            this.docIds = this.objectMapper.convertValue((Object)docIds, new TypeReference<List<String>>(){});
        }
        this.appConfig = new AppConfig(this.processTemplateId(), this.processKeyStore(), this.processDocumentOrigin(), this.processDocumentDestination(), this.processSignature());
        this.processSharedHeaders();
        return this.appConfig;
    }

    private JsonNode getLicense(String url) throws Exception {
        String digest = DigestUtils.sha256Hex(url);
        Path path = Path.of(AppConstants.LYRIS_LICENSE_DIR, digest + ".json");
        if (Files.notExists(path, new LinkOption[0])) {
            try (InputStream is = new URI(url).toURL().openStream();
                 ReadableByteChannel rbc = Channels.newChannel(is);
                 FileOutputStream fos = new FileOutputStream(Files.createFile(path, new FileAttribute[0]).toString());
                 FileChannel fc = fos.getChannel();){
                fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
        }
        LogUtils.info("License digest: " + digest);
        return this.objectMapper.readTree(path.toFile());
    }

    private void validateLicense(String signature) throws Exception {
        Long expiration = JsonNodeUtils.getLong("expiration", JsonNodeUtils.getObject("template", this.data, false), false);
        try (InputStream is = LicenseLoadingTask.class.getClassLoader().getResourceAsStream("key.pub");
             InputStreamReader isr = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(isr);){
            Base64.Decoder decoder = Base64.getDecoder();
            Signature s = Signature.getInstance("SHA256withRSA");
            s.initVerify(KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoder.decode(br.lines().collect(Collectors.joining("\n"))))));
            s.update(this.data.toString().getBytes());
            if (!s.verify(decoder.decode(signature))) {
                throw new LicenseException("The license file is invalid (1).");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new LicenseException("The license file integrity could not be verified.", e);
        }
        catch (LicenseException e) {
            throw e;
        }
        if (System.currentTimeMillis() > expiration) {
            throw new LicenseException("The license file is invalid (2).");
        }
    }

    private String processTemplateId() {
        return JsonNodeUtils.getString("id", JsonNodeUtils.getObject("template", this.data, false), false);
    }

    private KeyStoreConfig processKeyStore() throws Exception {
        JsonNode keyStore = JsonNodeUtils.getObject("keyStore", this.data, false);
        String sources = this.getParsedString(JsonNodeUtils.getString("sources", keyStore, false));
        List<KeyStoreSource> sourcesList = Stream.of(StringUtils.deleteWhitespace(sources).split(",")).map(KeyStoreSource::valueOf).toList();
        if (sourcesList.isEmpty()) {
            throw new LicenseException("At least one element was expected in the 'sources' array of the 'keyStore' object.");
        }
        KeyStoreConfig config = new KeyStoreConfig(sourcesList);
        if (sourcesList.contains((Object)KeyStoreSource.REMOTE)) {
            String remoteUrl = JsonNodeUtils.getString("remoteUrl", keyStore, false);
            config.setRemoteUrl(new URI(this.getParsedString(remoteUrl)));
            JsonNode remoteHeaders = JsonNodeUtils.getObject("remoteHeaders", keyStore, true);
            if (remoteHeaders != null) {
                config.setRemoteHeaders(this.getParsedMap(remoteHeaders));
            }
        }
        return config;
    }

    private DocumentOriginConfig processDocumentOrigin() throws Exception {
        JsonNode documentsOrigin = JsonNodeUtils.getObject("documentsOrigin", this.data, false);
        String source = this.getParsedString(JsonNodeUtils.getString("source", documentsOrigin, false));
        DocumentOriginSource sourceValue = DocumentOriginSource.valueOf(StringUtils.deleteWhitespace(source));
        DocumentOriginConfig config = new DocumentOriginConfig(sourceValue);
        if (sourceValue == DocumentOriginSource.REMOTE) {
            String remoteUrl = this.getParsedString(JsonNodeUtils.getString("remoteUrl", documentsOrigin, false));
            LinkedHashMap<String, URI> remoteUrls = new LinkedHashMap<String, URI>();
            if (remoteUrl.contains("$DOC_ID$")) {
                if (this.docIds == null || this.docIds.isEmpty()) {
                    throw new LicenseException("A value was expected for the 'docIds' array.");
                }
                for (String id : this.docIds) {
                    remoteUrls.put(id, new URI(remoteUrl.replace("$DOC_ID$", id)));
                }
            } else {
                remoteUrls.put("N/A", new URI(remoteUrl));
            }
            config.setRemoteUrls(remoteUrls);
            JsonNode remoteHeaders = JsonNodeUtils.getObject("remoteHeaders", documentsOrigin, true);
            if (remoteHeaders != null) {
                config.setRemoteHeaders(this.getParsedMap(remoteHeaders));
            }
        }
        return config;
    }

    private DocumentDestinationConfig processDocumentDestination() throws Exception {
        JsonNode documentsDestination = JsonNodeUtils.getObject("documentsDestination", this.data, false);
        String source = this.getParsedString(JsonNodeUtils.getString("source", documentsDestination, false));
        DocumentDestinationSource sourceValue = DocumentDestinationSource.valueOf(StringUtils.deleteWhitespace(source));
        DocumentDestinationConfig config = new DocumentDestinationConfig(sourceValue);
        if (sourceValue == DocumentDestinationSource.REMOTE) {
            String remoteFileFieldName;
            JsonNode remoteExtras;
            String remoteUrl = this.getParsedString(JsonNodeUtils.getString("remoteUrl", documentsDestination, false));
            LinkedHashMap<String, URI> remoteUrls = new LinkedHashMap<String, URI>();
            if (remoteUrl.contains("$DOC_ID$")) {
                if (this.docIds == null || this.docIds.isEmpty()) {
                    throw new LicenseException("A value was expected for the 'docIds' array.");
                }
                for (String id : this.docIds) {
                    remoteUrls.put(id, new URI(remoteUrl.replace("$DOC_ID$", id)));
                }
            } else {
                remoteUrls.put("N/A", new URI(remoteUrl));
            }
            config.setRemoteUrls(remoteUrls);
            JsonNode remoteHeaders = JsonNodeUtils.getObject("remoteHeaders", documentsDestination, true);
            if (remoteHeaders != null) {
                config.setRemoteHeaders(this.getParsedMap(remoteHeaders));
            }
            if ((remoteExtras = JsonNodeUtils.getObject("remoteExtras", documentsDestination, true)) != null) {
                config.setRemoteExtras(this.getParsedMap(remoteExtras));
            }
            if ((remoteFileFieldName = JsonNodeUtils.getString("remoteFileFieldName", documentsDestination, true)) != null) {
                config.setRemoteFileFieldName(this.getParsedString(remoteFileFieldName));
            }
        }
        return config;
    }

    private SignatureConfig processSignature() {
        JsonNode signature = JsonNodeUtils.getObject("signature", this.data, false);
        String mode = this.getParsedString(JsonNodeUtils.getString("mode", signature, false));
        SignatureMode modeValue = SignatureMode.valueOf(StringUtils.deleteWhitespace(mode));
        SignatureConfig config = new SignatureConfig(modeValue);
        if (modeValue == SignatureMode.EXISTING_SHEET) {
            String existingSheetPage = StringUtils.deleteWhitespace(this.getParsedString(JsonNodeUtils.getString("existingSheetPage", signature, false)));
            if (StringUtils.isNumeric(existingSheetPage)) {
                config.setExistingSheetPageNumber(Integer.valueOf(existingSheetPage));
            } else {
                config.setExistingSheetPage(SignaturePage.valueOf(existingSheetPage));
            }
            String existingSheetPosition = StringUtils.deleteWhitespace(this.getParsedString(JsonNodeUtils.getString("existingSheetPosition", signature, false)));
            String[] existingSheetPositionSplit = existingSheetPosition.split(",");
            if (existingSheetPositionSplit.length > 1) {
                config.setExistingSheetCoordinates((Float[])Stream.of(existingSheetPositionSplit).map(Float::valueOf).toArray());
            } else {
                config.setExistingSheetPosition(SignaturePosition.valueOf(existingSheetPosition));
            }
            config.setText(this.getParsedString(JsonNodeUtils.getString("text", signature, false)));
        }
        return config;
    }

    private void processSharedHeaders() {
        JsonNode sharedHeaders = JsonNodeUtils.getObject("sharedHeaders", this.data, true);
        if (sharedHeaders == null) {
            return;
        }
        this.appConfig.setSharedHeaders(this.getParsedMap(sharedHeaders));
    }

    private Map<String, String> getParsedMap(JsonNode node) {
        Map<String, String> map = this.objectMapper.convertValue((Object)node, new TypeReference<Map<String, String>>(){});
        HashMap<String, String> parsedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            parsedMap.put(entry.getKey(), this.getParsedString(entry.getValue()));
        }
        return parsedMap;
    }

    private String getParsedString(String value) {
        Matcher matcher = this.patternOfVariable.matcher(value);
        String parsedString = value;
        while (matcher.find()) {
            parsedString = parsedString.replace(matcher.group(0), JsonNodeUtils.getString(matcher.group(1), this.params, false));
        }
        return parsedString;
    }
}

