/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.utils;

import com.lyris.signarstandaloneintegrable.AppConstants;
import java.io.PrintWriter;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import javafx.stage.Window;

public final class AlertUtils {
    private static final String UNEXPECTED_ERROR_MESSAGE = "Se ha producido un error inesperado%s. Si el problema persiste, p\u00f3ngase en contacto con un referente inform\u00e1tico.";

    public static Optional<ButtonType> showAndWaitConfirmationAlert(String header, String content) {
        return AlertUtils.createAlert(Alert.AlertType.CONFIRMATION, header, content).showAndWait();
    }

    public static void showAndWaitErrorAlert(String header, String content) {
        AlertUtils.createAlert(Alert.AlertType.ERROR, header, content).showAndWait();
    }

    public static void showAndWaitErrorAlert(Throwable throwable, String header, String content) {
        AlertUtils.recordStackTrace(throwable);
        AlertUtils.createAlert(Alert.AlertType.ERROR, header, content).showAndWait();
    }

    public static void showAndWaitUnexpectedErrorAlert(Throwable throwable, String extra) {
        AlertUtils.recordStackTrace(throwable);
        String content = String.format(UNEXPECTED_ERROR_MESSAGE, extra != null ? String.format(" al %s", extra) : "");
        AlertUtils.createAlert(Alert.AlertType.ERROR, "Error inesperado", content).showAndWait();
        Platform.exit();
    }

    public static void showAndWaitFinalizationAlert() {
        AlertUtils.createAlert(Alert.AlertType.INFORMATION, "Proceso de firma finalizado", "Los documentos han sido firmados correctamente.").showAndWait();
        Platform.exit();
    }

    private AlertUtils() {
    }

    private static Alert createAlert(Alert.AlertType type, String header, String content) {
        Alert alert = new Alert(type);
        alert.initOwner(Stage.getWindows().stream().filter(Window::isShowing).findFirst().orElse(null));
        alert.setTitle("Firmador Signar 3.0.0");
        alert.setGraphic(AlertUtils.getGraphic(type));
        alert.setHeaderText(header);
        alert.setContentText(content);
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.setMinHeight(Double.NEGATIVE_INFINITY);
        dialogPane.setStyle("-fx-accent: #599CD3; -fx-default-button: #A5E8FF; -fx-focus-color: #73B6ED; -fx-faint-focus-color: #73B6ED22");
        return alert;
    }

    private static ImageView getGraphic(Alert.AlertType type) {
        String icon = null;
        switch (type) {
            case CONFIRMATION: {
                icon = "help.png";
                break;
            }
            case ERROR: {
                icon = "error.png";
                break;
            }
            case INFORMATION: {
                icon = "check.png";
                break;
            }
            case WARNING: {
                icon = "warning.png";
                break;
            }
        }
        if (icon == null) {
            return null;
        }
        ImageView graphic = new ImageView(AlertUtils.class.getClassLoader().getResource(icon).toString());
        graphic.setFitHeight(48.0);
        graphic.setFitWidth(48.0);
        return graphic;
    }

    private static void recordStackTrace(Throwable throwable) {
        try (PrintWriter writer = new PrintWriter(AppConstants.LYRIS_ERROR_FILE);){
            throwable.printStackTrace(writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

