/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.utils;

import com.lyris.signarstandaloneintegrable.exceptions.StatusCodeUnexpectedException;
import java.net.http.HttpResponse;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileDownloadHandler
implements HttpResponse.BodyHandler<Path> {
    private final Path path;
    private final OpenOption[] openOptions;

    public FileDownloadHandler(Path path, OpenOption ... openOptions) {
        this.path = path;
        this.openOptions = openOptions;
    }

    @Override
    public HttpResponse.BodySubscriber<Path> apply(HttpResponse.ResponseInfo responseInfo) {
        int statusCode = responseInfo.statusCode();
        if (statusCode < 200 || statusCode > 299) {
            throw new StatusCodeUnexpectedException(statusCode);
        }
        return HttpResponse.BodyHandlers.ofFileDownload(this.path, this.openOptions).apply(responseInfo);
    }
}

