/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.utils;

import com.fasterxml.jackson.databind.JsonNode;

public final class JsonNodeUtils {
    public static JsonNode getObject(String field, JsonNode node, boolean nullable) {
        try {
            JsonNodeUtils.assertNotNull(field, node);
        }
        catch (IllegalArgumentException e) {
            if (nullable) {
                return null;
            }
            throw e;
        }
        JsonNode value = node.get(field);
        if (!value.isObject()) {
            throw new IllegalArgumentException(String.format("The field '%s' must be of type object.", field));
        }
        return value;
    }

    public static JsonNode getArray(String field, JsonNode node, boolean nullable) {
        try {
            JsonNodeUtils.assertNotNull(field, node);
        }
        catch (IllegalArgumentException e) {
            if (nullable) {
                return null;
            }
            throw e;
        }
        JsonNode value = node.get(field);
        if (!value.isArray()) {
            throw new IllegalArgumentException(String.format("The field '%s' must be of type array.", field));
        }
        return value;
    }

    public static String getString(String field, JsonNode node, boolean nullable) {
        try {
            JsonNodeUtils.assertNotNull(field, node);
        }
        catch (IllegalArgumentException e) {
            if (nullable) {
                return null;
            }
            throw e;
        }
        JsonNode value = node.get(field);
        if (!value.isTextual()) {
            throw new IllegalArgumentException(String.format("The field '%s' must be of type string.", field));
        }
        return value.textValue();
    }

    public static Long getLong(String field, JsonNode node, boolean nullable) {
        try {
            JsonNodeUtils.assertNotNull(field, node);
        }
        catch (IllegalArgumentException e) {
            if (nullable) {
                return null;
            }
            throw e;
        }
        JsonNode value = node.get(field);
        if (!value.isLong()) {
            throw new IllegalArgumentException(String.format("The field '%s' must be of type long.", field));
        }
        return value.longValue();
    }

    private JsonNodeUtils() {
    }

    private static void assertNotNull(String field, JsonNode node) {
        if (!node.hasNonNull(field)) {
            throw new IllegalArgumentException(String.format("The field '%s' is required.", field));
        }
    }
}

