/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.utils;

import com.lyris.signarstandaloneintegrable.AppConstants;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class LogUtils {
    private static final Logger logger = LogUtils.getLogger();

    public static void info(String message) {
        logger.info(message);
    }

    private LogUtils() {
    }

    private static Logger getLogger() {
        try {
            final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss.SSS").withZone(ZoneId.systemDefault());
            Formatter logFormatter = new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return String.format("[%s] %s - %s\n", record.getLevel(), dateFormatter.format(record.getInstant()), record.getMessage());
                }
            };
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.INFO);
            consoleHandler.setFormatter(logFormatter);
            FileHandler fileHandler = new FileHandler(AppConstants.LYRIS_INFO_FILE);
            fileHandler.setLevel(Level.INFO);
            fileHandler.setFormatter(logFormatter);
            Logger logger = Logger.getLogger("SSILogger");
            logger.setUseParentHandlers(false);
            logger.addHandler(consoleHandler);
            logger.addHandler(fileHandler);
            logger.info(String.format("%s / Java %s / JavaFX %s", "Firmador Signar 3.0.0", System.getProperty("java.version"), System.getProperty("javafx.version")));
            return logger;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

