/*
 * Decompiled with CFR 0.152.
 */
package com.lyris.signarstandaloneintegrable.views;

import com.lyris.signarstandaloneintegrable.models.KeyStoreEntry;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;

public class KeyStoreEntrySelectionDialog
extends Dialog<KeyStoreEntry> {
    private static final long MILLIS_CURRENT = System.currentTimeMillis();
    private static final long MILLIS_30_DAYS = 2592000000L;

    public KeyStoreEntrySelectionDialog(List<KeyStoreEntry> entries) {
        ListView<KeyStoreEntry> list = new ListView<KeyStoreEntry>(FXCollections.observableArrayList(entries));
        list.setCellFactory(lv -> new ListCell<KeyStoreEntry>(){

            @Override
            protected void updateItem(KeyStoreEntry item, boolean empty) {
                super.updateItem(item, empty);
                if (empty || item == null) {
                    this.setText(null);
                    this.setGraphic(null);
                    return;
                }
                this.setPrefWidth(lv.getWidth());
                this.setPadding(new Insets(7.5, 5.0, 7.5, 5.0));
                this.setWrapText(true);
                this.setText(String.format("#%d | %s", this.getIndex() + 1, item.toString()));
            }
        });
        Label labelInfo = new Label();
        list.getSelectionModel().selectedItemProperty().addListener((obs, kse1, kse2) -> {
            labelInfo.setText(null);
            labelInfo.setStyle(null);
            try {
                kse2.checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                labelInfo.setStyle("-fx-text-fill: #CC0000;");
                labelInfo.setText(e instanceof CertificateExpiredException ? "El certificado seleccionado est\u00e1 vencido" : "El certificado seleccionado a\u00fan no es v\u00e1lido");
                return;
            }
            if (MILLIS_CURRENT > kse2.getNotAfterMillis() - 2592000000L) {
                labelInfo.setStyle("-fx-text-fill: #FF8800;");
                labelInfo.setText("El certificado seleccionado est\u00e1 por vencer");
            }
        });
        list.getSelectionModel().select(0);
        VBox box = new VBox(new Label("Seleccione el certificado a utilizar:"), list, labelInfo);
        box.setSpacing(5.0);
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContent(box);
        dialogPane.setStyle("-fx-accent: #599CD3; -fx-default-button: #A5E8FF; -fx-focus-color: #73B6ED; -fx-faint-focus-color: #73B6ED22");
        dialogPane.getButtonTypes().addAll((ButtonType[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Button okButton = (Button)dialogPane.lookupButton(ButtonType.OK);
        okButton.addEventFilter(ActionEvent.ACTION, (? super T event) -> {
            try {
                ((KeyStoreEntry)list.getSelectionModel().getSelectedItem()).checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                event.consume();
            }
        });
        this.setResultConverter(bt -> bt == ButtonType.OK ? (KeyStoreEntry)list.getSelectionModel().getSelectedItem() : null);
        this.initOwner(Stage.getWindows().stream().filter(Window::isShowing).findFirst().orElse(null));
        this.setTitle("Firmador Signar 3.0.0");
        this.setHeight(350.0);
        this.setWidth(400.0);
    }
}

