/*
 * Decompiled with CFR 0.152.
 */
package ar.com.lyris.controladores;

import ar.com.gs.controladores.CertController;
import ar.com.gs.controladores.TokenConectadoCallback;
import ar.com.gs.entidades.Certificado;
import ar.com.gs.entidades.Token;
import ar.com.lyris.controladores.WorkerDescargaCert;
import ar.com.lyris.controladores.WorkerDescargaMetadatos;
import ar.com.lyris.controladores.WorkerFirmado;
import ar.com.lyris.controladores.WorkerSubida;
import ar.com.lyris.entidades.Documento;
import ar.com.lyris.entidades.EstadoApp;
import ar.com.lyris.entidades.EstadoDoc;
import ar.com.lyris.entidades.Metadatos;
import ar.com.lyris.entidades.ModoDeEjecucion;
import ar.com.lyris.vistas.Consola;
import ar.com.lyris.vistas.DialogCertificados;
import ar.com.lyris.vistas.ProgressWorker;
import com.google.gson.JsonObject;
import com.sun.jna.Platform;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import kong.unirest.Unirest;

public abstract class PrincipalBase
implements TokenConectadoCallback {
    private Consola frame;
    private String token;
    String urlBase;
    private List<Documento> documentos;
    private String idUsuario;
    public boolean banderaFin;
    public Properties propiedades;
    public String rutaCert;
    public EstadoApp estadoApp;
    private List<Documento> documentosInvalidos;
    private ProgressWorker progressWorker = null;
    public String mensajeErrorSubida = "";
    protected CertController certController;
    public Certificado certificado;
    protected Metadatos metadatos;
    private WorkerFirmado wFirmado;
    public String rutaArchivos = "";
    public boolean subidaDesactivada = false;
    public int tiempoDeSleepsDeTesting = 0;
    String rutaCertNube;
    public CountDownLatch frameSignal;
    public static boolean isLinux = System.getProperty("os.name").toLowerCase().indexOf("nux") >= 0;

    public PrincipalBase(String[] args) {
        System.out.println("V1.6");
        this.frameSignal = new CountDownLatch(1);
        this.setProgressWorker(new ProgressWorker(this));
        this.invocarConsola();
        try {
            this.frameSignal.await();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        this.inicializarVariables();
        System.out.println("cargando los argumentos");
        try {
            this.cargarArgumentos(args);
        }
        catch (Exception e) {
            e.getStackTrace();
            this.getFrame().informarFallo("Problema al cargar argumentos");
            this.finalizar(1);
        }
        this.inicializarProxy();
    }

    protected void inicializarProxy() {
        if (Platform.isWindows()) {
            Proxy proxy = Proxy.NO_PROXY;
            List<Proxy> proxies = null;
            if (ProxySelector.getDefault() != null) {
                try {
                    proxies = ProxySelector.getDefault().select(new URI("https://signar.com.ar"));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (proxies != null) {
                block6: for (Proxy p : proxies) {
                    switch (p.type()) {
                        case HTTP: {
                            proxy = p;
                            System.out.println("HTTP PROXY");
                            break block6;
                        }
                        case DIRECT: {
                            proxy = p;
                            System.out.println("DIRECT PROXY");
                        }
                        default: {
                            continue block6;
                        }
                    }
                }
            }
            System.out.println("1. " + proxy);
            System.out.println("2. " + proxy.address());
            System.out.println("3. " + (Object)((Object)proxy.type()));
            if (proxy.address() != null) {
                System.out.println(((InetSocketAddress)proxy.address()).getPort());
                System.out.println(((InetSocketAddress)proxy.address()).getHostName());
                Unirest.config().proxy(((InetSocketAddress)proxy.address()).getHostName(), ((InetSocketAddress)proxy.address()).getPort());
            }
        }
    }

    private void inicializarVariables() {
        this.estadoApp = EstadoApp.EN_ESPERA;
        this.banderaFin = false;
        this.propiedades = null;
        this.progressWorker = null;
        this.documentosInvalidos = new ArrayList<Documento>();
        this.documentos = new ArrayList<Documento>();
    }

    private void invocarConsola() {
        final PrincipalBase p = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PrincipalBase.this.frame = new Consola(p);
                    PrincipalBase.this.frame.setVisible(true);
                    PrincipalBase.this.getProgressWorker().setPBar();
                    PrincipalBase.this.getProgressWorker().execute();
                    p.frameSignal.countDown();
                }
                catch (FontFormatException | IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    void guardarPropiedades() throws IOException {
        System.out.println(this.rutaCert);
        System.out.println(this.getFrame().getTextCert());
        if (this.rutaCert == null || !this.rutaCert.equals(this.getFrame().getTextCert())) {
            String dirName = String.valueOf(System.getProperty("user.home")) + File.separator + ".lyris";
            File theDir = new File(dirName);
            if (!theDir.exists()) {
                System.out.println("creating directory: " + dirName);
                boolean result = false;
                try {
                    theDir.mkdir();
                    result = true;
                }
                catch (SecurityException se) {
                    se.printStackTrace();
                }
                if (result) {
                    System.out.println("DIR created");
                }
            }
            if (this.propiedades == null) {
                this.propiedades = new Properties();
            }
            FileOutputStream output = null;
            output = new FileOutputStream(String.valueOf(dirName) + File.separator + "config.properties");
            if (!this.rutaArchivos.equals("")) {
                this.propiedades.setProperty(String.valueOf(this.getMetadatos().getUsuario().getAcceso()) + ".rutaArchivos", this.rutaArchivos);
            }
            this.propiedades.store(output, null);
        }
    }

    protected void cargarPropiedades() {
        String dir = System.getProperty("user.home");
        Properties props = new Properties();
        InputStream is = null;
        try {
            File f = new File(String.valueOf(dir) + "/.lyris/config.properties");
            is = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            is = null;
        }
        try {
            if (is == null) {
                is = this.getClass().getResourceAsStream("config.properties");
            }
            props.load(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.propiedades = props;
        System.out.println(props);
        System.out.println(this.getMetadatos().getUsuario().getAcceso());
        this.rutaCert = props.getProperty(String.valueOf(this.getMetadatos().getUsuario().getAcceso()) + ".rutacert", null);
        this.rutaArchivos = props.getProperty(String.valueOf(this.getMetadatos().getUsuario().getAcceso()) + ".rutaArchivos", "");
        this.getFrame().setTextCert(this.rutaCert);
        System.out.println(this.rutaCert);
    }

    public void cargarArgumentos(String[] args) throws Exception {
        System.out.println(args.length);
        if (args.length == 1) {
            System.out.println(args[0]);
            args = args[0].split(";");
        }
        if (args.length == 3) {
            this.token = args[0];
            this.urlBase = args[1];
            this.idUsuario = args[2];
        } else {
            this.getFrame().informarFallo("Argumentos insuficientes.");
            this.finalizar(1);
        }
    }

    public void finalizar(int status) {
        Unirest.shutDown();
        System.exit(status);
    }

    public void certificadoSeleccionado() {
        this.wFirmado = new WorkerFirmado(this);
        this.wFirmado.execute();
    }

    public void firmar() {
        this.estadoApp = EstadoApp.FIRMANDO;
        this.certController.finalizarBusquedaTokens();
        try {
            String pathCert = null;
            if (this.getFrame().tokenDeSoftwareSeleccionado()) {
                if (this.getFrame().MSCAPISeleccionado()) {
                    this.certController.setMSCAPI(true);
                } else if (this.getFrame().esUbicacionCertEnServer()) {
                    pathCert = this.getMetadatos().rutaCertEnServer();
                } else if (this.getFrame().esUbicacionCertEnSignar()) {
                    WorkerDescargaCert w = new WorkerDescargaCert(this);
                    w.execute();
                    w.get();
                    pathCert = this.rutaCertNube;
                } else {
                    pathCert = this.getFrame().getPathTokenSoftware();
                }
                this.certController.initKeystore("SW", this.frame.getPassword(), pathCert);
            } else {
                this.certController.initKeystore("HW", this.frame.getPassword(), this.getFrame().getProviderDeTokenSeleccionado());
            }
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this.getFrame(), e1.getMessage(), "Error Grave", 0);
            e1.printStackTrace();
            this.frame.habilitarFirmado();
            return;
        }
        final PrincipalBase p = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DialogCertificados(p).setVisible(true);
            }
        });
    }

    public void finFirmado() {
        try {
            int finalizados = 0;
            for (Documento doc : this.getDocumentos()) {
                System.out.println(String.valueOf(doc.getPrintableFileName()) + " " + (Object)((Object)doc.getEstado()));
                if (!doc.getEstado().equals((Object)EstadoDoc.FIRMADO)) continue;
                ++finalizados;
            }
            System.out.println("finalizados: " + finalizados);
            if (this.documentosInvalidos.size() > 0) {
                String mensajeDocsInvalidos = "Los siguientes archivos fueron quitados de la lista por estar protegidos contra escritura:\n";
                for (Documento doc : this.documentosInvalidos) {
                    mensajeDocsInvalidos = String.valueOf(mensajeDocsInvalidos) + doc.getPrintableFileName();
                }
                this.getFrame().informarFallo(mensajeDocsInvalidos);
            }
            if (finalizados == 0) {
                this.getFrame().informarFallo("No quedan documentos firmados por subir, compruebe el error y/o reintente mas tarde.");
                this.finalizar(1);
            }
            this.estadoApp = EstadoApp.SUBIENDO;
            this.getFrame().refrescarTabla();
            if (!this.subidaDesactivada) {
                WorkerSubida wSubida = new WorkerSubida(this);
                this.finalizarProgressWorker();
                this.getFrame().progresoCompleto();
                this.setProgressWorker(new ProgressWorker(this));
                this.getProgressWorker().execute();
                wSubida.execute();
                wSubida.get();
                this.guardarPropiedades();
            }
            finalizados = 0;
            for (Documento doc : this.getDocumentos()) {
                if (!doc.getEstado().equals((Object)EstadoDoc.SUBIDO)) continue;
                ++finalizados;
            }
            if (finalizados == this.getCantDocumentos()) {
                this.getFrame().finalizacion("correctamente");
                String mensaje = "Se subieron correctamente todos los archivos firmados. Recuerde refrescar la web o presionar Continuar para ver los cambios";
                JOptionPane.showMessageDialog(null, mensaje, "Firma Digital", 1);
                this.finalizar(1);
            } else {
                JOptionPane.showMessageDialog(this.getFrame(), "<html>Fallo la subida de uno o mas documentos: <br/>" + this.mensajeErrorSubida + "</html>", "error", 0);
                this.getFrame().finalizacion("con errores");
                this.finalizar(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("mensaje " + e.getMessage());
            JOptionPane.showMessageDialog(this.getFrame(), e.getMessage(), "error", 0);
        }
    }

    @Override
    public void informarProblemaIrrecuperable(String desc, String titulo) {
        JOptionPane.showMessageDialog(this.getFrame(), desc, titulo, 0);
        this.finalizar(1);
    }

    public void informarProblemaAlternativa(String desc, String titulo) {
        Object[] buttons = new String[]{"Si", "No"};
        int returnValue = JOptionPane.showOptionDialog(null, desc, titulo, 2, 0, null, buttons, buttons[0]);
        if (returnValue > 0) {
            this.finalizar(1);
        }
    }

    public void refrescarTabla() {
        if (this.getFrame() != null) {
            this.getFrame().refrescarTabla();
        }
    }

    public int getDocsProcesados() {
        return this.getCantDocEnEstados(this.estadoApp.getEstadoPrevio(), this.estadoApp.getEstadoCompleto());
    }

    public void documentoInvalido(Documento doc) {
        doc.setEstado(EstadoDoc.INVALIDO);
        ArrayList<Documento> docsAux = new ArrayList<Documento>();
        for (Documento documento : this.documentos) {
            if (documento.getId() == doc.getId()) continue;
            docsAux.add(documento);
        }
        this.documentos = docsAux;
        this.documentosInvalidos.add(doc);
        this.getFrame().refrescarIdTabla(doc.getId());
    }

    public int getCantDocEnEstados(EstadoDoc estado, EstadoDoc estado2) {
        int bandera = 0;
        for (Documento doc : this.documentos) {
            if (!doc.getEstado().equals((Object)estado) && !doc.getEstado().equals((Object)estado2)) continue;
            ++bandera;
        }
        return bandera;
    }

    public Consola getFrame() {
        return this.frame;
    }

    public String getUrlDocumentos() {
        return this.urlBase;
    }

    public List<Documento> getDocumentos() {
        return this.documentos;
    }

    void setDocumentos(List<Documento> documentos) {
        this.documentos = documentos;
    }

    public int getCantDocumentos() {
        return this.documentos.size();
    }

    public List<Token> getTokens() {
        return this.certController.getTokens();
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setLabelBarra(String string) {
        if (this.getFrame() != null) {
            this.getFrame().setLabelBarra(string);
        }
    }

    public ProgressWorker getProgressWorker() {
        return this.progressWorker;
    }

    public void setProgressWorker(ProgressWorker progressWorker) {
        this.progressWorker = progressWorker;
    }

    public void finalizarProgressWorker() {
        if (this.progressWorker != null) {
            this.progressWorker.cancel(true);
            this.progressWorker.isDone();
        }
    }

    public abstract void run();

    public abstract ModoDeEjecucion getModoEjecucion();

    public String getIdUsuario() {
        return this.idUsuario;
    }

    public CertController getCertController() {
        return this.certController;
    }

    public void setMetadatos(JsonObject jsonObject) {
        this.metadatos = new Metadatos();
        this.metadatos.fromJson(jsonObject);
        this.documentos = this.metadatos.getDocumentos();
    }

    public Metadatos getMetadatos() {
        return this.metadatos;
    }

    protected void descargarMetadatos() {
        this.estadoApp = EstadoApp.DESCARGA_METADATOS;
        WorkerDescargaMetadatos wMetadatos = new WorkerDescargaMetadatos(this);
        wMetadatos.execute();
        try {
            wMetadatos.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected void iniciarCertController(PrincipalBase unPrincipal) {
        boolean firmaConTokenHardExcluyente;
        this.certController = CertController.getInstance();
        this.certController.setCallback(this);
        boolean bl = firmaConTokenHardExcluyente = this.getModoEjecucion() != null && this.getModoEjecucion().equals((Object)ModoDeEjecucion.CARGA_RECIBOS);
        if (firmaConTokenHardExcluyente) {
            this.certController.esExcluyenteTokenHard();
        }
        this.certController.executeWorkerToken();
    }

    public LocalDate calcularFechaPorDefecto() {
        return this.metadatos.getModuloRecibos().calcularFechaPorDefecto(this.documentos.get(0).getFileName());
    }

    public boolean patronContieneTipo() {
        return this.metadatos.getModuloRecibos().patronConTipoRecibo();
    }

    public boolean patronContieneFechaCompleta() {
        return this.metadatos.getModuloRecibos().patronConFechaCompleta();
    }

    public Certificado obtenerCertificadoPorAlias(String alias) {
        return this.certController.obtenerCertificadoPorAlias(alias);
    }

    public void actualizarConfDisconf() {
        this.metadatos.getModuloRecibos().actualizarConfDisconf();
    }

    public boolean hayTokensConectados() {
        return this.certController.tokensConectados() > 0;
    }

    @Override
    public void tokenConectado() {
        this.getFrame().nuevoTokenConectado();
    }
}

